#import <Cocoa/Cocoa.h>
#import <QuartzCore/QuartzCore.h>

typedef enum
{
	kDoNothing,
	kMakeKeyAndOrderFront,
	kOrderFront,
	kOrderOut
} ScalingViewPostZoomAction;

@interface NSWindow (PCScaling)

- (NSRect)pc_adjustZoomRectForWindowSize:(NSRect)startRect;

- (void)pc_zoomWindowCloseWithEndingRect:(NSRect)endRect;
- (void)pc_zoomWindowCloseWithEndingRect:(NSRect)endRect delegate:(id)delegate;
- (void)pc_zoomWindowOpenWithStartingRect:(NSRect)startRect makeKey:(BOOL)makeKeyWhenDone delegate:(id)delegate;
- (void)pc_zoomWindowOpenWithStartingRect:(NSRect)startRect;
- (void)pc_zoomWindowOpenWithStartingRect:(NSRect)startRect delegate:(id)delegate;

@end


@interface ScalingImageView : NSView
{
	CALayer			*scalingLayer;
	
	CATransform3D	endTransform;
	CGSize			imageSize;
	CFTimeInterval	duration;

	NSWindow*					zoomingWindow;
	ScalingViewPostZoomAction	postZoomAction;
	NSObject		*iDelegate;
}

@property (readwrite, retain) NSObject *delegate;

- (id)initWithFrame:(NSRect)aRect contentImageRef:(CGImageRef)ref;

- (void)setStartRect:(NSRect)startRect;
- (void)setEndRect:(NSRect)endRect;

- (void)setZoomingWindow:(NSWindow*)aWindow postZoomAction:(ScalingViewPostZoomAction)action;

- (void)animate;

@end

@interface NSObject (PCZoomingWindowDelegate)

- (void)pc_windowDidZoom:(NSWindow*)window;

- (CFTimeInterval)pc_windowAnimationDuration:(NSWindow*)window;

@end
