//
//  PCAppearanceView.h
//  Coda
//
//  Created by Will Cosgrove on 10/25/07.
//  Copyright 2007 Panic Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef enum
{
	kActiveState,
	kInactiveState,
	/*kDisabledState unsupported currently */
} PCAppearanceState; 


@interface PCAppearanceView : NSView
{
	id	iDelegate;
}

// callback selector is -(void)appearanceView:(PCAppearanceView*)aView stateDidChange:(PCAppearanceState)aState
- (void)setDelegate:(id)aDelegate;

// subclass hook to allow views to change their own appearance
- (void)appearanceStateDidChange:(PCAppearanceState)aState;

- (PCAppearanceState)appearanceState;

@end

@protocol PCAppearanceViewDelegate

-(void)appearanceView:(PCAppearanceView*)aView stateDidChange:(PCAppearanceState)aState;

@end
