//
//  PCAuthorizationManager.h
//  PanicCore
//
//  Created by Wade Cosgrove on 8/18/10.
//  Copyright 2010 Panic, Inc. All rights reserved.
//

#import "PCSharedInstance.h"


@interface PCAuthorizationManager : PCSharedInstance
{
	AuthorizationRef iAuthorizationRef;
}

- (BOOL)chmodWithPrivilegesItemAtPath:(NSString*)path withPermissions:(NSString*)perms recursive:(BOOL)recursive error:(NSError**)error;
- (BOOL)chownWithPrivilegesItemAtPath:(NSString*)path withOwner:(NSString*)owner group:(NSString*)group recursive:(BOOL)recursive error:(NSError**)error;

// private-like, used for internal implmentation, but can be used manually if desired

- (OSStatus)executeWithPrivileges:(const char*)cmdPath arguments:(char * const *)arguments output:(NSString**)output error:(NSError**)error;

@end
