#import <Cocoa/Cocoa.h>
#import <Quartz/Quartz.h>

@interface PCButtonLayer : CALayer
{
	BOOL			iHighlighted;
	__weak NSObject	*iEventDelegate;
}

@property(nonatomic, assign) BOOL highlighted;
@property(nonatomic, assign) __weak NSObject *eventDelegate;

- (void)trackMouseDownEvent:(NSEvent*)event inView:(NSView*)eventView;

@end


@interface NSObject (PCButtonLayerDelegate)

- (BOOL)mouseDragged:(NSEvent*)event inButtonLayer:(PCButtonLayer*)layer;
- (void)mouseUp:(NSEvent*)event inButtonLayer:(PCButtonLayer*)layer;

@end
