/*
 *  PCColorLabelView.h
 *
 *  Requires Mac OS X 10.5 or higher
 *
 *
 *	Is a view that provies a Finder-like view for setting label colors
 *
 *	-------------------------------------------------------------------
 *
 *
 */
 
#import <Cocoa/Cocoa.h>

@class PCInfoBubblePanel;

@interface PCColorLabelView : NSView
{
	NSMutableIndexSet *selectedLabelColors;

	NSUInteger rolloverLabelColor;
	NSTextField *rolloverLabelField;
	NSTextField *labelField;
	
	BOOL		iUseDarkAppearance;	// when YES, draws in a way appropriate for dark backgrounds
	BOOL		isEnabled;
	id			target;
	SEL			action;

	// bubble label support

	PCInfoBubblePanel *iBubblePanel;
	BOOL iShowsLabelNameBubble;
	BOOL iBubbleSelectorHasBeenDispatched;
}

- (NSUInteger)label;
- (void)setLabel:(NSUInteger)index; // 0 is none
- (NSIndexSet*)labels;
- (void)setLabels:(NSIndexSet*)indexes;
- (void)setControlSize:(NSControlSize)size;
- (void)setLabelFontSize:(CGFloat)size; // should usually use setControlSize, this method is for action menus mainly

// optional methods to use when not in a menu

- (void)setEnabled:(BOOL)flag;

- (void)setAction:(SEL)anAction;
- (void)setTarget:(id)aTarget;

- (void)setLabelHidden:(BOOL)flag;			// the "Label:" text above the circles
- (void)setColorLabelHidden:(BOOL)flag; 	// the label under the circles
- (void)setShowsColorLabelBubble:(BOOL)flag;	// floating bubble that shows the color
- (void)setUsesDarkAppearance:(BOOL)flag;

- (BOOL)isColorLabelHidden;
- (BOOL)isLabelHidden;
- (BOOL)showsColorLabelBubble;
- (BOOL)usesDarkAppearance;

@end
