#import <Cocoa/Cocoa.h>

@interface PCComputerSleep : NSObject
{
	io_connect_t			root_port;
	io_object_t				notifier;
	IONotificationPortRef	notify;	
	NSObject *iDelegate;
}

@property (nonatomic, assign) NSObject *delegate;
@property (readonly) io_connect_t rootPort;

- (void)setListenForSleepNotifications:(BOOL)flag;

@end

@interface NSObject (PCComputerSleepDelegate)
- (void)computerWillGoToSleep:(PCComputerSleep*)sleep;
- (BOOL)shouldComputerGoToSleep:(PCComputerSleep*)sleep;
@end