#import <Cocoa/Cocoa.h>

/*
 *  PCCrossfade.h
 *
 *  Requires Mac OS X 10.5 or higher
 *
 *	Uses core animation to crossfade a single view between two different states.
 *
 *	---------------------------------------------------------------------------
 *
 *	Example:
 *
 *  Create crossfader, and cache start image
 *  do some stuff to the view
 *  run animation
 */
 

@interface PCCrossfade : NSObject 
{
	NSView *iLayerView;
	NSView *iTargetView;

	CGImageRef iEndImageRef;
	CGImageRef iStartImageRef;
	
	CFTimeInterval iDuration;
	
	NSObject *iDelegate;
}

@property CFTimeInterval duration;
@property (retain) NSObject* delegate;

- (id)initWithView:(NSView*)view cacheStartImage:(BOOL)flag;

- (void)runAnimation;

// semi-private

- (void)cacheEndImage:(NSView*)view;
- (void)cacheStartImage:(NSView*)view;

- (void)cacheEndImage:(NSView*)view fromRect:(NSRect)rect;
- (void)cacheStartImage:(NSView*)view fromRect:(NSRect)rect;

@end


@interface NSObject (PCCrossfadeDelegate)

- (void)crossfadeDidFinish:(PCCrossfade*)fade;

@end
