#import <Cocoa/Cocoa.h>


@interface PCFilePopUpButtonCell : NSPopUpButtonCell
{
	NSImage	*arrow;
	NSColor	*iArrowColor;
	NSColor *iHighlightOverlayColor;
	BOOL	isHighlightedForDrop;
}

@property (retain) NSColor *arrowColor;
@property (retain) NSColor *highlightOverlayColor;

- (void)setArrowColor:(NSColor*)aColor;

- (void)createArrow;
- (void)setArrow:(NSImage*)inArrow;
- (void)setHighlightOverlayColor:(NSColor*)aColor;
- (void)setHighlightedForDrop:(BOOL)flag;
- (BOOL)isHighlightedForDrop;

- (void)drawDropHighlightInRect:(NSRect)aRect;

@end


@interface PCFilePopUpButton : NSPopUpButton
{

}

- (void)setArrowColor:(NSColor*)aColor;
- (void)setHighlightOverlayColor:(NSColor*)aColor;

- (void)configure;

@end

@protocol PCFilePopUpButton

- (void)fileDroppedOnNavigationPopup:(NSString*)path;

@end 