#import <Cocoa/Cocoa.h>

/* Flips between views, based on MFFlipController by Mike Lee and Lucas Newman.
 *
 *
 */

@class CAAnimationGroup;
@class CAMediaTimingFunction;

@interface PCFlip : NSObject
{
	NSView *iLayerView;
	NSView *iInView;
	NSView *iOutView;
	
	CFTimeInterval	iDuration;
	CAMediaTimingFunction *iTimingFunction;
	BOOL		iRotateClockwise;
	
	CGFloat		iScale;
    //NSInteger	iDistortion;
	
	NSObject *iDelegate;
	NSDictionary *iUserInfo;
}


@property CFTimeInterval duration;
@property (retain) NSObject* delegate;
@property (retain) NSView *inView;
@property (retain) NSView *outView;
@property (assign) BOOL clockwise;
@property (copy) CAMediaTimingFunction *timingFunction;
@property (assign) CGFloat scale;
@property (nonatomic, copy) NSDictionary *userInfo;

+ (PCFlip*)flipperWithIncomingView:(NSView*)inView outgoingView:(NSView*)outView clockwise:(BOOL)clockwise;

- (id)initWithIncomingView:(NSView*)inView outgoingView:(NSView*)outView clockwise:(BOOL)clockwise;

- (void)runAnimationWaitUntilDone:(BOOL)waitUntilDone;
- (void)runAnimation;

@end


@interface NSObject (PCFlipDelegate)

- (void)flipDidFinish:(PCFlip*)flip;

@end