//
//  PCGradientButton.h
//  CustomControlsDemo
//
//  Created by Wade Cosgrove on 3/27/06.
//  Copyright 2006 Panic, Inc. All rights reserved.
//

#import "PCControlsConfiguration.h"
#import <PanicCore/Protocols.h>

@interface PCGradientButton : NSButton
{
	NSObject <PCViewDraggingDelegateProtocol> * iDraggingDelegate;
}

@property (assign, readwrite) NSObject *draggingDelegate;

- (PCControlBezelStyle)gradientBezelStyle;
- (void)setGradientBezelStyle:(PCControlBezelStyle)style;

- (PCControlGradientStyle)gradientStyle;
- (void)setGradientStyle:(PCControlGradientStyle)style;

- (void)setCornerRadius:(CGFloat)radius;
- (CGFloat)cornerRadius;

- (void)setFillGradient:(NSGradient*)gradient;
- (NSGradient*)fillGradient;

- (void)setHighlightedFillGradient:(NSGradient*)gradient;
- (NSGradient*)highlightedFillGradient;

- (NSColor*)bezelColor;
- (void)setBezelColor:(NSColor*)bezelColor;

@end
