//
//  PCGradientButtonCell.h
//  CustomControlsDemo
//
//  Created by Wade Cosgrove on 3/27/06.
//  Copyright 2006 Panic, Inc. All rights reserved.
//

#import <PanicCore/PCControlsConfiguration.h>

@interface PCGradientButtonCell : NSButtonCell
{
	NSGradient	*iFillGradient;
	NSGradient	*iHighlightedFillGradient;
	NSColor		*iBezelColor;
	CGFloat		iCornerRadius;
	PCControlBezelStyle		bezelStyle;
	PCControlGradientStyle	gradientStyle;
	
	NSBezierPath		*buttonPath;
}

@property (assign, readwrite) CGFloat cornerRadius;
@property (retain, readwrite) NSColor *bezelColor;
@property (retain, readwrite) NSGradient *fillGradient;
@property (retain, readwrite) NSGradient *highlightedFillGradient;

- (PCControlBezelStyle)gradientBezelStyle;
- (void)setGradientBezelStyle:(PCControlBezelStyle)style;

- (PCControlGradientStyle)gradientStyle;
- (void)setGradientStyle:(PCControlGradientStyle)style;

- (void)updateButtonPath;

@end
