#import <Cocoa/Cocoa.h>
#import <PanicCore/Protocols.h>


@interface PCGradientPathControl : NSPathControl 
{
	BOOL	iShowsStar;
	SEL		iMenuAction;
	BOOL	iSpringOpenEnabled;
	BOOL 	iHighlightLastPathCell;
	NSTimer	*iSpringTimer;
	
	NSString *iTruncatedPathPrefix;
	NSObject <PCViewDraggingDelegateProtocol> * iDraggingDelegate;
}

@property (assign, readwrite) NSObject *draggingDelegate;
@property (assign) BOOL showsStar;
@property (assign) SEL menuAction;
@property (assign) BOOL springOpenEnabled;
@property (assign) BOOL highlightLastPathCell;

- (void)setPath:(NSString*)path;
- (void)setPath:(NSString*)path lastComponentIcon:(NSImage*)image;

- (NSString*)clickedPath;

- (void)controlTintDidChange:(NSNotification*)notification;

@end


@interface PCGradientPathCell : NSPathCell
{}

+ (Class)pathComponentCellClass;

@end


@interface PCGradientPathComponentCell : NSPathComponentCell
{
	BOOL iHighlightLastPathCell;
}

+ (NSImage*)backgroundFill;
+ (NSColor*)bezelColor;
+ (NSBezierPath*)caretPathForFill:(BOOL)useForFill;
+ (NSImage*)selectedBackgroundFill;
+ (void)buildControlImages;
+ (void)buildColorControlImages;

@end


@interface NSPathComponentCell (PrivateToPublicMethods)

- (float)_minWidth;

@end


@interface NSEvent (ModifyLocation)

- (NSEvent*)eventWithMouseLocation:(NSPoint)point;

@end


@interface NSObject ( PCGradientPathControlDelegate )

- (void)gradientPathControl:(PCGradientPathControl*)control springOpenComponentAtIndex:(NSInteger)index;

@end
