//
//  PCGradientRadioButton.h
//  Slider
//
//  Created by Wade Cosgrove on 5/13/09.
//  Copyright 2009 Panic, Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface PCGradientRadioButton : NSButton 
{

}

@end


@interface PCGradientRadioButtonCell : NSButtonCell 
{
	NSColor		*iTextColor;
	NSGradient	*iFillGradient;
	NSColor		*iBezelColor;
	NSColor		*iDotColor;
	BOOL		iUseHUDAppearance;
	BOOL		iDrawRecessed;
}

@property (retain) NSColor*		textColor;
@property (assign) BOOL			useHUDAppearance;
@property (retain) NSGradient*	fillGradient;
@property (retain) NSColor*		bezelColor;
@property (retain) NSColor*		dotColor;
@property (assign) BOOL			drawRecessed;

- (void)setUseDarkAppearance:(BOOL)flag;

@end


@interface NSButtonCell (GradientButtonCellPrivateToPublic)

- (NSDictionary*)_textAttributes;

@end
