#import <Cocoa/Cocoa.h>
#import <QuartzCore/QuartzCore.h>

@interface PCGridMenuItemLayer : CALayer
{
	CALayer		*iImageLayer;
	CATextLayer *iTitleLayer;
	CALayer		*iAccessoryLayer;
	
	IconRef		iIconRef;
	BOOL		iHighlighted;
	BOOL		iDropHighlighted;
	BOOL		iKeyLayer;

	CGImageRef	iAccessoryImage;
	CGImageRef	iAccessoryRolloverImage;
	
	__weak NSObject *iEventDelegate;
}

@property (nonatomic, assign) __weak NSObject *eventDelegate;
@property (nonatomic, readonly) BOOL accessorySupportsRollover;
@property (nonatomic, readwrite, getter=isKeyLayer) BOOL keyLayer;

- (CALayer*)init;
- (NSString*)title;

- (void)setAccessoryImage:(NSImage*)anImage;
- (void)setAccessoryRolloverImage:(NSImage*)anImage;
- (void)setAccessoryHighlighted:(BOOL)flag;
- (void)setAccessoryRolloverHighlighted:(BOOL)flag;
- (NSTrackingArea*)accessoryTrackingAreaForView:(NSView*)trackingView;

- (void)setIconRef:(IconRef)ref;
- (void)setTitle:(NSString*)title;
- (void)setDropHighlighted:(BOOL)flag;
- (void)setHighlighted:(BOOL)flag;

- (NSImage*)dragImage;
- (void)setDragging:(BOOL)flag;

- (BOOL)isPointInAccessoryLayer:(CGPoint)point;
- (NSRect)tooltipRectForView:(NSView*)tooltipView;

- (void)trackMouseDownEvent:(NSEvent*)anEvent inView:(NSView*)eventView;

@end


@interface NSObject (GridMenuItemEventDelegate)

- (void)mouseUp:(NSEvent*)event inGridMenuItemLayer:(PCGridMenuItemLayer*)layer inAccessoryLayer:(BOOL)inAccessory;
- (BOOL)mouseDragged:(NSEvent*)event inGridMenuItemLayer:(PCGridMenuItemLayer*)layer; // return YES to begin drag

@end
