#import <Cocoa/Cocoa.h>

typedef enum
{
	PCGridMenuDropOn,
	PCGridMenuDropBefore,
	PCGridMenuDropAfter
} PCGridMenuDropOperation;


@class PCGridMenuItemLayer;

@interface PCGridMenuView : NSView 
{
	__weak NSObject	*iRepresentedObject;
	__weak NSObject	*iTarget;
	
	__weak NSObject	*iDelegate;
	__weak NSObject	*iDataSource;

	SEL			iAction;
	SEL			iAccessoryAction;
	
	BOOL		iNeedsLayout;
	BOOL		iNeedsReload;
	NSUInteger	iNumberOfGroups;
	NSUInteger	*iGroupItemCounts;
	NSUInteger	*iDividerYLocations;
	
	NSUInteger	iClickedGroup;
	NSUInteger	iClickedItemIndex;
	NSInteger	iKeyLayerIndex;
	
	PCGridMenuItemLayer	*iAddItemLayer;
	
	NSMutableArray *iAccessoryTrackingAreas;
	NSMutableArray *iTooltips;
	
	// drag and drop
	
	NSUInteger	iDragSourceGroup;
	NSUInteger	iDragSourceItemIndex;
	NSUInteger	iDragTargetItemIndex;
	PCGridMenuItemLayer	*iDragInteractionLayer; // either the target layer, or the layer being reordered
	CALayer		*iDragInsertionLayer;
}


@property(nonatomic, readonly) NSUInteger clickedGroup;
@property(nonatomic, readonly) NSUInteger clickedItemIndex;
@property(nonatomic, assign) __weak NSObject* delegate;
@property(nonatomic, assign) __weak NSObject* dataSource;
@property(nonatomic, assign) __weak NSObject* representedObject;
@property(nonatomic, assign) __weak NSObject* target;
@property(nonatomic) SEL action;
@property(nonatomic) SEL accessoryAction;

- (void)reloadData;

- (void)runOpenAnimation;
- (void)runCloseAnimation;

@end


@interface NSObject (PCGridMenuViewDataSource)

- (NSUInteger)gridMenuViewNumberOfItemsInGroup:(NSUInteger)groupIndex;

- (IconRef)gridMenuView:(PCGridMenuView*)gridMenu iconRefForItemAtIndex:(NSUInteger)itemIndex ofGroup:(NSUInteger)groupIndex;
- (NSString*)gridMenuView:(PCGridMenuView*)gridMenu titleForItemAtIndex:(NSUInteger)itemIndex ofGroup:(NSUInteger)groupIndex;

// optional
- (NSUInteger)gridMenuViewNumberOfGroups:(PCGridMenuView*)gridMenu;
- (NSImage*)gridMenuView:(PCGridMenuView*)gridMenu accessoryImageForItemAtIndex:(NSUInteger)itemIndex ofGroup:(NSUInteger)groupIndex;
- (NSImage*)gridMenuView:(PCGridMenuView*)gridMenu accessoryRolloverImageForItemAtIndex:(NSUInteger)itemIndex ofGroup:(NSUInteger)groupIndex;
- (NSString*)gridMenuView:(PCGridMenuView*)gridMenu tooltipForItemAtIndex:(NSUInteger)itemIndex ofGroup:(NSUInteger)groupIndex;

@end


@interface NSObject (PCGridMenuViewDelegate)

- (void)beginEditingGridMenuView:(PCGridMenuView*)gridMenu;
- (BOOL)gridMenuView:(PCGridMenuView*)gridMenu keyDown:(NSEvent*)event forItemAtIndex:(NSUInteger)itemIndex ofGroup:(NSUInteger)groupIndex;

// drag and drop
- (BOOL)gridMenuView:(PCGridMenuView*)gridMenu canDragItemAtIndex:(NSUInteger)itemIndex fromGroup:(NSUInteger)groupIndex;
- (void)gridMenuView:(PCGridMenuView*)gridMenu moveItemAtIndex:(NSUInteger)itemIndex toIndex:(NSUInteger)newIndex inGroup:(NSUInteger)groupIndex;
- (void)gridMenuView:(PCGridMenuView*)gridMenu removeItemAtIndex:(NSUInteger)itemIndex ofGroup:(NSUInteger)groupIndex;
- (BOOL)gridMenuView:(PCGridMenuView*)gridMenu acceptDrop:(id <NSDraggingInfo>)info atIndex:(NSUInteger)itemIndex ofGroup:(NSUInteger)groupIndex dropOperation:(PCGridMenuDropOperation)operation;
- (NSDragOperation)gridMenuView:(PCGridMenuView*)gridMenu validateDrop:(id <NSDraggingInfo>)info atIndex:(NSUInteger)itemIndex ofGroup:(NSUInteger)groupIndex dropOperation:(PCGridMenuDropOperation)operation;

@end



@interface PCGridMenuWindow : NSWindow
{
	__weak PCGridMenuView *iGridMenuView;
}

- (void)animateOpenAtPoint:(NSPoint)point;
- (void)animateClose;

- (PCGridMenuView*)gridMenuView;

@end