//
//  PCIconCache.h
//  Coda
//
//  Created by Wade Cosgrove on 10/3/08.
//  Copyright 2008 Panic, Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface PCIconCache : NSObject
{
	NSMutableDictionary *activeIconCache;
	NSMutableDictionary *pendingFlushIconCache;
}

- (NSImage*)iconForPath:(NSString*)aPath;		// gets icon at path and adds to active cache

- (void)discardActiveIconCache;					// moves all active icons to pending flush
- (void)discardIconForPath:(NSString*)aPath;	// moves icon at path to pending flush
- (void)discardIconsForPaths:(NSArray*)paths;	// moves icons at paths to pending flush

- (void)emptyAllCache;							// removes all icons from both caches
- (void)emptyInactiveIconCache;					// removes all icons from inactive caches

@end
