#import <Cocoa/Cocoa.h>

/*
 *  PCIconServices.h
 *
 *  Requires Mac OS X 10.4 or higher
 *
 *	A general wrapper for the Icon Manager and Icon Services API with code from IconFamily class.
 *	Allows the user to generate an IconRef from a given set of images.
 *
 *	-------------------------------------------------------------------
 *
 *
 */

@interface PCIconServices : NSObject
{

}

+ (IconRef)createIconRefFor512Image:(NSImage*)hugeIcon thumbnailImage:(NSImage*)thumbnailIcon normalImage:(NSImage*)normalIcon smallImage:(NSImage*)smallImage;
+ (IconRef)createIconRefForThumbnailImage:(NSImage*)thumbnailIcon normalImage:(NSImage*)normalIcon smallImage:(NSImage*)smallImage;
+ (IconRef)iconRefFromICNSFile:(NSString*)path; // returns a retained icon ref, user should release when done

// private internal methods

+ (Handle)get1BitMaskFromBitmapImageRep:(NSBitmapImageRep*)bitmapImageRep requiredPixelSize:(int)requiredPixelSize;
+ (Handle)get32BitDataFromBitmapImageRep:(NSBitmapImageRep*)bitmapImageRep requiredPixelSize:(int)requiredPixelSize;
+ (Handle)get8BitDataFromBitmapImageRep:(NSBitmapImageRep*)bitmapImageRep requiredPixelSize:(int)requiredPixelSize;
+ (Handle)get8BitMaskFromBitmapImageRep:(NSBitmapImageRep*)bitmapImageRep requiredPixelSize:(int)requiredPixelSize;

+ (BOOL)setIconFamilyElement:(OSType)elementType fromBitmapImageRep:(NSBitmapImageRep*)bitmapImageRep inHandle:(IconFamilyHandle)iconHandle;

@end




