/*
 *  PCIconTextFieldCell.h
 *
 *  Requires Mac OS X 10.5 or higher and NSImage-Additions category
 *
 *	Provides an icon cell that can show up to two icons in a text cell
 *
 *	-------------------------------------------------------------------
 *
 *
 */

#import <Cocoa/Cocoa.h>

typedef enum
{
	PCVerticalTextAlignmentNatural = 0,		// use NSCell default, which is top aligned
	PCVerticalTextAlignmentTop,				// aligned to the top
    PCVerticalTextAlignmentBottom,			// aligned to the bottom
    PCVerticalTextAlignmentCenter    		// centered
} PCVerticalTextAlignment;


@interface PCIconTextFieldCell : NSTextFieldCell
{
	BOOL iHighlightsText;
	BOOL iDrawsHighlightedTextInBold;
	NSDictionary* iHighlightedTextAttributes;
	NSImage* iImage;
	IconRef iIconRef;
	NSSize iImageSize;
	CGFloat iBaselineOffset;
	PCVerticalTextAlignment iVerticalTextAlignment;
	BOOL iControlViewIsTableView;
	BOOL iSelectsExtensionWhenEditing;
	BOOL iUsesTitleRectForSelection;
	NSCell* iAccessoryCell;
	NSSize iAccessorySize;
	NSGradient* iLabelGradient;
}

@property BOOL highlightsText;
@property BOOL drawsHighlightedTextInBold;
@property (retain) NSImage* image;
@property NSSize imageSize;
@property (assign) PCVerticalTextAlignment verticalTextAlignment;
@property BOOL selectsExtensionWhenEditing;
@property BOOL usesTitleRectForSelection;
@property (copy) NSCell* accessoryCell;
@property (assign) CGFloat baselineOffset;

- (void)calculateAccessorySize;

- (void)setAccessoryImage:(NSImage*)image;
- (void)setAccessoryAction:(SEL)selector;
- (void)setAccessoryTarget:(id)target;

- (void)setIconRef:(IconRef)aRef;
- (void)setLabelColor:(NSColor*)labelColor;

- (NSRect)accessoryRectForBounds:(NSRect)cellFrame;
- (NSRect)imageRectForBounds:(NSRect)cellFrame;
- (NSRect)titleRectForBounds:(NSRect)theRect;

- (void)drawImage:(NSImage*)image withFrame:(NSRect)frame inView:(NSView*)controlView;
- (void)drawIconRef:(IconRef)aRef withFrame:(NSRect)frame inView:(NSView*)controlView;
- (NSRect)dropFrameInRect:(NSRect)aRect;
- (NSRect)fieldEditorFrameForFrame:(NSRect)cellFrame;
- (void)updateFieldEditorSize;

- (NSAttributedString*)highlightedAttributedStringValue;

@end

@interface NSTextFieldCell (FocusRing)

- (NSRect)_focusRingFrameForFrame:(NSRect)frame cellFrame:(NSRect)cellFrame;

@end
