#import <Cocoa/Cocoa.h>
#import <PanicCore/Protocols.h>

typedef enum
{
	ImageButtonBackgroundEnabled,
	ImageButtonBackgroundDisabled,
	ImageButtonBackgroundHighlighted,
	/*ImageButtonBackgroundInactive - add support when needed*/
	ImageButtonBackgroundRollover,
	ImageButtonBackgroundOn
} PCImageButtonState;


@interface PCImageButton : NSButton 
{
	NSTrackingArea *iRolloverTrackingArea;
	NSObject <PCViewDraggingDelegateProtocol> * iDraggingDelegate;
}

@property (assign, readwrite) NSObject *draggingDelegate;

- (void)setBackgroundImage:(NSImage*)image forState:(PCImageButtonState)state;
- (void)setImageNamed:(NSString*)imageName forState:(PCImageButtonState)state;

@end


@interface PCImageButtonCell : NSButtonCell 
{
	NSImage *iEnabledLeftCap;
	NSImage *iEnabledFill;
	NSImage *iEnabledRightCap;

	NSImage *iDisabledLeftCap;
	NSImage *iDisabledFill;
	NSImage *iDisabledRightCap;

	NSImage *iHighlightedLeftCap;
	NSImage *iHighlightedFill;
	NSImage *iHighlightedRightCap;

	NSImage *iRolloverLeftCap;
	NSImage *iRolloverFill;
	NSImage *iRolloverRightCap;
	BOOL	iRolloverHighlighted;
	
	NSImage *iOnLeftCap;
	NSImage *iOnFill;
	NSImage *iOnRightCap;
}

@property (nonatomic, assign, getter=isRolloverHighlighted) BOOL rolloverHighlighted;

- (void)setBackgroundImage:(NSImage*)image forState:(PCImageButtonState)state;
- (BOOL)supportsRollover;

@end
