#import <Cocoa/Cocoa.h>
#import <PanicCore/Protocols.h>

@class PCHUDContentView;
@class PCImagePickerMenu;
@class PCImagePickerDismissWindow;
@class PCImagePickerMenuBackgroundView;
@class PCMenuItemView;

#define PCImageNameFavIcon		@"ImagePickerDefaultFavIcon"
#define PCImageNameCustom		@"ImagePickerUserCustom"


@interface PCImagePickerView : NSImageView 
{
	IBOutlet PCImagePickerMenu	*iMenu;
	IBOutlet PCMenuItemView		*iFavIconMenuItemView;
	IBOutlet PCMenuItemView		*iCustomImagenMenuItemView;

	NSString				*iSelectedImageName;
	BOOL					iRolloverHighlighted;
	__weak NSTrackingArea	*iRolloverArea;
	BOOL					iAlwaysShowPopUpArrow;
	
	PCImagePickerDismissWindow		*iDismissWindow;
	BOOL					iGraphiteAppearance;
	NSObject <PCViewDraggingDelegateProtocol> * iDraggingDelegate;
}

@property (nonatomic, retain, readonly) NSString* selectedImageName;
@property (nonatomic, assign) BOOL rolloverHighlighted;
@property (assign, readwrite) NSObject *draggingDelegate;
@property (assign, readwrite) BOOL alwaysShowPopUpArrow;

// private, but needs to be declared public so IB can see it

- (IBAction)choseImageInternal:(id)sender;

@end


@interface PCImagePickerMenu : NSPanel
{
	IBOutlet PCImagePickerMenuBackgroundView* iContentView;
}

- (NSArray*)menuViews;

@end


@interface PCImagePickerMenuBackgroundView :NSView
{
	NSBezierPath *iBackgroundPath;
	NSBezierPath *iBackgroundStrokePath;
	NSBezierPath *iBackgroundShadowPath;
}

- (NSBezierPath*)backgroundPathWithLineWidth:(CGFloat)lineWidth inset:(CGFloat)inset;

@end


@interface PCImagePickerDismissWindow : NSWindow
{
	PCImagePickerView *iImagePicker;
}

@property (nonatomic, retain) PCImagePickerView *imagePicker;

- (id)initWithFrame:(NSRect)frame;

@end