// Provides a white bubble window with blue text for displaying tooltip type info

#import <Cocoa/Cocoa.h>

@class PCInfoBubbleView;
@class PCShadowedTextField;

@interface PCInfoBubblePanel : NSPanel 
{
	__weak PCShadowedTextField	*iTextField;
	__weak PCInfoBubbleView		*iBubbleView;
}

- (PCInfoBubblePanel*)initWithString:(NSString*)string;

- (void)setStringValue:(NSString*)string;

- (void)fadeInAtPoint:(NSPoint)point;
- (void)fadeInAtPoint:(NSPoint)point overWindow:(NSWindow*)parentWindow;
- (void)fadeOut;

- (void)setUsesDarkAppearance:(BOOL)flag;

@end


@interface PCInfoBubbleView : NSView
{
	NSBezierPath *iBubblePath;
	BOOL iUseDarkAppearance;
}

@property (nonatomic, retain) NSBezierPath *bubblePath;
@property (nonatomic, assign) BOOL usesDarkAppearance;

@end
