#import <Cocoa/Cocoa.h>

@class PCMenuItemImageView;

@interface PCMenuItemView : NSView
{
	BOOL iHighlighted;
	BOOL iGraphiteAppearance;
	SEL iAction;
	id iTarget;
	id iRepresentedObject;
	BOOL iUsesDarkAppearance;
	__weak NSObject *iDelegate;
	
	__weak NSTextField	*iTitleField;
	__weak NSTrackingArea *iRolloverArea;
	__weak PCMenuItemImageView *iImageView;
	__weak NSView *iAccessoryView;
}

@property (assign) SEL action;
@property (assign) id target;
@property (retain) id representedObject;
@property (assign, getter=isHighlighted) BOOL highlighted;
@property (assign) __weak NSObject* delegate;

- (id)initWithTitle:(NSString*)title action:(SEL)action;

- (NSView*)accessoryView;
- (NSImage*)image;
- (NSString*)title;

- (void)setAccessoryView:(NSView*)accessoryView;
- (void)setImage:(NSImage*)image;
- (void)setTitle:(NSString*)title;
- (void)setUsesDarkAppearance:(BOOL)flag;

- (void)enableBackgroundEventHack;

@end

@interface NSObject (PCMenuItemViewDelegate)
- (void)menuItemViewDidChangeHighlight:(PCMenuItemView*)menuView;
@end

@interface PCMenuItemImageView : NSImageView
{}

@end
 
