#import <Cocoa/Cocoa.h>
#import <SystemConfiguration/SCNetworkReachability.h>

/*
 *  PCNetworkReachability.h
 *
 *  Requires Mac OS X 10.4 or higher
 *
 *	Provides a nice interface for determining if a machine is online
 *
 *	-------------------------------------------------------------------
 *
 *
 */
 
extern NSString* const PCNetworkStateChangedNotification;
extern NSString* const PCNetworkStateIsOnline;

@interface PCNetworkReachability : NSObject
{
	BOOL isOnline;
	SCNetworkReachabilityRef reachabilityRef;
	NSURL* url;
}

+ (id)sharedInstance;

+ (BOOL)isOnline;
+ (BOOL)isURLReachable:(NSURL*)aURL;

- (id)initWithURL:(NSURL*)aURL;

- (BOOL)isOnline;
- (NSURL*)url;

@end
