//
//  PCSlidingAnimation.h
//  DragImageMorphing
//
//  Created by Wade Cosgrove on 4/16/08.
//  Copyright 2008 Panic, Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class PCSlidingView;

@interface PCSlidingAnimation : NSAnimation
{
    NSMutableDictionary *views;
    BOOL paused;
}

- (BOOL)setDestinationForView:(NSView*)aView to:(NSRect)targetFrame duration:(NSTimeInterval)duration;
- (void)sendViewToDestination:(NSView*)aView;
- (void)stopView:(NSView*)aView;

- (BOOL)isPaused;
- (void)pause;
- (void)resume;

- (void)showNextFrame;
- (void)updateViewPosition:(PCSlidingView*)aSlider forTime:(NSTimeInterval)currentTime;

@end


@interface NSObject (SlidingAnimationDelegate)

- (void)animation:(PCSlidingAnimation*)animation willBeginSlidingView:(NSView*)aView;
- (void)animation:(PCSlidingAnimation*)animation didFinishSlidingView:(NSView*)aView;

@end


@interface PCSlidingView : NSObject
{
    NSView *view;
    NSRect startFrame;
    NSRect endFrame;
    NSTimeInterval startTime;
    NSTimeInterval duration;
}

//- (id)initWithStartFrame:(NSRect)aStartFrame endFrame:(NSRect)aEndFrame duration:(NSTimeInterval)interval;
- (id)initWithView:(NSView*)aView duration:(NSTimeInterval)interval;

- (NSRect)endFrame;
- (NSRect)frameForTime:(NSTimeInterval)currentTime;

- (void)setStartTime:(NSTimeInterval)aTime;
- (NSView*)view;

- (void)setDuration:(NSTimeInterval)interval;
- (void)setEndFrame:(NSRect)aFrame;
- (void)setStartFrame:(NSRect)aFrame;

@end
