//
//  PCSlidingViewsBar.h
//  DragImageMorphing
//
//  Created by Wade Cosgrove on 4/16/08.
//  Copyright 2008 Panic, Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@class DragImageAnimator;
@class PCChevronPopUpButton;
@class PCSlidingAnimation;


@protocol SlidingViewProtocol
- (NSImage*)dragImage;
+ (NSString*)dragReorderPboardType;
@end


@interface PCSlidingViewsBar : NSView 
{
    NSInteger dragSourceIndex;
    NSInteger dropIndex;
    CGFloat draggedItemWidth;
    NSMutableArray *buttons;
    NSPopUpButton *clipButton;
	BOOL needsLayout;
	PCSlidingAnimation	*animation;

	// new
	
	NSInteger		iFirstVisibleButtonIndex;
	NSInteger		iNumberOfVisibleButtons;
	BOOL			iAlwaysShowSelectedButton; // allows the first visible tab index to be non-zero

	// delegate
	
	IBOutlet id	delegate;
	BOOL	delegateSupportsViewMoving;		// allows moving a view from one view to another
	BOOL	delegateSupportsViewTearOff;	// allows moving a view to a new window
}

@property (nonatomic, assign) BOOL alwaysShowSelectedButton; 
@property (nonatomic, assign) NSInteger firstVisibleButtonIndex;
@property (nonatomic, readonly) NSInteger numberOfVisibleButtons;

- (void)insertInButtons:(NSView*)button;
- (void)insertInButtons:(NSView*)button atIndex:(NSInteger)index;
- (void)removeFromButtonsAtIndex:(NSInteger)index;
- (NSView*)buttonAtIndex:(NSInteger)index;

//- (void)replaceInButtons:(NSView*)button atIndex:(NSInteger)index;

- (void)setClipIndicatorButton:(NSPopUpButton*)aButton;
- (void)setClipIndicatorVisible:(BOOL)flag;
- (BOOL)isClipIndicatorVisible;
- (void)updateClippingMenu;

- (id)delegate;
- (void)setDelegate:(id)newDelegate;

- (NSView*)firstKeyView;
- (NSView*)lastKeyView;

// layout

- (CGFloat)minButtonY;
- (CGFloat)minButtonX;
- (CGFloat)paddingBetweenButtons;

- (CGFloat)maxButtonXWithClipIndicator:(BOOL)includingIndicator;
- (CGFloat)maxButtonX;

- (void)layoutButtons;
- (NSRect)frameWithProposedFrame:(NSRect)inFrame forButton:(NSView*)button; // given a proposed frame, returns the actual frame

// internal action

- (void)selectedItemFromClippingMenu:(id)sender;

//- (CGFloat)minSlidingViewX; // the x origin of the first button while dragging is taking place

// drag and drop


- (void)moveDraggedButtonToView:(PCSlidingViewsBar*)targetView atIndex:(NSInteger)targetIndex;
- (BOOL)canMoveButtonsToNewViewViaDrag;
- (BOOL)performNewWindowDragOperation:(NSDragOperation)operation atPoint:(NSPoint)aPoint;

- (NSDragOperation)draggingEntered:(id <NSDraggingInfo>)sender;
- (void)draggingExited:(id <NSDraggingInfo>)sender;
- (NSDragOperation)draggingUpdated:(id <NSDraggingInfo>)sender;

- (NSInteger)dropIndexFromDraggingInfo:(id <NSDraggingInfo>)sender; // drop index based on drag image location
- (NSInteger)dropIndexFromLocalPoint:(NSPoint)localPoint; // drop index based on point position
- (void)setDropIndex:(NSInteger)newIndex;

- (CGFloat)slidingWidthForView:(NSView*)aView; // width of view while a drag in progress

- (CGFloat)widthOfDraggingInfo:(id<NSDraggingInfo>)draggingInfo; // width of drag image

- (void)slideButtonsIntoPlace; // begins drag animation, moves buttons to correct location

//- (void)moveSlidingViewToCurrentDropIndex:(id)fp8; // drop ended from another drag source
//- (void)reorderedSlidingView:(NSView*)draggedView; // drop ended, moving view is inserted into correct location
- (void)draggedSlidingView:(NSView <SlidingViewProtocol> *)draggedView; // called from button when dragging should start
//- (NSInteger)dragSourceIndex;

@end


@interface NSObject (SlidingViewsBarDelegate)

// allows moving a view from one view to another
- (void)slidingViewsBar:(PCSlidingViewsBar*)slidingView movedViewAtIndex:(NSInteger)oldIndex toView:(PCSlidingViewsBar*)sourceBar atIndex:(NSInteger)newIndex;

// reordering views in same view
- (void)slidingViewsBar:(PCSlidingViewsBar*)slidingView movedViewFromIndex:(NSInteger)oldIndex toIndex:(NSInteger)newIndex;

// allows moving a view to a new window
- (NSWindow*)slidingViewsBar:(PCSlidingViewsBar*)slidingView windowForViewAtIndex:(NSInteger)buttonIndex;
// informs delegate to finalize the button moving to the new window
- (BOOL)slidingViewsBar:(PCSlidingViewsBar*)slidingView moveViewAtIndex:(NSInteger)buttonIndex toWindow:(NSWindow*)aWindow;

@end