//
//  PCSplitTextField.h
//  ESControlPalettes
//
//  Created by Ian Cely on 6/19/06.
//  Copyright 2006 Panic Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

extern NSString* const PCSplitTextFieldDidSelectFrame;

@class PCFieldEditorShadowView;

@interface PCSplitTextField : NSTextField 
{
	NSTrackingRectTag 	rolloverTrackingRectTag;
	NSRect				rolloverTrackingRect;
	NSTimer*			resetTrackingRectTimer;
}

- (NSString*)labelString;
- (void)setLabelString:(NSString*)aString;

- (NSString*)placeholderString;
- (void)setPlaceholderString:(NSString*)aString;

// private

- (void)clearTrackingRect;
- (void)initializeInterface;
- (void)resetTrackingRect;
- (void)resetTrackingRectTimerDidFire:(NSTimer*)aTimer;
- (NSRect)rolloverTrackingRect;
- (void)startResetTrackingRectTimer;

@end


@interface NSObject (PCSplitTextFieldDragDelegate)

- (NSDragOperation)splitTextField:(PCSplitTextField*)textField dragOperationForInfo:(id <NSDraggingInfo>)draggingInfo;
- (NSString*)splitTextField:(PCSplitTextField*)textField acceptDropWithInfo:(id <NSDraggingInfo>)draggingInfo;

@end




@interface PCSplitTextFieldCell : NSTextFieldCell
{
	NSAttributedString*		labelAttrString;
	NSMutableDictionary*	labelAttributes;
	NSMutableDictionary*	labelRolloverAttributes;
	NSMutableDictionary*	labelDisabledAttributes;
	NSBezierPath*			labelRolloverPath;
	NSColor*				originalTextColor;

	BOOL					showsRollover;
	BOOL					rolloverIsDirty;
	NSBezierPath*			rolloverPath;

	NSMutableDictionary*	placeholderAttributes;
	NSMutableDictionary*	placeholderRolloverAttributes;
	BOOL					isEditing;
	NSString*				originalEditString;
	PCFieldEditorShadowView* shadowView;
}

- (NSString*)labelString;
- (void)setLabelString:(NSString*)aString;

- (BOOL)showsRollover;
- (void)setShowsRollover:(BOOL)flag;
- (void)setRolloverIsDirty:(BOOL)flag;

- (BOOL)isEditing;

// private

- (void)initializeInterface;
- (NSRect)labelRectForBounds:(NSRect)bounds;
- (NSString*)originalStringValue;
- (void)updateFieldEditorSize:(NSTextView*)fieldEditor;
- (void)updateRolloverPathIfNeeded;

@end


@interface PCFieldEditorShadowView : NSView
{
	NSTextView* fieldEditor;
	NSShadow* shadow;
	NSColor* shadowBorderColor;
	NSRect drawRect;
}

- (id)initWithFieldEditor:(NSTextView*)aFieldEditor;

// private

- (void)fieldEditorDidResize:(NSNotification*)aNotification;
- (BOOL)updateFrames;

@end
