//
//  PCTabBarButton.h
//  DragImageMorphing
//
//  Created by Wade Cosgrove on 4/17/08.
//  Copyright 2008 Panic, Inc.. All rights reserved.
//

#import <PanicCore/PCSlidingViewsBar.h>
#import <PanicCore/PCTabBar.h>

typedef enum
{
	kBezelBorderNone = 0,
	kBezelBorderTop = 1 << 0,
	kBezelBorderBottom = 1 << 1,
	kBezelBorderLeft = 1 << 2,
	kBezelBorderRight = 1 << 3
} TabButtonBezelBorderStyle;


@class PCTabBarPopUpButtonCell;
@class PCRecessedRolloverButton;


@interface PCTabBarButton : NSButton <SlidingViewProtocol, TabBarButtonProtocol>
{
	PCRecessedRolloverButton *closeButton;
	PCTabBarPopUpButtonCell *popupButtonCell;
	NSTimer *dragSpringTimer;
	
	BOOL		isEdited;
	BOOL		isSliding;
		
	NSTrackingArea *iRolloverArea;
	NSTrackingArea *iCloseButtonArea;
}

+ (NSString*)dragReorderPboardType;

- (void)setEdited:(BOOL)flag;
- (void)setSliding:(BOOL)flag;
- (void)setBezelBorderMask:(TabButtonBezelBorderStyle)mask;
- (void)setRolloverHighlighted:(BOOL)flag;
- (void)setCloseRolloverHighlighted:(BOOL)flag;

- (NSButton*)closeButton;
- (BOOL)isCloseButtonOrImageVisible;

- (NSDragOperation)updateDraggingState:(id <NSDraggingInfo>)sender;

@end
