#import <PanicCore/PCBubbleWindow.h>

@class PCToolTipItemView;

@interface PCTabToolTip : NSObject
{
	NSView					*itemViewsSuperview;
	PCToolTipItemView		*itemView1;
	PCToolTipItemView		*itemView2;
	PCToolTipItemView		*itemView3;
	PCToolTipItemView		*itemView4;
	
	BOOL					needsLayoutUpdate;
	NSRect					screenDisplayRect;
	
	PCBubbleWindow			*bubbleWindow;
	
	NSDate					*animationStartDate;
	NSTimer					*fadeTimer;
}

- (void)close;
- (void)displayAtPoint:(NSPoint)aPoint;
- (void)displayOverRect:(NSRect)aRect window:(NSWindow*)aWindow;
- (void)hide;

- (BOOL)isVisible;

- (void)setItemCount:(int)count;
- (void)setModeImage:(NSImage*)aModeImage pathImage:(NSImage*)aPathImage forTooltipAtIndex:(int)index;
- (void)setTitle:(NSString*)aTitle path:(NSString*)aPath forTooltipAtIndex:(int)index;

- (NSWindow*)window;

// private

- (void)calcWidthOfToolTip;

- (void)clearFadeTimer;
- (void)resetFadeTimer:(float)alphaIncrement;

@end


@interface PCGrayEdgeBubbleContenteView : PCBubbleContentView
{

}

@end


@interface PCToolTipItemView : NSView
{
    IBOutlet NSTextField	*titleField;
    IBOutlet NSTextField	*pathField;
    IBOutlet NSImageView	*modeImageView;
    IBOutlet NSImageView	*pathImageView;
}

- (void)setModeImage:(NSImage*)aModeImage pathImage:(NSImage*)aPathImage;
- (void)setTitle:(NSString*)aTitle path:(NSString*)aPath;

@end