#import <Cocoa/Cocoa.h>

/*
 *  PCTexturedSlider.h
 *
 *  Requires Mac OS X 10.5 or higher and associated slider resource images
 *
 *	Provides a gradient style slider for use on textured window backgrounds
 *
 *	-------------------------------------------------------------------
 *
 *	setShowsSizeBubble
 *	Sets whether or not to show the size bubble when mouse is in the slider for a half second
 *
 *	setSizeBubbleString
 * 	Sets the string to be displayed in the size bubble
 *
 */


typedef enum
{
	kSliderStyleNormal = 0, // candybar style
	kSliderStyleLight,
	kSliderStyleDark
} TexturedSliderStyle;


@interface PCTexturedSlider : NSSlider
{
	NSTrackingArea	*trackingArea;
}

- (TexturedSliderStyle)sliderStyle;
- (void)setSliderStyle:(TexturedSliderStyle)style;

- (void)setShowsSizeBubble:(BOOL)flag;
- (void)setSizeBubbleString:(NSString*)aString;

@end


@interface PCTexturedSliderCell : NSSliderCell
{
	NSViewAnimation *fadeAnimation;
	BOOL			bubbleSelectorHasBeenDispatched;
	NSPanel			*sizeBubbleWindow;
	NSTextField		*sizeBubbleTextField; // non-retained
	BOOL			showsSizeBubble;

	TexturedSliderStyle iSliderStyle;
	NSImage			*iLeftBarImage;
	NSImage			*iMiddleBarImage;
	NSImage			*iRightBarImage;
}

@property (assign) TexturedSliderStyle sliderStyle;

- (void)setShowsSizeBubble:(BOOL)flag;
- (void)setSizeBubbleString:(NSString*)aString;

- (BOOL)shouldShowSizeBubble;

// private

- (void)fadeSizeBubbleVisible:(BOOL)flag;
- (void)positionSizeIndicator;
- (void)setSizeWindowVisible:(BOOL)flag;

- (void)startBubbleTimer;
- (void)stopBubbleTimer;

- (void)loadBarImages;

@end