//
//  PCTitleBarTrialView.h
//  PanicCore
//
//  Created by Ian Cely on 11/12/09.
//  Copyright 2009 Panic Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class PCShadowedTextField;
@class PCTitleBarTrialGradientView;

@interface PCTitleBarTrialView : NSView 
{
@private
	PCTitleBarTrialGradientView* iBackgroundView;
	PCShadowedTextField* iCountdownTextField;
	NSUInteger iDaysLeft;
	int iState;
	struct {
		NSGradient* normal;
		NSGradient* normalPressed;
		NSGradient* warning;
		NSGradient* warningPressed;
	} iGradients;
	NSUInteger iWarningThreshold;
	NSURL* iPurchaseURL;
}

+ (PCTitleBarTrialView*)trialView;

@property(nonatomic, retain) NSURL* purchaseURL;
@property(nonatomic) NSUInteger daysLeft;
@property(nonatomic) NSUInteger warningThreshold; 

@end
