/*
 *  PCTruncateSubstitueField.h
 *
 *  Requires Mac OS X 10.4 or higher and PCShadowedTextField
 *
 *	Provides a text field that when truncated, replaces its default string value with
 *  a shorter version of the string that will fit in the smaller sized field.
 *
 *	------------------------------------------------------------------------------
 *
 *
 */
 
 #import <PanicCore/PCShadowedTextField.h>


@interface PCTruncateSubstituteField : PCShadowedTextField
{
	NSString *substituteString;
	NSString *defaultString;
}

- (void)setDefaultString:(NSString*)aString;
- (void)setSubstituteString:(NSString*)aString;


// private

- (void)updateSubstitution;

@end


@interface PCTruncateSubstituteView : NSView
{
	IBOutlet NSView			*rightView;
	IBOutlet NSTextField	*textField;
}

@end
