/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.filecopier;

import ch.fhnw.filecopier.CopyJob;
import ch.fhnw.filecopier.DirectoryInfo;
import ch.fhnw.filecopier.Source;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class FileCopier {
    public static final String FILE_PROPERTY = "file";
    public static final String BYTE_COUNTER_PROPERTY = "byte_counter";
    public static final String STATE_PROPERTY = "state";
    private State state = State.START;
    private static final Logger LOGGER = Logger.getLogger(FileCopier.class.getName());
    private static final int WANTED_TIME = 1000;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private long byteCount;
    private long oldCopiedBytes;
    private long copiedBytes;
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private long position;
    private long sourceLength;
    private long slice = 0x100000L;
    private long transferVolume;
    private long sliceStartTime;
    private CyclicBarrier barrier;

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(property, listener);
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public long getCopiedBytes() {
        return this.copiedBytes;
    }

    public void reset() {
        State previousState = this.state;
        this.state = State.START;
        this.propertyChangeSupport.firePropertyChange(STATE_PROPERTY, (Object)previousState, (Object)this.state);
    }

    public void copy(CopyJob ... copyJobs) throws IOException {
        this.byteCount = 0L;
        this.copiedBytes = 0L;
        State previousState = this.state;
        this.state = State.CHECKING_SOURCE;
        this.propertyChangeSupport.firePropertyChange(STATE_PROPERTY, (Object)previousState, (Object)this.state);
        int fileCount = 0;
        for (CopyJob copyJob : copyJobs) {
            if (copyJob == null) continue;
            Source[] sources = copyJob.getSources();
            ArrayList<DirectoryInfo> directoryInfos = new ArrayList<DirectoryInfo>();
            for (Source source : sources) {
                File baseDirectory = source.getBaseDirectory();
                int baseDirectoryPathLength = 0;
                String baseDirectoryPath = baseDirectory.getPath();
                baseDirectoryPathLength = baseDirectoryPath.endsWith(File.separator) ? baseDirectoryPath.length() : baseDirectoryPath.length() + 1;
                DirectoryInfo tmpInfo = this.expand(baseDirectoryPathLength, baseDirectory, source.getPattern(), source.isRecursive());
                if (tmpInfo == null) continue;
                directoryInfos.add(tmpInfo);
                this.byteCount += tmpInfo.getByteCount();
                fileCount += tmpInfo.getFiles().size();
            }
            copyJob.setDirectoryInfos(directoryInfos);
            if (!LOGGER.isLoggable(Level.INFO)) continue;
            StringBuilder stringBuilder = new StringBuilder("source files:\n");
            for (DirectoryInfo directoryInfo : directoryInfos) {
                stringBuilder.append("source files in base directory ");
                stringBuilder.append(directoryInfo.getBaseDirectory());
                stringBuilder.append(":\n");
                for (File sourceFile : directoryInfo.getFiles()) {
                    stringBuilder.append(sourceFile.isFile() ? "f " : "d ");
                    stringBuilder.append(sourceFile.getPath());
                    stringBuilder.append('\n');
                }
            }
            LOGGER.info(stringBuilder.toString());
        }
        if (fileCount == 0) {
            LOGGER.info("there are no files to copy");
            return;
        }
        for (CopyJob copyJob : copyJobs) {
            String[] destinations;
            if (copyJob == null) continue;
            List<DirectoryInfo> directoryInfos = copyJob.getDirectoryInfos();
            int sourceCount = 0;
            for (DirectoryInfo directoryInfo : directoryInfos) {
                sourceCount += directoryInfo.getFiles().size();
            }
            if (sourceCount == 0) continue;
            for (String destination : destinations = copyJob.getDestinations()) {
                File destinationFile = new File(destination);
                if (!destinationFile.isFile()) continue;
                if (sourceCount == 1) {
                    File sourceFile = directoryInfos.get(0).getFiles().get(0);
                    if (!sourceFile.isDirectory()) continue;
                    throw new IOException("can not overwrite file \"" + destinationFile + "\" with directory \"" + sourceFile + "\"");
                }
                StringBuilder errorMessage = new StringBuilder("can not copy several files to another file\n sources:");
                for (DirectoryInfo directoryInfo : directoryInfos) {
                    List<File> files = directoryInfo.getFiles();
                    for (File file : files) {
                        errorMessage.append("  ");
                        errorMessage.append(file.getPath());
                    }
                }
                errorMessage.append(" destination: ");
                errorMessage.append(destinationFile.getPath());
                throw new IOException(errorMessage.toString());
            }
        }
        previousState = this.state;
        this.state = State.COPYING;
        this.propertyChangeSupport.firePropertyChange(STATE_PROPERTY, (Object)previousState, (Object)this.state);
        for (CopyJob copyJob : copyJobs) {
            if (copyJob == null) continue;
            for (DirectoryInfo directoryInfo : copyJob.getDirectoryInfos()) {
                for (File sourceFile : directoryInfo.getFiles()) {
                    File[] destinationFiles = this.getDestinationFiles(directoryInfo.getBaseDirectory(), sourceFile, copyJob.getDestinations());
                    if (sourceFile.isDirectory()) {
                        for (File destinationFile : destinationFiles) {
                            if (destinationFile.exists()) {
                                if (destinationFile.isDirectory()) {
                                    LOGGER.log(Level.INFO, "Directory \"{0}\" already exists", destinationFile);
                                    continue;
                                }
                                throw new IOException("can not overwrite file \"" + destinationFile + "\" with directory \"" + sourceFile + "\"");
                            }
                            LOGGER.log(Level.INFO, "Creating directory \"{0}\"", destinationFile);
                            if (destinationFile.mkdirs()) continue;
                            throw new IOException("Could not create directory \"" + destinationFile + "\"");
                        }
                        continue;
                    }
                    this.copyFile(sourceFile, destinationFiles);
                }
            }
        }
        if (this.oldCopiedBytes != this.copiedBytes) {
            this.propertyChangeSupport.firePropertyChange(BYTE_COUNTER_PROPERTY, this.oldCopiedBytes, this.copiedBytes);
        }
        previousState = this.state;
        this.state = State.END;
        this.propertyChangeSupport.firePropertyChange(STATE_PROPERTY, (Object)previousState, (Object)this.state);
    }

    private File[] getDestinationFiles(File baseDirectory, File sourceFile, String[] destinations) {
        int destinationCount = destinations.length;
        File[] destinationFiles = new File[destinationCount];
        for (int i = 0; i < destinationCount; ++i) {
            File destinationFile = new File(destinations[i]);
            if (destinationFile.isDirectory()) {
                int baseLength = baseDirectory.getPath().length();
                String filePath = sourceFile.getPath();
                String destinationPath = filePath.substring(baseLength);
                destinationFiles[i] = new File(destinationFile, destinationPath);
                continue;
            }
            destinationFiles[i] = destinationFile;
        }
        return destinationFiles;
    }

    private DirectoryInfo expand(int baseDirectoryPathLength, File currentDirectory, Pattern pattern, boolean recursive) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "\n\tcurrent directory: \"{0}\"\n\tpattern: \"{1}\"", new Object[]{currentDirectory, pattern});
        }
        this.propertyChangeSupport.firePropertyChange(FILE_PROPERTY, null, currentDirectory);
        if (!currentDirectory.exists()) {
            LOGGER.log(Level.WARNING, "{0} does not exist", currentDirectory);
            return null;
        }
        if (!currentDirectory.isDirectory()) {
            LOGGER.log(Level.WARNING, "{0} is no directory", currentDirectory);
            return null;
        }
        if (!currentDirectory.canRead()) {
            LOGGER.log(Level.WARNING, "can not read {0}", currentDirectory);
            return null;
        }
        if (pattern == null) {
            throw new IllegalArgumentException("pattern must not be null");
        }
        LOGGER.log(Level.FINE, "recursing directory {0}", currentDirectory);
        long tmpByteCount = 0L;
        ArrayList<File> files = new ArrayList<File>();
        for (File subFile : currentDirectory.listFiles()) {
            DirectoryInfo tmpInfo;
            String relativePath = subFile.getPath().substring(baseDirectoryPathLength);
            if (pattern.matcher(relativePath).matches()) {
                LOGGER.log(Level.FINE, "{0} matches", subFile);
                if (subFile.isDirectory()) {
                    if (recursive) {
                        files.add(subFile);
                    }
                } else {
                    files.add(subFile);
                    tmpByteCount += subFile.length();
                }
            } else {
                LOGGER.log(Level.FINE, "{0} does not match", subFile);
            }
            if (!subFile.isDirectory() || !recursive || (tmpInfo = this.expand(baseDirectoryPathLength, subFile, pattern, recursive)) == null) continue;
            files.addAll(tmpInfo.getFiles());
            tmpByteCount += tmpInfo.getByteCount();
        }
        return new DirectoryInfo(currentDirectory, files, tmpByteCount);
    }

    private void copyFile(File source, File ... destinations) throws IOException {
        if (LOGGER.isLoggable(Level.INFO)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Copying file \"");
            stringBuilder.append(source.toString());
            stringBuilder.append("\" to the following destinations:\n");
            for (File destination : destinations) {
                stringBuilder.append(destination.getPath());
                stringBuilder.append('\n');
            }
            LOGGER.info(stringBuilder.toString());
        }
        for (File destination : destinations) {
            if (destination.exists()) continue;
            destination.getParentFile().mkdirs();
            destination.createNewFile();
        }
        this.sourceLength = source.length();
        if (this.sourceLength == 0L) {
            return;
        }
        int destinationCount = destinations.length;
        Transferrer[] transferrers = new Transferrer[destinationCount];
        for (int i = 0; i < destinationCount; ++i) {
            transferrers[i] = new Transferrer(new FileInputStream(source).getChannel(), new FileOutputStream(destinations[i]).getChannel());
        }
        this.barrier = new CyclicBarrier(destinationCount, new Runnable(){

            @Override
            public void run() {
                FileCopier.this.position += FileCopier.this.transferVolume;
                FileCopier.this.copiedBytes += FileCopier.this.transferVolume;
                FileCopier.this.propertyChangeSupport.firePropertyChange(FileCopier.BYTE_COUNTER_PROPERTY, FileCopier.this.oldCopiedBytes, FileCopier.this.copiedBytes);
                FileCopier.this.oldCopiedBytes = FileCopier.this.copiedBytes;
                long stop = System.currentTimeMillis();
                long time = stop - FileCopier.this.sliceStartTime;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "time = {0} ms", NUMBER_FORMAT.format(time));
                }
                if (time != 0L) {
                    long newSlice = FileCopier.this.transferVolume * 1000L / time;
                    long doubleSlice = 2L * FileCopier.this.slice;
                    long halfSlice = FileCopier.this.slice / 2L;
                    if (newSlice > doubleSlice) {
                        FileCopier.this.slice = doubleSlice;
                    } else if (newSlice < halfSlice && halfSlice > 0L) {
                        FileCopier.this.slice = halfSlice;
                    }
                    FileCopier.this.transferVolume = Math.min(FileCopier.this.slice, FileCopier.this.sourceLength - FileCopier.this.position);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "\nslice = {0} Byte\ntransferVolume = {1} Byte", new Object[]{NUMBER_FORMAT.format(FileCopier.this.slice), NUMBER_FORMAT.format(FileCopier.this.transferVolume)});
                    }
                }
                FileCopier.this.sliceStartTime = System.currentTimeMillis();
            }
        });
        this.position = 0L;
        this.transferVolume = Math.min(this.slice, this.sourceLength);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "\nslice = {0} Byte\ntransferVolume = {1} Byte", new Object[]{NUMBER_FORMAT.format(this.slice), NUMBER_FORMAT.format(this.transferVolume)});
        }
        this.sliceStartTime = System.currentTimeMillis();
        ExecutorService executorService = Executors.newCachedThreadPool();
        ExecutorCompletionService completionService = new ExecutorCompletionService(executorService);
        for (Transferrer transferrer : transferrers) {
            completionService.submit(transferrer, null);
        }
        for (int i = 0; i < destinationCount; ++i) {
            try {
                completionService.take();
                continue;
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        executorService.shutdown();
    }

    private class Transferrer
    extends Thread {
        private final FileChannel sourceChannel;
        private final FileChannel destinationChannel;

        public Transferrer(FileChannel sourceChannel, FileChannel destinationChannel) {
            this.sourceChannel = sourceChannel;
            this.destinationChannel = destinationChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (FileCopier.this.position < FileCopier.this.sourceLength) {
                    long transferSize;
                    for (long transferredBytes = 0L; transferredBytes < FileCopier.this.transferVolume; transferredBytes += transferSize) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "position = {0}, transferredBytes = {1}, transferVolume = {2}", new Object[]{FileCopier.this.position, transferredBytes, FileCopier.this.transferVolume});
                        }
                        transferSize = this.destinationChannel.transferFrom(this.sourceChannel, FileCopier.this.position, FileCopier.this.transferVolume - transferredBytes);
                        LOGGER.log(Level.FINE, "transferSize = {0}", transferSize);
                    }
                    FileCopier.this.barrier.await();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "could not transfer data", ex);
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            catch (BrokenBarrierException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    this.sourceChannel.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, "could not close destination channel", ex);
                }
                try {
                    this.destinationChannel.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, "could not close destination channel", ex);
                }
            }
        }
    }

    public static enum State {
        START,
        CHECKING_SOURCE,
        COPYING,
        END;

    }
}

