/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.filecopier;

import ch.fhnw.filecopier.FileCopier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class FileCopierPanel
extends JPanel
implements PropertyChangeListener {
    private static final ResourceBundle strings = ResourceBundle.getBundle("ch/fhnw/filecopier/Strings");
    private long byteCount;
    private long bytesCopied;
    private FileCopier fileCopier;
    private static final NumberFormat numberFormat = NumberFormat.getInstance();
    private DateFormat timeFormat;
    private DateFormat dateFormat;
    private DateFormat minuteFormat;
    private static final int KILO = 1024;
    private static final int MEGA = 0x100000;
    private static final int GIGA = 0x40000000;
    private static final long TERA = 0L;
    private static final int HOUR = 3600000;
    private long startTime;
    private Timer updateTimer = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FileCopierPanel.this.update();
        }
    });
    private JPanel bottomPanel;
    private JLabel dataVolumeLabel;
    private JLabel estimatedDurationLabel;
    private JLabel estimatedRemainingTimeLabel;
    private JLabel estimatedStopTimeLabel;
    private JLabel missingDataVolumeLabel;
    private JLabel passedTimeLabel;
    private JProgressBar progressBar;
    private JLabel startTimeLabel;
    private JLabel transferredDataVolumeLabel;

    public FileCopierPanel() {
        this.timeFormat = DateFormat.getTimeInstance(2);
        this.timeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.dateFormat = DateFormat.getTimeInstance(2);
        this.minuteFormat = new SimpleDateFormat("mm:ss");
        this.initComponents();
        this.passedTimeLabel.setText(" ");
        this.estimatedDurationLabel.setText(" ");
        this.estimatedRemainingTimeLabel.setText(" ");
        this.transferredDataVolumeLabel.setText(" ");
        this.dataVolumeLabel.setText(" ");
        this.missingDataVolumeLabel.setText(" ");
        this.progressBar.setIndeterminate(false);
        this.progressBar.setString(null);
        this.startTimeLabel.setText(" ");
        this.estimatedStopTimeLabel.setText(" ");
    }

    public void setFileCopier(FileCopier fileCopier) {
        if (this.fileCopier != null) {
            this.fileCopier.removePropertyChangeListener("state", this);
        }
        this.fileCopier = fileCopier;
        fileCopier.addPropertyChangeListener("state", this);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String propertyName = evt.getPropertyName();
                if ("state".equals(propertyName)) {
                    FileCopier.State newState = (FileCopier.State)((Object)evt.getNewValue());
                    switch (newState) {
                        case START: {
                            FileCopierPanel.this.passedTimeLabel.setText(" ");
                            FileCopierPanel.this.estimatedDurationLabel.setText(" ");
                            Font defaultLabelFont = new JLabel().getFont();
                            Font nonBoldFont = defaultLabelFont.deriveFont(defaultLabelFont.getStyle() & 0xFFFFFFFE);
                            FileCopierPanel.this.estimatedDurationLabel.setFont(nonBoldFont);
                            FileCopierPanel.this.estimatedDurationLabel.setForeground(Color.GRAY);
                            FileCopierPanel.this.estimatedRemainingTimeLabel.setText(" ");
                            FileCopierPanel.this.transferredDataVolumeLabel.setText(" ");
                            FileCopierPanel.this.dataVolumeLabel.setText(" ");
                            FileCopierPanel.this.missingDataVolumeLabel.setText(" ");
                            FileCopierPanel.this.progressBar.setIndeterminate(false);
                            FileCopierPanel.this.progressBar.setString("0%");
                            FileCopierPanel.this.startTimeLabel.setText(" ");
                            FileCopierPanel.this.estimatedStopTimeLabel.setText(" ");
                            FileCopierPanel.this.estimatedStopTimeLabel.setFont(nonBoldFont);
                            FileCopierPanel.this.estimatedStopTimeLabel.setForeground(Color.GRAY);
                            break;
                        }
                        case CHECKING_SOURCE: {
                            FileCopierPanel.this.progressBar.setIndeterminate(true);
                            FileCopierPanel.this.progressBar.setString(strings.getString("Checking_Source_Directory"));
                            break;
                        }
                        case COPYING: {
                            FileCopierPanel.this.startTime = System.currentTimeMillis();
                            FileCopierPanel.this.startTimeLabel.setText(FileCopierPanel.this.dateFormat.format(new Date()));
                            FileCopierPanel.this.updateTimer.setInitialDelay(0);
                            FileCopierPanel.this.updateTimer.start();
                            FileCopierPanel.this.byteCount = FileCopierPanel.this.fileCopier.getByteCount();
                            FileCopierPanel.this.dataVolumeLabel.setText(FileCopierPanel.getDataVolumeString(FileCopierPanel.this.byteCount, 1));
                            FileCopierPanel.this.progressBar.setIndeterminate(false);
                            FileCopierPanel.this.bytesCopied = 0L;
                            FileCopierPanel.this.updateProgressBar();
                            break;
                        }
                        case END: {
                            FileCopierPanel.this.update();
                            FileCopierPanel.this.updateTimer.stop();
                            FileCopierPanel.this.passedTimeLabel.setText(" ");
                            FileCopierPanel.this.transferredDataVolumeLabel.setText(" ");
                            FileCopierPanel.this.estimatedRemainingTimeLabel.setText(" ");
                            FileCopierPanel.this.missingDataVolumeLabel.setText(" ");
                            Font defaultLabelFont = new JLabel().getFont();
                            FileCopierPanel.this.estimatedDurationLabel.setFont(defaultLabelFont);
                            FileCopierPanel.this.estimatedDurationLabel.setForeground(Color.BLACK);
                            FileCopierPanel.this.estimatedStopTimeLabel.setFont(defaultLabelFont);
                            FileCopierPanel.this.progressBar.setString(strings.getString("Done"));
                            FileCopierPanel.this.estimatedStopTimeLabel.setForeground(Color.BLACK);
                        }
                    }
                } else if ("byte_counter".equals(propertyName)) {
                    FileCopierPanel.this.bytesCopied = (Long)evt.getNewValue();
                    FileCopierPanel.this.updateProgressBar();
                }
            }
        });
    }

    private void initComponents() {
        this.passedTimeLabel = new JLabel();
        this.estimatedDurationLabel = new JLabel();
        this.estimatedRemainingTimeLabel = new JLabel();
        this.transferredDataVolumeLabel = new JLabel();
        this.dataVolumeLabel = new JLabel();
        this.missingDataVolumeLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.bottomPanel = new JPanel();
        this.startTimeLabel = new JLabel();
        this.estimatedStopTimeLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.passedTimeLabel.setText("0:00");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.passedTimeLabel, gridBagConstraints);
        this.estimatedDurationLabel.setFont(this.estimatedDurationLabel.getFont().deriveFont(this.estimatedDurationLabel.getFont().getStyle() & 0xFFFFFFFE));
        this.estimatedDurationLabel.setForeground(Color.gray);
        this.estimatedDurationLabel.setHorizontalAlignment(0);
        this.estimatedDurationLabel.setText("0:00");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.estimatedDurationLabel, gridBagConstraints);
        this.estimatedRemainingTimeLabel.setFont(this.estimatedRemainingTimeLabel.getFont().deriveFont(this.estimatedRemainingTimeLabel.getFont().getStyle() & 0xFFFFFFFE));
        this.estimatedRemainingTimeLabel.setForeground(Color.gray);
        this.estimatedRemainingTimeLabel.setText("0:00");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.estimatedRemainingTimeLabel, gridBagConstraints);
        this.transferredDataVolumeLabel.setText("0 Byte");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.transferredDataVolumeLabel, gridBagConstraints);
        this.dataVolumeLabel.setHorizontalAlignment(0);
        this.dataVolumeLabel.setText("0 Byte");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.dataVolumeLabel, gridBagConstraints);
        this.missingDataVolumeLabel.setText("0 Byte");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.missingDataVolumeLabel, gridBagConstraints);
        this.progressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.progressBar, gridBagConstraints);
        this.bottomPanel.setLayout(new GridBagLayout());
        this.startTimeLabel.setText("0:00");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.bottomPanel.add((Component)this.startTimeLabel, gridBagConstraints);
        this.estimatedStopTimeLabel.setFont(this.estimatedStopTimeLabel.getFont().deriveFont(this.estimatedStopTimeLabel.getFont().getStyle() & 0xFFFFFFFE));
        this.estimatedStopTimeLabel.setForeground(Color.gray);
        this.estimatedStopTimeLabel.setHorizontalAlignment(4);
        this.estimatedStopTimeLabel.setText("0:00");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.bottomPanel.add((Component)this.estimatedStopTimeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.bottomPanel, gridBagConstraints);
    }

    private void update() {
        this.bytesCopied = this.fileCopier.getCopiedBytes();
        if (this.bytesCopied == 0L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long timeSpent = currentTime - this.startTime;
        this.passedTimeLabel.setText(this.getTimeString(timeSpent));
        this.transferredDataVolumeLabel.setText(FileCopierPanel.getDataVolumeString(this.bytesCopied, 1));
        long estimate = timeSpent * this.byteCount / this.bytesCopied;
        this.estimatedDurationLabel.setText(this.getTimeString(estimate));
        long remaining = estimate - timeSpent;
        this.estimatedRemainingTimeLabel.setText(this.getTimeString(remaining));
        this.missingDataVolumeLabel.setText(FileCopierPanel.getDataVolumeString(this.byteCount - this.bytesCopied, 1));
        this.updateProgressBar();
        this.estimatedStopTimeLabel.setText(this.dateFormat.format(currentTime + remaining));
    }

    private static String getDataVolumeString(long bytes, int fractionDigits) {
        if (bytes >= 1024L) {
            numberFormat.setMaximumFractionDigits(fractionDigits);
            float kbytes = (float)bytes / 1024.0f;
            if (kbytes >= 1024.0f) {
                float mbytes = (float)bytes / 1048576.0f;
                if (mbytes >= 1024.0f) {
                    float gbytes = (float)bytes / 1.0737418E9f;
                    if (gbytes >= 1024.0f) {
                        float tbytes = (float)bytes / 0.0f;
                        return numberFormat.format(tbytes) + " TB";
                    }
                    return numberFormat.format(gbytes) + " GB";
                }
                return numberFormat.format(mbytes) + " MB";
            }
            return numberFormat.format(kbytes) + " KB";
        }
        return numberFormat.format(bytes) + " Byte";
    }

    private String getTimeString(long time) {
        if (time < 3600000L) {
            return this.minuteFormat.format(time);
        }
        return this.timeFormat.format(time);
    }

    private void updateProgressBar() {
        if (this.byteCount == 0L) {
            return;
        }
        int progress = (int)(100L * this.bytesCopied / this.byteCount);
        long currentTime = System.currentTimeMillis();
        long timeSpent = (currentTime - this.startTime) / 1000L;
        int speed = 0;
        if (timeSpent != 0L) {
            speed = (int)(this.bytesCopied / timeSpent);
        }
        String currentBandwidth = FileCopierPanel.getDataVolumeString(speed, 1) + "/s";
        this.progressBar.setValue(progress);
        this.progressBar.setString(progress + "% (" + currentBandwidth + ')');
    }
}

