/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.filecopier;

import java.io.File;
import java.util.regex.Pattern;

public class Source {
    private final File baseDirectory;
    private final Pattern pattern;
    private final boolean recursive;

    public Source(String fileName) {
        File sourceFile = new File(fileName);
        if (sourceFile.isDirectory()) {
            File parent = sourceFile.getParentFile();
            if (parent == null) {
                this.baseDirectory = sourceFile;
                this.pattern = Pattern.compile(".*");
                this.recursive = true;
            } else {
                this.baseDirectory = parent;
                this.pattern = Pattern.compile(sourceFile.getName() + ".*");
                this.recursive = true;
            }
        } else {
            this.baseDirectory = sourceFile.getParentFile();
            this.pattern = Pattern.compile(sourceFile.getName());
            this.recursive = true;
        }
    }

    public Source(String baseDirectory, String pattern) {
        this(baseDirectory, pattern, true);
    }

    public Source(String baseDirectory, String pattern, boolean recursive) {
        this.baseDirectory = new File(baseDirectory);
        this.pattern = Pattern.compile(pattern);
        this.recursive = recursive;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean isRecursive() {
        return this.recursive;
    }
}

