/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.ftp4j;

import it.sauronsoftware.ftp4j.FTPAbortedException;
import it.sauronsoftware.ftp4j.FTPCommunicationChannel;
import it.sauronsoftware.ftp4j.FTPCommunicationListener;
import it.sauronsoftware.ftp4j.FTPConnector;
import it.sauronsoftware.ftp4j.FTPDataTransferConnectionProvider;
import it.sauronsoftware.ftp4j.FTPDataTransferException;
import it.sauronsoftware.ftp4j.FTPDataTransferListener;
import it.sauronsoftware.ftp4j.FTPDataTransferServer;
import it.sauronsoftware.ftp4j.FTPException;
import it.sauronsoftware.ftp4j.FTPFile;
import it.sauronsoftware.ftp4j.FTPIllegalReplyException;
import it.sauronsoftware.ftp4j.FTPListParseException;
import it.sauronsoftware.ftp4j.FTPListParser;
import it.sauronsoftware.ftp4j.FTPReply;
import it.sauronsoftware.ftp4j.FTPTextualExtensionRecognizer;
import it.sauronsoftware.ftp4j.NVTASCIIReader;
import it.sauronsoftware.ftp4j.connectors.DirectConnector;
import it.sauronsoftware.ftp4j.extrecognizers.DefaultTextualExtensionRecognizer;
import it.sauronsoftware.ftp4j.listparsers.DOSListParser;
import it.sauronsoftware.ftp4j.listparsers.EPLFListParser;
import it.sauronsoftware.ftp4j.listparsers.MLSDListParser;
import it.sauronsoftware.ftp4j.listparsers.NetWareListParser;
import it.sauronsoftware.ftp4j.listparsers.UnixListParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLSocketFactory;

public class FTPClient {
    public static final int SECURITY_FTP = 0;
    public static final int SECURITY_FTPS = 1;
    public static final int SECURITY_FTPES = 2;
    public static final int TYPE_AUTO = 0;
    public static final int TYPE_TEXTUAL = 1;
    public static final int TYPE_BINARY = 2;
    public static final int MLSD_IF_SUPPORTED = 0;
    public static final int MLSD_ALWAYS = 1;
    public static final int MLSD_NEVER = 2;
    private static final int SEND_AND_RECEIVE_BUFFER_SIZE = 65536;
    private static final DateFormat MDTM_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final Pattern PASV_PATTERN = Pattern.compile("\\d{1,3},\\d{1,3},\\d{1,3},\\d{1,3},\\d{1,3},\\d{1,3}");
    private static final Pattern PWD_PATTERN = Pattern.compile("\"/.*\"");
    private FTPConnector connector = new DirectConnector();
    private SSLSocketFactory sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    private ArrayList communicationListeners = new ArrayList();
    private ArrayList listParsers = new ArrayList();
    private FTPTextualExtensionRecognizer textualExtensionRecognizer = DefaultTextualExtensionRecognizer.getInstance();
    private FTPListParser parser = null;
    private String host = null;
    private int port = 0;
    private int security = 0;
    private String username;
    private String password;
    private boolean connected = false;
    private boolean authenticated = false;
    private boolean passive = true;
    private int type = 0;
    private int mlsdPolicy = 0;
    private long autoNoopTimeout = 0L;
    private AutoNoopTimer autoNoopTimer;
    private long nextAutoNoopTime;
    private boolean restSupported = false;
    private String charset = null;
    private boolean compressionEnabled = false;
    private boolean utf8Supported = false;
    private boolean mlsdSupported = false;
    private boolean modezSupported = false;
    private boolean modezEnabled = false;
    private boolean dataChannelEncrypted = false;
    private boolean ongoingDataTransfer = false;
    private InputStream dataTransferInputStream = null;
    private OutputStream dataTransferOutputStream = null;
    private boolean aborted = false;
    private Object lock = new Object();
    private Object abortLock = new Object();
    private FTPCommunicationChannel communication = null;

    public FTPClient() {
        this.addListParser(new UnixListParser());
        this.addListParser(new DOSListParser());
        this.addListParser(new EPLFListParser());
        this.addListParser(new NetWareListParser());
        this.addListParser(new MLSDListParser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPConnector getConnector() {
        Object object = this.lock;
        synchronized (object) {
            return this.connector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnector(FTPConnector connector) {
        Object object = this.lock;
        synchronized (object) {
            this.connector = connector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        Object object = this.lock;
        synchronized (object) {
            this.sslSocketFactory = sslSocketFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLSocketFactory getSSLSocketFactory() {
        Object object = this.lock;
        synchronized (object) {
            return this.sslSocketFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecurity(int security) throws IllegalStateException, IllegalArgumentException {
        if (security != 0 && security != 1 && security != 2) {
            throw new IllegalArgumentException("Invalid security");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.connected) {
                throw new IllegalStateException("The security level of the connection can't be changed while the client is connected");
            }
            this.security = security;
        }
    }

    public int getSecurity() {
        return this.security;
    }

    private Socket ssl(Socket socket, String host, int port) throws IOException {
        return this.sslSocketFactory.createSocket(socket, host, port, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassive(boolean passive) {
        Object object = this.lock;
        synchronized (object) {
            this.passive = passive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(int type) throws IllegalArgumentException {
        if (type != 0 && type != 2 && type != 1) {
            throw new IllegalArgumentException("Invalid type");
        }
        Object object = this.lock;
        synchronized (object) {
            this.type = type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType() {
        Object object = this.lock;
        synchronized (object) {
            return this.type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMLSDPolicy(int mlsdPolicy) throws IllegalArgumentException {
        if (this.type != 0 && this.type != 1 && this.type != 2) {
            throw new IllegalArgumentException("Invalid MLSD policy");
        }
        Object object = this.lock;
        synchronized (object) {
            this.mlsdPolicy = mlsdPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMLSDPolicy() {
        Object object = this.lock;
        synchronized (object) {
            return this.mlsdPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCharset() {
        Object object = this.lock;
        synchronized (object) {
            return this.charset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharset(String charset) {
        Object object = this.lock;
        synchronized (object) {
            this.charset = charset;
            if (this.connected) {
                try {
                    this.communication.changeCharset(this.pickCharset());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResumeSupported() {
        Object object = this.lock;
        synchronized (object) {
            return this.restSupported;
        }
    }

    public boolean isCompressionSupported() {
        return this.modezSupported;
    }

    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPTextualExtensionRecognizer getTextualExtensionRecognizer() {
        Object object = this.lock;
        synchronized (object) {
            return this.textualExtensionRecognizer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextualExtensionRecognizer(FTPTextualExtensionRecognizer textualExtensionRecognizer) {
        Object object = this.lock;
        synchronized (object) {
            this.textualExtensionRecognizer = textualExtensionRecognizer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthenticated() {
        Object object = this.lock;
        synchronized (object) {
            return this.authenticated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.lock;
        synchronized (object) {
            return this.connected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPassive() {
        Object object = this.lock;
        synchronized (object) {
            return this.passive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHost() {
        Object object = this.lock;
        synchronized (object) {
            return this.host;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() {
        Object object = this.lock;
        synchronized (object) {
            return this.port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPassword() {
        Object object = this.lock;
        synchronized (object) {
            return this.password;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUsername() {
        Object object = this.lock;
        synchronized (object) {
            return this.username;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoNoopTimeout(long autoNoopTimeout) {
        Object object = this.lock;
        synchronized (object) {
            if (this.connected && this.authenticated) {
                this.stopAutoNoopTimer();
            }
            long oldValue = this.autoNoopTimeout;
            long newValue = autoNoopTimeout;
            this.autoNoopTimeout = autoNoopTimeout;
            if (oldValue != 0L && newValue != 0L && this.nextAutoNoopTime > 0L) {
                this.nextAutoNoopTime -= oldValue - newValue;
            }
            if (this.connected && this.authenticated) {
                this.startAutoNoopTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAutoNoopTimeout() {
        Object object = this.lock;
        synchronized (object) {
            return this.autoNoopTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommunicationListener(FTPCommunicationListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.communicationListeners.add(listener);
            if (this.communication != null) {
                this.communication.addCommunicationListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommunicationListener(FTPCommunicationListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.communicationListeners.remove(listener);
            if (this.communication != null) {
                this.communication.removeCommunicationListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPCommunicationListener[] getCommunicationListeners() {
        Object object = this.lock;
        synchronized (object) {
            int size = this.communicationListeners.size();
            FTPCommunicationListener[] ret = new FTPCommunicationListener[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = (FTPCommunicationListener)this.communicationListeners.get(i);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListParser(FTPListParser listParser) {
        Object object = this.lock;
        synchronized (object) {
            this.listParsers.add(listParser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListParser(FTPListParser listParser) {
        Object object = this.lock;
        synchronized (object) {
            this.listParsers.remove(listParser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPListParser[] getListParsers() {
        Object object = this.lock;
        synchronized (object) {
            int size = this.listParsers.size();
            FTPListParser[] ret = new FTPListParser[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = (FTPListParser)this.listParsers.get(i);
            }
            return ret;
        }
    }

    public String[] connect(String host) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        int def = this.security == 1 ? 990 : 21;
        return this.connect(host, def);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] connect(String host, int port) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            if (this.connected) {
                throw new IllegalStateException("Client already connected to " + host + " on port " + port);
            }
            Socket connection = null;
            connection = this.connector.connectForCommunicationChannel(host, port);
            if (this.security == 1) {
                connection = this.ssl(connection, host, port);
            }
            this.communication = new FTPCommunicationChannel(connection, this.pickCharset());
            Iterator i = this.communicationListeners.iterator();
            while (i.hasNext()) {
                this.communication.addCommunicationListener((FTPCommunicationListener)i.next());
            }
            FTPReply wm = this.communication.readFTPReply();
            if (!wm.isSuccessCode()) {
                throw new FTPException(wm);
            }
            this.connected = true;
            this.authenticated = false;
            this.parser = null;
            this.host = host;
            this.port = port;
            this.username = null;
            this.password = null;
            this.utf8Supported = false;
            this.restSupported = false;
            this.mlsdSupported = false;
            this.modezSupported = false;
            this.dataChannelEncrypted = false;
            String[] stringArray = wm.getMessages();
            return stringArray;
            finally {
                if (!this.connected && connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean sendQuitCommand) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (this.authenticated) {
                this.stopAutoNoopTimer();
            }
            if (sendQuitCommand) {
                this.communication.sendFTPCommand("QUIT");
                FTPReply r = this.communication.readFTPReply();
                if (!r.isSuccessCode()) {
                    throw new FTPException(r);
                }
            }
            this.communication.close();
            this.communication = null;
            this.connected = false;
        }
    }

    public void abruptlyCloseCommunication() {
        this.communication.close();
        this.communication = null;
        this.connected = false;
        this.stopAutoNoopTimer();
    }

    public void login(String username, String password) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        this.login(username, password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String username, String password, String account) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            boolean accountRequired2;
            boolean passwordRequired2;
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (this.security == 2) {
                this.communication.sendFTPCommand("AUTH TLS");
                FTPReply r = this.communication.readFTPReply();
                if (r.isSuccessCode()) {
                    this.communication.ssl(this.sslSocketFactory);
                } else {
                    this.communication.sendFTPCommand("AUTH SSL");
                    r = this.communication.readFTPReply();
                    if (r.isSuccessCode()) {
                        this.communication.ssl(this.sslSocketFactory);
                    } else {
                        throw new FTPException(r.getCode(), "SECURITY_FTPES cannot be applied: the server refused both AUTH TLS and AUTH SSL commands");
                    }
                }
            }
            this.authenticated = false;
            this.communication.sendFTPCommand("USER " + username);
            FTPReply r = this.communication.readFTPReply();
            switch (r.getCode()) {
                case 230: {
                    passwordRequired2 = false;
                    accountRequired2 = false;
                    break;
                }
                case 331: {
                    passwordRequired2 = true;
                    accountRequired2 = false;
                    break;
                }
                case 332: {
                    boolean passwordRequired2 = false;
                    boolean accountRequired2 = true;
                }
                default: {
                    throw new FTPException(r);
                }
            }
            if (passwordRequired2) {
                if (password == null) {
                    throw new FTPException(331);
                }
                this.communication.sendFTPCommand("PASS " + password);
                r = this.communication.readFTPReply();
                switch (r.getCode()) {
                    case 230: {
                        accountRequired2 = false;
                        break;
                    }
                    case 332: {
                        accountRequired2 = true;
                        break;
                    }
                    default: {
                        throw new FTPException(r);
                    }
                }
            }
            if (accountRequired2) {
                if (account == null) {
                    throw new FTPException(332);
                }
                this.communication.sendFTPCommand("ACCT " + account);
                r = this.communication.readFTPReply();
                switch (r.getCode()) {
                    case 230: {
                        break;
                    }
                    default: {
                        throw new FTPException(r);
                    }
                }
            }
            this.authenticated = true;
            this.username = username;
            this.password = password;
        }
        this.postLoginOperations();
        this.startAutoNoopTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postLoginOperations() throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            this.utf8Supported = false;
            this.restSupported = false;
            this.mlsdSupported = false;
            this.modezSupported = false;
            this.dataChannelEncrypted = false;
            this.communication.sendFTPCommand("FEAT");
            FTPReply r = this.communication.readFTPReply();
            if (r.getCode() == 211) {
                String[] lines = r.getMessages();
                for (int i = 1; i < lines.length - 1; ++i) {
                    String feat = lines[i].trim().toUpperCase();
                    if ("REST STREAM".equalsIgnoreCase(feat)) {
                        this.restSupported = true;
                        continue;
                    }
                    if ("UTF8".equalsIgnoreCase(feat)) {
                        this.utf8Supported = true;
                        this.communication.changeCharset("UTF-8");
                        continue;
                    }
                    if ("MLSD".equalsIgnoreCase(feat)) {
                        this.mlsdSupported = true;
                        continue;
                    }
                    if (!"MODE Z".equalsIgnoreCase(feat) && !feat.startsWith("MODE Z ")) continue;
                    this.modezSupported = true;
                }
            }
            if (this.utf8Supported) {
                this.communication.sendFTPCommand("OPTS UTF8 ON");
                this.communication.readFTPReply();
            }
            if (this.security == 1 || this.security == 2) {
                this.communication.sendFTPCommand("PBSZ 0");
                this.communication.readFTPReply();
                this.communication.sendFTPCommand("PROT P");
                FTPReply reply = this.communication.readFTPReply();
                if (reply.isSuccessCode()) {
                    this.dataChannelEncrypted = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            this.communication.sendFTPCommand("REIN");
            FTPReply r = this.communication.readFTPReply();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
            this.stopAutoNoopTimer();
            this.authenticated = false;
            this.username = null;
            this.password = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noop() throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            this.communication.sendFTPCommand("NOOP");
            FTPReply r = this.communication.readFTPReply();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
            this.touchAutoNoopTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPReply sendCustomCommand(String command) throws IllegalStateException, IOException, FTPIllegalReplyException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            this.communication.sendFTPCommand(command);
            this.touchAutoNoopTimer();
            return this.communication.readFTPReply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPReply sendSiteCommand(String command) throws IllegalStateException, IOException, FTPIllegalReplyException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            this.communication.sendFTPCommand("SITE " + command);
            this.touchAutoNoopTimer();
            return this.communication.readFTPReply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeAccount(String account) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            this.communication.sendFTPCommand("ACCT " + account);
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
        }
    }

    public String currentDirectory() throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            this.communication.sendFTPCommand("PWD");
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
            String[] messages = r.getMessages();
            if (messages.length != 1) {
                throw new FTPIllegalReplyException();
            }
            Matcher m = PWD_PATTERN.matcher(messages[0]);
            if (m.find()) {
                return messages[0].substring(m.start() + 1, m.end() - 1);
            }
            throw new FTPIllegalReplyException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeDirectory(String path) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            this.communication.sendFTPCommand("CWD " + path);
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeDirectoryUp() throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            this.communication.sendFTPCommand("CDUP");
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
        }
    }

    public Date modifiedDate(String path) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            this.communication.sendFTPCommand("MDTM " + path);
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
            String[] messages = r.getMessages();
            if (messages.length != 1) {
                throw new FTPIllegalReplyException();
            }
            try {
                return MDTM_DATE_FORMAT.parse(messages[0]);
            }
            catch (ParseException e) {
                throw new FTPIllegalReplyException();
            }
        }
    }

    public long fileSize(String path) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            this.communication.sendFTPCommand("SIZE " + path);
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
            String[] messages = r.getMessages();
            if (messages.length != 1) {
                throw new FTPIllegalReplyException();
            }
            try {
                return Long.parseLong(messages[0]);
            }
            catch (Throwable t) {
                throw new FTPIllegalReplyException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String oldPath, String newPath) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            this.communication.sendFTPCommand("RNFR " + oldPath);
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (r.getCode() != 350) {
                throw new FTPException(r);
            }
            this.communication.sendFTPCommand("RNTO " + newPath);
            r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(String path) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            this.communication.sendFTPCommand("DELE " + path);
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDirectory(String path) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            this.communication.sendFTPCommand("RMD " + path);
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDirectory(String directoryName) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            this.communication.sendFTPCommand("MKD " + directoryName);
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] help() throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            this.communication.sendFTPCommand("HELP");
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
            return r.getMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] serverStatus() throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            this.communication.sendFTPCommand("STAT");
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
            return r.getMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPFile[] list(String fileSpec) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException, FTPAbortedException, FTPListParseException {
        Object object = this.lock;
        synchronized (object) {
            Socket dtConnection;
            String command;
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            this.communication.sendFTPCommand("TYPE A");
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
            FTPDataTransferConnectionProvider provider = this.openDataTransferChannel();
            boolean mlsdCommand = this.mlsdPolicy == 0 ? this.mlsdSupported : this.mlsdPolicy == 1;
            String string = command = mlsdCommand ? "MLSD" : "LIST";
            if (fileSpec != null && fileSpec.length() > 0) {
                command = command + " " + fileSpec;
            }
            this.communication.sendFTPCommand(command);
            try {
                try {
                    dtConnection = provider.openDataTransferConnection();
                    return dtConnection;
                }
                finally {
                    r = this.communication.readFTPReply();
                    this.touchAutoNoopTimer();
                    if (r.getCode() != 150 && r.getCode() != 125) {
                        throw new FTPException(r);
                    }
                }
            }
            finally {
                provider.dispose();
            }
            Object object2 = this.abortLock;
            synchronized (object2) {
                this.ongoingDataTransfer = true;
                this.aborted = false;
            }
            ArrayList<String> lines = new ArrayList<String>();
            NVTASCIIReader dataReader = null;
            try {
                String line;
                this.dataTransferInputStream = dtConnection.getInputStream();
                if (this.modezEnabled) {
                    this.dataTransferInputStream = new InflaterInputStream(this.dataTransferInputStream);
                }
                dataReader = new NVTASCIIReader(this.dataTransferInputStream, mlsdCommand ? "UTF-8" : this.pickCharset());
                while ((line = dataReader.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    lines.add(line);
                }
            }
            catch (IOException e) {
                Object object3 = this.abortLock;
                synchronized (object3) {
                    if (this.aborted) {
                        throw new FTPAbortedException();
                    }
                    throw new FTPDataTransferException("I/O error in data transfer", e);
                }
            }
            finally {
                if (dataReader != null) {
                    try {
                        dataReader.close();
                    }
                    catch (Throwable t) {}
                }
                try {
                    dtConnection.close();
                }
                catch (Throwable t) {}
                this.communication.readFTPReply();
                this.dataTransferInputStream = null;
                Object t = this.abortLock;
                synchronized (t) {
                    this.ongoingDataTransfer = false;
                    this.aborted = false;
                }
            }
            int size = lines.size();
            String[] list = new String[size];
            for (int i = 0; i < size; ++i) {
                list[i] = (String)lines.get(i);
            }
            FTPFile[] ret = null;
            if (mlsdCommand) {
                MLSDListParser parser = new MLSDListParser();
                ret = parser.parse(list);
            } else if (this.parser == null) {
                Iterator i = this.listParsers.iterator();
                while (i.hasNext()) {
                    FTPListParser aux = (FTPListParser)i.next();
                    try {
                        ret = aux.parse(list);
                        this.parser = aux;
                        break;
                    }
                    catch (FTPListParseException e) {
                    }
                }
            } else {
                ret = this.parser.parse(list);
            }
            if (ret == null) {
                throw new FTPListParseException();
            }
            return ret;
        }
    }

    public FTPFile[] list() throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException, FTPAbortedException, FTPListParseException {
        return this.list(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listNames() throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException, FTPAbortedException, FTPListParseException {
        Object object = this.lock;
        synchronized (object) {
            Socket dtConnection;
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            this.communication.sendFTPCommand("TYPE A");
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
            FTPDataTransferConnectionProvider provider = this.openDataTransferChannel();
            this.communication.sendFTPCommand("NLST");
            try {
                try {
                    dtConnection = provider.openDataTransferConnection();
                    return dtConnection;
                }
                finally {
                    r = this.communication.readFTPReply();
                    if (r.getCode() != 150 && r.getCode() != 125) {
                        throw new FTPException(r);
                    }
                }
            }
            finally {
                provider.dispose();
            }
            Object object2 = this.abortLock;
            synchronized (object2) {
                this.ongoingDataTransfer = true;
                this.aborted = false;
            }
            ArrayList<String> lines = new ArrayList<String>();
            NVTASCIIReader dataReader = null;
            try {
                String line;
                this.dataTransferInputStream = dtConnection.getInputStream();
                if (this.modezEnabled) {
                    this.dataTransferInputStream = new InflaterInputStream(this.dataTransferInputStream);
                }
                dataReader = new NVTASCIIReader(this.dataTransferInputStream, this.pickCharset());
                while ((line = dataReader.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    lines.add(line);
                }
            }
            catch (IOException e) {
                Object object3 = this.abortLock;
                synchronized (object3) {
                    if (this.aborted) {
                        throw new FTPAbortedException();
                    }
                    throw new FTPDataTransferException("I/O error in data transfer", e);
                }
            }
            finally {
                if (dataReader != null) {
                    try {
                        dataReader.close();
                    }
                    catch (Throwable t) {}
                }
                try {
                    dtConnection.close();
                }
                catch (Throwable t) {}
                this.communication.readFTPReply();
                this.dataTransferInputStream = null;
                Object object4 = this.abortLock;
                synchronized (object4) {
                    this.ongoingDataTransfer = false;
                    this.aborted = false;
                }
            }
            int size = lines.size();
            String[] list = new String[size];
            for (int i = 0; i < size; ++i) {
                list[i] = (String)lines.get(i);
            }
            return list;
        }
    }

    public void upload(File file) throws IllegalStateException, FileNotFoundException, IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException, FTPAbortedException {
        this.upload(file, 0L, null);
    }

    public void upload(File file, FTPDataTransferListener listener) throws IllegalStateException, FileNotFoundException, IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException, FTPAbortedException {
        this.upload(file, 0L, listener);
    }

    public void upload(File file, long restartAt) throws IllegalStateException, FileNotFoundException, IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException, FTPAbortedException {
        this.upload(file, restartAt, null);
    }

    public void upload(File file, long restartAt, FTPDataTransferListener listener) throws IllegalStateException, FileNotFoundException, IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException, FTPAbortedException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (IOException e) {
            throw new FTPDataTransferException(e);
        }
        try {
            this.upload(file.getName(), inputStream, restartAt, restartAt, listener);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (FTPIllegalReplyException e) {
            throw e;
        }
        catch (FTPException e) {
            throw e;
        }
        catch (FTPDataTransferException e) {
            throw e;
        }
        catch (FTPAbortedException e) {
            throw e;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(String fileName, InputStream inputStream, long restartAt, long streamOffset, FTPDataTransferListener listener) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException, FTPAbortedException {
        Object object = this.lock;
        synchronized (object) {
            Socket dtConnection;
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            int tp = this.type;
            if (tp == 0) {
                tp = this.detectType(fileName);
            }
            if (tp == 1) {
                this.communication.sendFTPCommand("TYPE A");
            } else if (tp == 2) {
                this.communication.sendFTPCommand("TYPE I");
            }
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
            FTPDataTransferConnectionProvider provider = this.openDataTransferChannel();
            if (this.restSupported || restartAt > 0L) {
                boolean done = false;
                try {
                    this.communication.sendFTPCommand("REST " + restartAt);
                    r = this.communication.readFTPReply();
                    this.touchAutoNoopTimer();
                    if (r.getCode() != 350) {
                        throw new FTPException(r);
                    }
                    done = true;
                }
                finally {
                    if (!done) {
                        provider.dispose();
                    }
                }
            }
            this.communication.sendFTPCommand("STOR " + fileName);
            try {
                try {
                    dtConnection = provider.openDataTransferConnection();
                }
                finally {
                    r = this.communication.readFTPReply();
                    this.touchAutoNoopTimer();
                    if (r.getCode() != 150 && r.getCode() != 125) {
                        throw new FTPException(r);
                    }
                }
            }
            finally {
                provider.dispose();
            }
            Object object2 = this.abortLock;
            synchronized (object2) {
                this.ongoingDataTransfer = true;
                this.aborted = false;
            }
            long done = 0L;
            try {
                inputStream.skip(streamOffset);
                this.dataTransferOutputStream = dtConnection.getOutputStream();
                if (this.modezEnabled) {
                    this.dataTransferOutputStream = new DeflaterOutputStream(this.dataTransferOutputStream);
                }
                if (listener != null) {
                    listener.started();
                }
                if (tp == 1) {
                    int l;
                    InputStreamReader reader = new InputStreamReader(inputStream);
                    OutputStreamWriter writer = new OutputStreamWriter(this.dataTransferOutputStream, this.pickCharset());
                    char[] buffer = new char[65536];
                    while ((l = reader.read(buffer)) != -1) {
                        ((Writer)writer).write(buffer, 0, l);
                        ((Writer)writer).flush();
                        done += (long)l;
                        if (listener == null) continue;
                        listener.transferred(l);
                    }
                } else if (tp == 2) {
                    int l;
                    byte[] buffer = new byte[65536];
                    while ((l = inputStream.read(buffer)) != -1) {
                        this.dataTransferOutputStream.write(buffer, 0, l);
                        this.dataTransferOutputStream.flush();
                        done += (long)l;
                        if (listener == null) continue;
                        listener.transferred(l);
                    }
                }
            }
            catch (IOException e) {
                Object object3 = this.abortLock;
                synchronized (object3) {
                    if (this.aborted) {
                        if (listener != null) {
                            listener.aborted();
                        }
                        throw new FTPAbortedException();
                    }
                    if (listener != null) {
                        listener.failed();
                    }
                    throw new FTPDataTransferException("I/O error in data transfer", e);
                }
            }
            finally {
                if (this.dataTransferOutputStream != null) {
                    try {
                        this.dataTransferOutputStream.close();
                    }
                    catch (Throwable t) {}
                }
                try {
                    dtConnection.close();
                }
                catch (Throwable t) {}
                this.dataTransferOutputStream = null;
                this.communication.readFTPReply();
                Object object4 = this.abortLock;
                synchronized (object4) {
                    this.ongoingDataTransfer = false;
                    this.aborted = false;
                }
            }
            if (listener != null) {
                listener.completed();
            }
        }
    }

    public void append(File file) throws IllegalStateException, FileNotFoundException, IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException, FTPAbortedException {
        this.append(file, null);
    }

    public void append(File file, FTPDataTransferListener listener) throws IllegalStateException, FileNotFoundException, IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException, FTPAbortedException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (IOException e) {
            throw new FTPDataTransferException(e);
        }
        try {
            this.append(file.getName(), inputStream, 0L, listener);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (FTPIllegalReplyException e) {
            throw e;
        }
        catch (FTPException e) {
            throw e;
        }
        catch (FTPDataTransferException e) {
            throw e;
        }
        catch (FTPAbortedException e) {
            throw e;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String fileName, InputStream inputStream, long streamOffset, FTPDataTransferListener listener) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException, FTPAbortedException {
        Object object = this.lock;
        synchronized (object) {
            Socket dtConnection;
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            int tp = this.type;
            if (tp == 0) {
                tp = this.detectType(fileName);
            }
            if (tp == 1) {
                this.communication.sendFTPCommand("TYPE A");
            } else if (tp == 2) {
                this.communication.sendFTPCommand("TYPE I");
            }
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
            FTPDataTransferConnectionProvider provider = this.openDataTransferChannel();
            this.communication.sendFTPCommand("APPE " + fileName);
            try {
                try {
                    dtConnection = provider.openDataTransferConnection();
                }
                finally {
                    r = this.communication.readFTPReply();
                    this.touchAutoNoopTimer();
                    if (r.getCode() != 150 && r.getCode() != 125) {
                        throw new FTPException(r);
                    }
                }
            }
            finally {
                provider.dispose();
            }
            Object object2 = this.abortLock;
            synchronized (object2) {
                this.ongoingDataTransfer = true;
                this.aborted = false;
            }
            long done = 0L;
            try {
                inputStream.skip(streamOffset);
                this.dataTransferOutputStream = dtConnection.getOutputStream();
                if (this.modezEnabled) {
                    this.dataTransferOutputStream = new DeflaterOutputStream(this.dataTransferOutputStream);
                }
                if (listener != null) {
                    listener.started();
                }
                if (tp == 1) {
                    int l;
                    InputStreamReader reader = new InputStreamReader(inputStream);
                    OutputStreamWriter writer = new OutputStreamWriter(this.dataTransferOutputStream, this.pickCharset());
                    char[] buffer = new char[65536];
                    while ((l = reader.read(buffer)) != -1) {
                        ((Writer)writer).write(buffer, 0, l);
                        ((Writer)writer).flush();
                        done += (long)l;
                        if (listener == null) continue;
                        listener.transferred(l);
                    }
                } else if (tp == 2) {
                    int l;
                    byte[] buffer = new byte[65536];
                    while ((l = inputStream.read(buffer)) != -1) {
                        this.dataTransferOutputStream.write(buffer, 0, l);
                        this.dataTransferOutputStream.flush();
                        done += (long)l;
                        if (listener == null) continue;
                        listener.transferred(l);
                    }
                }
            }
            catch (IOException e) {
                Object object3 = this.abortLock;
                synchronized (object3) {
                    if (this.aborted) {
                        if (listener != null) {
                            listener.aborted();
                        }
                        throw new FTPAbortedException();
                    }
                    if (listener != null) {
                        listener.failed();
                    }
                    throw new FTPDataTransferException("I/O error in data transfer", e);
                }
            }
            finally {
                if (this.dataTransferOutputStream != null) {
                    try {
                        this.dataTransferOutputStream.close();
                    }
                    catch (Throwable t) {}
                }
                try {
                    dtConnection.close();
                }
                catch (Throwable t) {}
                this.dataTransferOutputStream = null;
                this.communication.readFTPReply();
                Object object4 = this.abortLock;
                synchronized (object4) {
                    this.ongoingDataTransfer = false;
                    this.aborted = false;
                }
            }
            if (listener != null) {
                listener.completed();
            }
        }
    }

    public void download(String remoteFileName, File localFile) throws IllegalStateException, FileNotFoundException, IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException, FTPAbortedException {
        this.download(remoteFileName, localFile, 0L, null);
    }

    public void download(String remoteFileName, File localFile, FTPDataTransferListener listener) throws IllegalStateException, FileNotFoundException, IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException, FTPAbortedException {
        this.download(remoteFileName, localFile, 0L, listener);
    }

    public void download(String remoteFileName, File localFile, long restartAt) throws IllegalStateException, FileNotFoundException, IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException, FTPAbortedException {
        this.download(remoteFileName, localFile, restartAt, null);
    }

    public void download(String remoteFileName, File localFile, long restartAt, FTPDataTransferListener listener) throws IllegalStateException, FileNotFoundException, IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException, FTPAbortedException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(localFile, restartAt > 0L);
        }
        catch (IOException e) {
            throw new FTPDataTransferException(e);
        }
        try {
            this.download(remoteFileName, outputStream, restartAt, listener);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (FTPIllegalReplyException e) {
            throw e;
        }
        catch (FTPException e) {
            throw e;
        }
        catch (FTPDataTransferException e) {
            throw e;
        }
        catch (FTPAbortedException e) {
            throw e;
        }
        finally {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String fileName, OutputStream outputStream, long restartAt, FTPDataTransferListener listener) throws IllegalStateException, IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException, FTPAbortedException {
        Object object = this.lock;
        synchronized (object) {
            Socket dtConnection;
            if (!this.connected) {
                throw new IllegalStateException("Client not connected");
            }
            if (!this.authenticated) {
                throw new IllegalStateException("Client not authenticated");
            }
            int tp = this.type;
            if (tp == 0) {
                tp = this.detectType(fileName);
            }
            if (tp == 1) {
                this.communication.sendFTPCommand("TYPE A");
            } else if (tp == 2) {
                this.communication.sendFTPCommand("TYPE I");
            }
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (!r.isSuccessCode()) {
                throw new FTPException(r);
            }
            FTPDataTransferConnectionProvider provider = this.openDataTransferChannel();
            if (this.restSupported || restartAt > 0L) {
                boolean done = false;
                try {
                    this.communication.sendFTPCommand("REST " + restartAt);
                    r = this.communication.readFTPReply();
                    this.touchAutoNoopTimer();
                    if (r.getCode() != 350) {
                        throw new FTPException(r);
                    }
                    done = true;
                }
                finally {
                    if (!done) {
                        provider.dispose();
                    }
                }
            }
            this.communication.sendFTPCommand("RETR " + fileName);
            try {
                try {
                    dtConnection = provider.openDataTransferConnection();
                }
                finally {
                    r = this.communication.readFTPReply();
                    this.touchAutoNoopTimer();
                    if (r.getCode() != 150 && r.getCode() != 125) {
                        throw new FTPException(r);
                    }
                }
            }
            finally {
                provider.dispose();
            }
            Object object2 = this.abortLock;
            synchronized (object2) {
                this.ongoingDataTransfer = true;
                this.aborted = false;
            }
            try {
                this.dataTransferInputStream = dtConnection.getInputStream();
                if (this.modezEnabled) {
                    this.dataTransferInputStream = new InflaterInputStream(this.dataTransferInputStream);
                }
                if (listener != null) {
                    listener.started();
                }
                if (tp == 1) {
                    int l;
                    InputStreamReader reader = new InputStreamReader(this.dataTransferInputStream, this.pickCharset());
                    OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                    char[] buffer = new char[65536];
                    while ((l = ((Reader)reader).read(buffer, 0, buffer.length)) != -1) {
                        ((Writer)writer).write(buffer, 0, l);
                        ((Writer)writer).flush();
                        if (listener == null) continue;
                        listener.transferred(l);
                    }
                } else if (tp == 2) {
                    int l;
                    byte[] buffer = new byte[65536];
                    while ((l = this.dataTransferInputStream.read(buffer, 0, buffer.length)) != -1) {
                        outputStream.write(buffer, 0, l);
                        if (listener == null) continue;
                        listener.transferred(l);
                    }
                }
            }
            catch (IOException e) {
                Object object3 = this.abortLock;
                synchronized (object3) {
                    if (this.aborted) {
                        if (listener != null) {
                            listener.aborted();
                        }
                        throw new FTPAbortedException();
                    }
                    if (listener != null) {
                        listener.failed();
                    }
                    throw new FTPDataTransferException("I/O error in data transfer", e);
                }
            }
            finally {
                if (this.dataTransferInputStream != null) {
                    try {
                        this.dataTransferInputStream.close();
                    }
                    catch (Throwable t) {}
                }
                try {
                    dtConnection.close();
                }
                catch (Throwable t) {}
                this.dataTransferInputStream = null;
                this.communication.readFTPReply();
                Object object4 = this.abortLock;
                synchronized (object4) {
                    this.ongoingDataTransfer = false;
                    this.aborted = false;
                }
            }
            if (listener != null) {
                listener.completed();
            }
        }
    }

    private int detectType(String fileName) throws IOException, FTPIllegalReplyException, FTPException {
        int start = fileName.lastIndexOf(46) + 1;
        int stop = fileName.length();
        if (start > 0 && start < stop - 1) {
            String ext = fileName.substring(start, stop);
            if (this.textualExtensionRecognizer.isTextualExt(ext = ext.toLowerCase())) {
                return 1;
            }
            return 2;
        }
        return 2;
    }

    private FTPDataTransferConnectionProvider openDataTransferChannel() throws IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException {
        if (this.modezSupported && this.compressionEnabled) {
            if (!this.modezEnabled) {
                this.communication.sendFTPCommand("MODE Z");
                FTPReply r = this.communication.readFTPReply();
                this.touchAutoNoopTimer();
                if (r.isSuccessCode()) {
                    this.modezEnabled = true;
                }
            }
        } else if (this.modezEnabled) {
            this.communication.sendFTPCommand("MODE S");
            FTPReply r = this.communication.readFTPReply();
            this.touchAutoNoopTimer();
            if (r.isSuccessCode()) {
                this.modezEnabled = false;
            }
        }
        if (this.passive) {
            return this.openPassiveDataTransferChannel();
        }
        return this.openActiveDataTransferChannel();
    }

    private FTPDataTransferConnectionProvider openActiveDataTransferChannel() throws IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException {
        FTPDataTransferServer server = new FTPDataTransferServer(){

            public Socket openDataTransferConnection() throws FTPDataTransferException {
                Socket socket = super.openDataTransferConnection();
                if (FTPClient.this.dataChannelEncrypted) {
                    try {
                        socket = FTPClient.this.ssl(socket, socket.getInetAddress().getHostName(), socket.getPort());
                    }
                    catch (IOException e) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw new FTPDataTransferException(e);
                    }
                }
                return socket;
            }
        };
        int port = server.getPort();
        int p1 = port >>> 8;
        int p2 = port & 0xFF;
        int[] addr = this.pickLocalAddress();
        this.communication.sendFTPCommand("PORT " + addr[0] + "," + addr[1] + "," + addr[2] + "," + addr[3] + "," + p1 + "," + p2);
        FTPReply r = this.communication.readFTPReply();
        this.touchAutoNoopTimer();
        if (!r.isSuccessCode()) {
            server.dispose();
            try {
                Socket aux = server.openDataTransferConnection();
                aux.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw new FTPException(r);
        }
        return server;
    }

    private FTPDataTransferConnectionProvider openPassiveDataTransferChannel() throws IOException, FTPIllegalReplyException, FTPException, FTPDataTransferException {
        this.communication.sendFTPCommand("PASV");
        FTPReply r = this.communication.readFTPReply();
        this.touchAutoNoopTimer();
        if (!r.isSuccessCode()) {
            throw new FTPException(r);
        }
        String addressAndPort = null;
        String[] messages = r.getMessages();
        for (int i = 0; i < messages.length; ++i) {
            Matcher m = PASV_PATTERN.matcher(messages[i]);
            if (!m.find()) continue;
            int start = m.start();
            int end = m.end();
            addressAndPort = messages[i].substring(start, end);
            break;
        }
        if (addressAndPort == null) {
            throw new FTPIllegalReplyException();
        }
        StringTokenizer st = new StringTokenizer(addressAndPort, ",");
        int b1 = Integer.parseInt(st.nextToken());
        int b2 = Integer.parseInt(st.nextToken());
        int b3 = Integer.parseInt(st.nextToken());
        int b4 = Integer.parseInt(st.nextToken());
        int p1 = Integer.parseInt(st.nextToken());
        int p2 = Integer.parseInt(st.nextToken());
        String useSuggestedAddress = System.getProperty("ftp4j.passiveDataTransfer.useSuggestedAddress");
        final InetAddress remoteAddress = "true".equalsIgnoreCase(useSuggestedAddress) || "yes".equalsIgnoreCase(useSuggestedAddress) || "1".equals(useSuggestedAddress) ? InetAddress.getByAddress(new byte[]{(byte)b1, (byte)b2, (byte)b3, (byte)b4}) : InetAddress.getByName(this.host);
        final int remotePort = p1 << 8 | p2;
        FTPDataTransferConnectionProvider provider = new FTPDataTransferConnectionProvider(){

            public Socket openDataTransferConnection() throws FTPDataTransferException {
                Socket dtConnection;
                String remoteHost = remoteAddress.getHostAddress();
                try {
                    dtConnection = FTPClient.this.connector.connectForDataTransferChannel(remoteHost, remotePort);
                    if (FTPClient.this.dataChannelEncrypted) {
                        dtConnection = FTPClient.this.ssl(dtConnection, remoteHost, remotePort);
                    }
                }
                catch (IOException e) {
                    throw new FTPDataTransferException("Cannot connect to the remote server", e);
                }
                return dtConnection;
            }

            public void dispose() {
            }
        };
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortCurrentDataTransfer(boolean sendAborCommand) throws IOException, FTPIllegalReplyException {
        Object object = this.abortLock;
        synchronized (object) {
            if (this.ongoingDataTransfer && !this.aborted) {
                if (sendAborCommand) {
                    this.communication.sendFTPCommand("ABOR");
                    this.communication.readFTPReply();
                    this.touchAutoNoopTimer();
                }
                if (this.dataTransferInputStream != null) {
                    try {
                        this.dataTransferInputStream.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (this.dataTransferOutputStream != null) {
                    try {
                        this.dataTransferOutputStream.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.aborted = true;
            }
        }
    }

    private String pickCharset() {
        if (this.charset != null) {
            return this.charset;
        }
        if (this.utf8Supported) {
            return "UTF-8";
        }
        return System.getProperty("file.encoding");
    }

    private int[] pickLocalAddress() throws IOException {
        int[] ret = this.pickForcedLocalAddress();
        if (ret == null) {
            ret = this.pickAutoDetectedLocalAddress();
        }
        return ret;
    }

    private int[] pickForcedLocalAddress() {
        int[] ret = null;
        String aux = System.getProperty("ftp4j.activeDataTransfer.hostAddress");
        if (aux != null) {
            boolean valid = false;
            StringTokenizer st = new StringTokenizer(aux, ".");
            if (st.countTokens() == 4) {
                valid = true;
                int[] arr = new int[4];
                for (int i = 0; i < 4; ++i) {
                    String tk = st.nextToken();
                    try {
                        arr[i] = Integer.parseInt(tk);
                    }
                    catch (NumberFormatException e) {
                        arr[i] = -1;
                    }
                    if (arr[i] >= 0 && arr[i] <= 255) continue;
                    valid = false;
                    break;
                }
                if (valid) {
                    ret = arr;
                }
            }
            if (!valid) {
                System.err.println("WARNING: invalid value \"" + aux + "\" for the " + "ftp4j.activeDataTransfer.hostAddress" + " system property. The value should " + "be in the x.x.x.x form.");
            }
        }
        return ret;
    }

    private int[] pickAutoDetectedLocalAddress() throws IOException {
        InetAddress addressObj = InetAddress.getLocalHost();
        byte[] addr = addressObj.getAddress();
        int b1 = addr[0] & 0xFF;
        int b2 = addr[1] & 0xFF;
        int b3 = addr[2] & 0xFF;
        int b4 = addr[3] & 0xFF;
        int[] ret = new int[]{b1, b2, b3, b4};
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            FTPCommunicationListener[] communicationListeners;
            int i;
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getClass().getName());
            buffer.append(" [connected=");
            buffer.append(this.connected);
            if (this.connected) {
                buffer.append(", host=");
                buffer.append(this.host);
                buffer.append(", port=");
                buffer.append(this.port);
            }
            buffer.append(", connector=");
            buffer.append(this.connector);
            buffer.append(", security=");
            switch (this.security) {
                case 0: {
                    buffer.append("SECURITY_FTP");
                    break;
                }
                case 1: {
                    buffer.append("SECURITY_FTPS");
                    break;
                }
                case 2: {
                    buffer.append("SECURITY_FTPES");
                }
            }
            buffer.append(", authenticated=");
            buffer.append(this.authenticated);
            if (this.authenticated) {
                buffer.append(", username=");
                buffer.append(this.username);
                buffer.append(", password=");
                StringBuffer buffer2 = new StringBuffer();
                for (i = 0; i < this.password.length(); ++i) {
                    buffer2.append('*');
                }
                buffer.append(buffer2);
                buffer.append(", restSupported=");
                buffer.append(this.restSupported);
                buffer.append(", utf8supported=");
                buffer.append(this.utf8Supported);
                buffer.append(", mlsdSupported=");
                buffer.append(this.mlsdSupported);
                buffer.append(", mode=modezSupported");
                buffer.append(this.modezSupported);
                buffer.append(", mode=modezEnabled");
                buffer.append(this.modezEnabled);
            }
            buffer.append(", transfer mode=");
            buffer.append(this.passive ? "passive" : "active");
            buffer.append(", transfer type=");
            switch (this.type) {
                case 0: {
                    buffer.append("TYPE_AUTO");
                    break;
                }
                case 2: {
                    buffer.append("TYPE_BINARY");
                    break;
                }
                case 1: {
                    buffer.append("TYPE_TEXTUAL");
                }
            }
            buffer.append(", textualExtensionRecognizer=");
            buffer.append(this.textualExtensionRecognizer);
            FTPListParser[] listParsers = this.getListParsers();
            if (listParsers.length > 0) {
                buffer.append(", listParsers=");
                for (i = 0; i < listParsers.length; ++i) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(listParsers[i]);
                }
            }
            if ((communicationListeners = this.getCommunicationListeners()).length > 0) {
                buffer.append(", communicationListeners=");
                for (int i2 = 0; i2 < communicationListeners.length; ++i2) {
                    if (i2 > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(communicationListeners[i2]);
                }
            }
            buffer.append(", autoNoopTimeout=");
            buffer.append(this.autoNoopTimeout);
            buffer.append("]");
            return buffer.toString();
        }
    }

    private void startAutoNoopTimer() {
        if (this.autoNoopTimeout > 0L) {
            this.autoNoopTimer = new AutoNoopTimer();
            this.autoNoopTimer.start();
        }
    }

    private void stopAutoNoopTimer() {
        if (this.autoNoopTimer != null) {
            this.autoNoopTimer.interrupt();
            this.autoNoopTimer = null;
        }
    }

    private void touchAutoNoopTimer() {
        if (this.autoNoopTimer != null) {
            this.nextAutoNoopTime = System.currentTimeMillis() + this.autoNoopTimeout;
        }
    }

    private class AutoNoopTimer
    extends Thread {
        private AutoNoopTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = FTPClient.this.lock;
            synchronized (object) {
                if (FTPClient.this.nextAutoNoopTime <= 0L && FTPClient.this.autoNoopTimeout > 0L) {
                    FTPClient.this.nextAutoNoopTime = System.currentTimeMillis() + FTPClient.this.autoNoopTimeout;
                }
                while (!Thread.interrupted() && FTPClient.this.autoNoopTimeout > 0L) {
                    long delay = FTPClient.this.nextAutoNoopTime - System.currentTimeMillis();
                    if (delay > 0L) {
                        try {
                            FTPClient.this.lock.wait(delay);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    if (System.currentTimeMillis() < FTPClient.this.nextAutoNoopTime) continue;
                    try {
                        FTPClient.this.noop();
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }
}

