/*
 * Decompiled with CFR 0.152.
 */
package com.registry;

import com.registry.DefaultDisposerRecord;
import com.registry.DisposerRecord;
import com.registry.DisposerTarget;
import com.registry.RegistryKey;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;

class Disposer
implements Runnable {
    private static final ReferenceQueue<Object> queue = new ReferenceQueue();
    private static final Hashtable<Reference, DisposerRecord> records = new Hashtable();
    private static Disposer disposerInstance;
    public static final int WEAK = 0;
    public static final int PHANTOM = 1;
    private static int refType;
    private static ArrayList<DisposerRecord> deferredRecords;
    public static volatile boolean pollingQueue;

    Disposer() {
    }

    public static void addRecord(Object object, long l, long l2) {
        disposerInstance.add(object, new DefaultDisposerRecord(l, l2));
    }

    public static void addRecord(Object object, DisposerRecord disposerRecord) {
        disposerInstance.add(object, disposerRecord);
    }

    synchronized void add(Object object, DisposerRecord disposerRecord) {
        if (object instanceof DisposerTarget) {
            object = ((DisposerTarget)object).getDisposerReferent();
        }
        Reference reference = refType == 1 ? new PhantomReference<Object>(object, queue) : new WeakReference<Object>(object, queue);
        records.put(reference, disposerRecord);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Reference<Object> reference = queue.remove();
                    reference.clear();
                    DisposerRecord disposerRecord = records.remove(reference);
                    disposerRecord.dispose();
                    reference = null;
                    disposerRecord = null;
                    Disposer.clearDeferredRecords();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception while removing reference: " + exception);
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static void clearDeferredRecords() {
        if (deferredRecords == null || deferredRecords.isEmpty()) {
            return;
        }
        for (int i = 0; i < deferredRecords.size(); ++i) {
            try {
                DisposerRecord disposerRecord = deferredRecords.get(i);
                disposerRecord.dispose();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Exception while disposing deferred rec.");
                exception.printStackTrace();
            }
        }
        deferredRecords.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pollRemove() {
        if (pollingQueue) {
            return;
        }
        pollingQueue = true;
        int n = 0;
        int n2 = 0;
        try {
            Reference<Object> reference;
            while ((reference = queue.poll()) != null && n < 10000 && n2 < 100) {
                ++n;
                reference.clear();
                DisposerRecord disposerRecord = records.remove(reference);
                if (disposerRecord instanceof PollDisposable) {
                    disposerRecord.dispose();
                    reference = null;
                    disposerRecord = null;
                    continue;
                }
                if (disposerRecord == null) continue;
                ++n2;
                if (deferredRecords == null) {
                    deferredRecords = new ArrayList(5);
                }
                deferredRecords.add(disposerRecord);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception while removing reference: " + exception);
            exception.printStackTrace();
        }
        finally {
            pollingQueue = false;
        }
    }

    private static native void initIDs();

    public static void addReference(Reference reference, DisposerRecord disposerRecord) {
        records.put(reference, disposerRecord);
    }

    public static void addObjectRecord(Object object, DisposerRecord disposerRecord) {
        records.put(new WeakReference<Object>(object, queue), disposerRecord);
    }

    public static ReferenceQueue getQueue() {
        return queue;
    }

    static {
        refType = 1;
        RegistryKey.initialize();
        Disposer.initIDs();
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("sun.java2d.reftype");
            }
        });
        if (string != null) {
            if (string.equals("weak")) {
                refType = 0;
                System.err.println("Using WEAK refs");
            } else {
                refType = 1;
                System.err.println("Using PHANTOM refs");
            }
        }
        disposerInstance = new Disposer();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                Object object = threadGroup;
                while (object != null) {
                    threadGroup = object;
                    object = threadGroup.getParent();
                }
                object = new Thread(threadGroup, disposerInstance, "JRegistry Disposer");
                ((Thread)object).setContextClassLoader(null);
                ((Thread)object).setDaemon(true);
                ((Thread)object).setPriority(10);
                ((Thread)object).start();
                return null;
            }
        });
        deferredRecords = null;
        pollingQueue = false;
    }

    public static interface PollDisposable {
    }
}

