/*
 * Decompiled with CFR 0.152.
 */
package com.registry;

import com.registry.RegistryException;
import com.registry.RegistryKey;
import com.registry.RegistryValue;
import com.registry.ValueType;
import com.registry.WinRegistryAPI;

public class RegBinaryValue
extends RegistryValue {
    static final long serialVersionUID = 5098519913987257547L;

    RegBinaryValue(RegistryKey registryKey, String string, ValueType valueType, byte[] byArray) {
        super(registryKey, string, valueType, byArray);
    }

    RegBinaryValue(RegistryKey registryKey, String string, int n, byte[] byArray) {
        this.key = registryKey;
        this.name = string;
        this.type = null;
        this.value = byArray;
        this.typei = n;
    }

    public byte[] getValue() {
        if (this.typei != 3 && this.typei != 0 && this.typei != 6 && this.typei != 8 && this.typei != 9 && this.typei != 10) {
            return super.getByteData();
        }
        return (byte[])this.value;
    }

    public int setValue(byte ... byArray) {
        if (this.typei != 3 && this.typei != 0 && this.typei != 6 && this.typei != 8 && this.typei != 9 && this.typei != 10) {
            return super.setByteData(byArray);
        }
        long[] lArray = this.key.openKey0(2);
        long l = lArray[1];
        if (l != 0L) {
            int n = WinRegistryAPI.RegSetValueEx(l, this.name, this.typei, byArray);
            if (n == 0) {
                this.value = byArray;
            }
            this.key.closeKey0(lArray[0]);
            lArray = null;
            return n;
        }
        this.key.closeKey0(lArray[0]);
        lArray = null;
        return this.key.getLastError();
    }

    public int refreshData() {
        long[] lArray = this.key.openKey0(1);
        long l = lArray[1];
        if (l != 0L) {
            Object[] objectArray = WinRegistryAPI.RegQueryValueEx(l, this.name);
            if (objectArray != null) {
                int n = (Integer)objectArray[1];
                if (n != 3 && n != 0 && n != 6 && n != 8 && n != 9 && n != 10 || n > 11) {
                    throw new RegistryException(this.name + " is no longer of type REG_BINARY, REG_NONE, REG_LINK, " + "REG_RESOURCE_LIST, REG_FULL_RESOURCE_DESCRIPTOR, " + "or REG_RESOURCE_REQUIREMENTS_LIST.");
                }
                this.typei = n;
                this.type = RegistryKey.getValueType(n);
                this.value = (byte[])objectArray[2];
                objectArray = null;
            }
            this.key.closeKey0(lArray[0]);
        }
        lArray = null;
        return this.key.getLastError();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        byte[] byArray = this.getValue();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[i]));
            if (i >= byArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return super.toString() + " Value: " + stringBuffer.toString();
    }
}

