/*
 * Decompiled with CFR 0.152.
 */
package com.registry;

import com.registry.RegistryException;
import com.registry.RegistryKey;
import com.registry.RegistryValue;
import com.registry.ValueType;
import com.registry.WinRegistryAPI;

public class RegDWORDValue
extends RegistryValue {
    static final long serialVersionUID = 5627741583641998565L;

    RegDWORDValue(RegistryKey registryKey, String string, ValueType valueType, Integer n) {
        super(registryKey, string, valueType, n);
    }

    public Integer getValue() {
        if (!(this.type.equals((Object)ValueType.REG_DWORD) || this.type.equals((Object)ValueType.REG_DWORD_LITTLE_ENDIAN) || this.type.equals((Object)ValueType.REG_DWORD_BIG_ENDIAN))) {
            throw new RegistryException(this.name + " is no longer of type REG_DWORD, REG_DWORD_LITTLE_ENDIAN " + "or REG_DWORD_BIG_ENDIAN.");
        }
        if (super.getByteLength() != 4) {
            throw new RegistryException("DWORD value has invalid number of bytes.");
        }
        return (Integer)this.value;
    }

    public int getIntValue() {
        return this.getValue();
    }

    public int setValue(Integer n) {
        if (!(this.type.equals((Object)ValueType.REG_DWORD) || this.type.equals((Object)ValueType.REG_DWORD_LITTLE_ENDIAN) || this.type.equals((Object)ValueType.REG_DWORD_BIG_ENDIAN))) {
            throw new RegistryException(this.name + " is no longer of type REG_DWORD, REG_DWORD_LITTLE_ENDIAN " + "or REG_DWORD_BIG_ENDIAN.");
        }
        long[] lArray = this.key.openKey0(2);
        long l = lArray[1];
        if (l != 0L) {
            int n2 = WinRegistryAPI.RegSetValueEx(l, this.name, this.type.getValue(), n);
            if (n2 == 0) {
                this.value = n;
            }
            this.key.closeKey0(lArray[0]);
            lArray = null;
            return n2;
        }
        this.key.closeKey0(lArray[0]);
        lArray = null;
        return this.key.getLastError();
    }

    public int setIntValue(int n) {
        return this.setValue(n);
    }

    public int refreshData() {
        long[] lArray = this.key.openKey0(1);
        long l = lArray[1];
        if (l != 0L) {
            Object[] objectArray = WinRegistryAPI.RegQueryValueEx(l, this.name);
            if (objectArray != null) {
                int n = (Integer)objectArray[1];
                if (n != 4 && n != 5) {
                    throw new RegistryException(this.name + " is no longer of type REG_DWORD_LITTLE_ENDIAN " + "or REG_DWORD_BIG_ENDIAN.");
                }
                this.typei = n;
                this.type = RegistryKey.getValueType(n);
                this.value = (Integer)objectArray[2];
                objectArray = null;
            }
            this.key.closeKey0(lArray[0]);
        }
        lArray = null;
        return this.key.getLastError();
    }

    public String toString() {
        try {
            return super.toString() + " Value: " + this.getValue();
        }
        catch (RegistryException registryException) {
            StringBuffer stringBuffer = new StringBuffer("[");
            byte[] byArray = super.getByteData();
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(Integer.toHexString(byArray[i]));
                if (i >= byArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
            return super.toString() + " Value: " + stringBuffer.toString();
        }
    }
}

