/*
 * Decompiled with CFR 0.152.
 */
package com.registry;

import com.registry.RegistryException;
import com.registry.RegistryKey;
import com.registry.RegistryValue;
import com.registry.ValueType;
import com.registry.WinRegistryAPI;
import java.util.Arrays;

public class RegMultiStringValue
extends RegistryValue {
    static final long serialVersionUID = 2843599880957020869L;

    RegMultiStringValue(RegistryKey registryKey, String string, ValueType valueType, String[] stringArray) {
        super(registryKey, string, valueType, stringArray);
    }

    public String[] getValue() {
        if (!this.type.equals((Object)ValueType.REG_MULTI_SZ)) {
            throw new RegistryException(this.name + " is no longer of type REG_MULTI_SZ.");
        }
        return (String[])this.value;
    }

    public int setValue(String ... stringArray) {
        if (!this.type.equals((Object)ValueType.REG_MULTI_SZ)) {
            throw new RegistryException(this.name + " is no longer of type REG_MULTI_SZ.");
        }
        long[] lArray = this.key.openKey0(2);
        long l = lArray[1];
        if (l != 0L) {
            int n = WinRegistryAPI.RegSetValueEx(l, this.name, this.type.getValue(), stringArray);
            if (n == 0) {
                this.value = stringArray;
            }
            this.key.closeKey0(lArray[0]);
            lArray = null;
            return n;
        }
        this.key.closeKey0(lArray[0]);
        lArray = null;
        return this.key.getLastError();
    }

    public int refreshData() {
        long[] lArray = this.key.openKey0(1);
        long l = lArray[1];
        if (l != 0L) {
            Object[] objectArray = WinRegistryAPI.RegQueryValueEx(l, this.name);
            if (objectArray != null) {
                int n = (Integer)objectArray[1];
                if (n != 7) {
                    throw new RegistryException(this.name + " is no longer of type REG_MULTI_SZ.");
                }
                this.typei = n;
                this.type = RegistryKey.getValueType(n);
                this.value = (String[])objectArray[2];
                objectArray = null;
            }
            this.key.closeKey0(lArray[0]);
        }
        lArray = null;
        return this.key.getLastError();
    }

    public String toString() {
        try {
            return super.toString() + " Value: " + Arrays.deepToString(this.getValue());
        }
        catch (RegistryException registryException) {
            StringBuffer stringBuffer = new StringBuffer("[");
            byte[] byArray = super.getByteData();
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(Integer.toHexString(byArray[i]));
                if (i >= byArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
            return super.toString() + " Value: " + stringBuffer.toString();
        }
    }
}

