/*
 * Decompiled with CFR 0.152.
 */
package com.registry;

import com.registry.RegistryException;
import com.registry.RegistryKey;
import com.registry.RegistryValue;
import com.registry.ValueType;
import com.registry.WinRegistryAPI;

public class RegQWORDValue
extends RegistryValue {
    static final long serialVersionUID = 5045892518245658223L;

    RegQWORDValue(RegistryKey registryKey, String string, ValueType valueType, Long l) {
        super(registryKey, string, valueType, l);
    }

    public Long getValue() {
        if (!this.type.equals((Object)ValueType.REG_QWORD) && !this.type.equals((Object)ValueType.REG_QWORD_LITTLE_ENDIAN)) {
            throw new RegistryException(this.name + " is no longer of type REG_QWORD or REG_QWORD_LITTLE_ENDIAN.");
        }
        if (super.getByteLength() != 8) {
            throw new RegistryException("QWORD value has invalid number of bytes.");
        }
        return (Long)this.value;
    }

    public long getLongValue() {
        return this.getValue();
    }

    public int setValue(Long l) {
        if (!this.type.equals((Object)ValueType.REG_QWORD) && !this.type.equals((Object)ValueType.REG_QWORD_LITTLE_ENDIAN)) {
            throw new RegistryException(this.name + " is no longer of type REG_QWORD or REG_QWORD_LITTLE_ENDIAN.");
        }
        long[] lArray = this.key.openKey0(2);
        long l2 = lArray[1];
        if (l2 != 0L) {
            int n = WinRegistryAPI.RegSetValueEx(l2, this.name, this.type.getValue(), l);
            if (n == 0) {
                this.value = l;
            }
            this.key.closeKey0(lArray[0]);
            lArray = null;
            return n;
        }
        this.key.closeKey0(lArray[0]);
        lArray = null;
        return this.key.getLastError();
    }

    public int setLongValue(long l) {
        return this.setValue(l);
    }

    public int refreshData() {
        long[] lArray = this.key.openKey0(1);
        long l = lArray[1];
        if (l != 0L) {
            Object[] objectArray = WinRegistryAPI.RegQueryValueEx(l, this.name);
            if (objectArray != null) {
                int n = (Integer)objectArray[1];
                if (n != 11) {
                    throw new RegistryException(this.name + " is no longer of type REG_QWORD_LITTLE_ENDIAN.");
                }
                this.typei = n;
                this.type = RegistryKey.getValueType(n);
                this.value = (Long)objectArray[2];
                objectArray = null;
            }
            this.key.closeKey0(lArray[0]);
        }
        lArray = null;
        return this.key.getLastError();
    }

    public String toString() {
        try {
            return super.toString() + " Value: " + this.getValue();
        }
        catch (RegistryException registryException) {
            StringBuffer stringBuffer = new StringBuffer("[");
            byte[] byArray = super.getByteData();
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(Integer.toHexString(byArray[i]));
                if (i >= byArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
            return super.toString() + " Value: " + stringBuffer.toString();
        }
    }
}

