/*
 * Decompiled with CFR 0.152.
 */
package com.registry;

import com.registry.RegistryException;
import com.registry.RegistryKey;
import com.registry.RegistryValue;
import com.registry.ValueType;
import com.registry.WinRegistryAPI;

public class RegStringValue
extends RegistryValue {
    static final long serialVersionUID = -329641674663305163L;

    RegStringValue(RegistryKey registryKey, String string, ValueType valueType, String string2) {
        super(registryKey, string, valueType, string2);
    }

    public String getValue() {
        if (!this.type.equals((Object)ValueType.REG_SZ) && !this.type.equals((Object)ValueType.REG_EXPAND_SZ)) {
            throw new RegistryException(this.name + " is no longer of type REG_SZ or REG_EXPAND_SZ.");
        }
        return (String)this.value;
    }

    public int setValue(String string) {
        if (!this.type.equals((Object)ValueType.REG_SZ) && !this.type.equals((Object)ValueType.REG_EXPAND_SZ)) {
            throw new RegistryException(this.name + " is no longer of type REG_SZ or REG_EXPAND_SZ.");
        }
        long[] lArray = this.key.openKey0(2);
        long l = lArray[1];
        if (l != 0L) {
            int n = WinRegistryAPI.RegSetValueEx(l, this.name, this.type.getValue(), string);
            if (n == 0) {
                this.value = this.typei == 2 ? (RegistryKey.isAutoExpandEnvironmentVariables() ? RegistryKey.expandEnvironmentVariables(string) : string) : string;
            }
            this.key.closeKey0(lArray[0]);
            lArray = null;
            return n;
        }
        this.key.closeKey0(lArray[0]);
        lArray = null;
        return this.key.getLastError();
    }

    public int refreshData() {
        long[] lArray = this.key.openKey0(1);
        long l = lArray[1];
        if (l != 0L) {
            Object[] objectArray = WinRegistryAPI.RegQueryValueEx(l, this.name);
            if (objectArray != null) {
                int n = (Integer)objectArray[1];
                if (n != 1 && n != 2) {
                    throw new RegistryException(this.name + " is no longer of type REG_SZ or REG_EXPAND_SZ.");
                }
                this.typei = n;
                this.type = RegistryKey.getValueType(n);
                this.value = this.typei == 2 ? (RegistryKey.isAutoExpandEnvironmentVariables() ? RegistryKey.expandEnvironmentVariables((String)objectArray[2]) : (String)objectArray[2]) : (String)objectArray[2];
                objectArray = null;
            }
            this.key.closeKey0(lArray[0]);
        }
        lArray = null;
        return this.key.getLastError();
    }

    public String toString() {
        try {
            return super.toString() + " Value: " + this.getValue();
        }
        catch (RegistryException registryException) {
            StringBuffer stringBuffer = new StringBuffer("[");
            byte[] byArray = super.getByteData();
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(Integer.toHexString(byArray[i]));
                if (i >= byArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
            return super.toString() + " Value: " + stringBuffer.toString();
        }
    }
}

