/*
 * Decompiled with CFR 0.152.
 */
package com.registry;

import com.registry.RegBinaryValue;
import com.registry.RegDWORDValue;
import com.registry.RegMultiStringValue;
import com.registry.RegQWORDValue;
import com.registry.RegStringValue;
import com.registry.RegistryException;
import com.registry.RegistryKey;
import com.registry.RegistryValue;
import com.registry.ValueType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;

public final class RegistryExporter {
    private static final boolean IS_2000 = System.getProperty("os.version").compareTo("5.0") >= 0;

    public static boolean exportKey(File file, Format format, RegistryKey ... registryKeyArray) {
        if (format == Format.REGEDIT5 && !IS_2000) {
            throw new RegistryException((Object)((Object)format) + " is not supported on this version of Windows.");
        }
        BufferedWriter bufferedWriter = null;
        try {
            switch (format) {
                case REGEDIT4: {
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                    break;
                }
                case REGEDIT5: 
                case TEXT: {
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UnicodeLittle")));
                    break;
                }
                default: {
                    throw new RegistryException((Object)((Object)format) + " is an unrecognised format.");
                }
            }
            if (format.equals((Object)Format.REGEDIT4)) {
                bufferedWriter.write("REGEDIT4");
                bufferedWriter.newLine();
                bufferedWriter.newLine();
            } else if (format.equals((Object)Format.REGEDIT5)) {
                bufferedWriter.write("Windows Registry Editor Version 5.00");
                bufferedWriter.newLine();
                bufferedWriter.newLine();
            }
            for (int i = 0; i < registryKeyArray.length; ++i) {
                if (registryKeyArray[i].isRemoteRegistryKey()) {
                    throw new RegistryException(registryKeyArray[i] + ": remote registry keys cannot be saved.");
                }
                if (format.equals((Object)Format.TEXT)) {
                    RegistryExporter.export(file, registryKeyArray[i], bufferedWriter);
                    continue;
                }
                RegistryExporter.export(file, format, registryKeyArray[i], bufferedWriter);
            }
            bufferedWriter.close();
            return true;
        }
        catch (IOException iOException) {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return false;
        }
    }

    private static void export(File file, RegistryKey registryKey, BufferedWriter bufferedWriter) throws IOException {
        int n;
        List<Comparable<RegistryValue>> list;
        if (!registryKey.exists()) {
            return;
        }
        bufferedWriter.write("Key Name:          " + registryKey.getPath());
        bufferedWriter.newLine();
        String string = registryKey.getClassName();
        if (string == null || string.equals("")) {
            string = "<NO CLASS>";
        }
        bufferedWriter.write("Class Name:        " + string);
        bufferedWriter.newLine();
        bufferedWriter.write("Last Write Time:   " + registryKey.getSystemTime());
        bufferedWriter.newLine();
        if (registryKey.hasValues()) {
            list = registryKey.getValues();
            for (n = 0; n < list.size(); ++n) {
                byte[] byArray;
                int n2;
                byte[] byArray2;
                byte[] byArray3;
                RegistryValue registryValue = (RegistryValue)list.get(n);
                bufferedWriter.write("Value " + n);
                bufferedWriter.newLine();
                String string2 = registryValue.getName();
                if (string2.equals("")) {
                    string2 = "<NO NAME>";
                }
                bufferedWriter.write("  Name:            " + string2);
                bufferedWriter.newLine();
                ValueType valueType = registryValue.getValueType();
                if (valueType != null) {
                    bufferedWriter.write("  Type:            " + (Object)((Object)valueType));
                } else {
                    bufferedWriter.write("  Type:            0x" + Integer.toHexString(registryValue.getValueTypeInt()));
                }
                bufferedWriter.newLine();
                bufferedWriter.write("  Data:            ");
                if (valueType == null) {
                    bufferedWriter.newLine();
                    byArray3 = new byte[16];
                    byArray2 = registryValue.getByteData();
                    n2 = (byArray2.length + 15) / 16;
                    for (int i = 0; i < n2; ++i) {
                        int n3 = byArray2.length - i * 16;
                        if (n3 < 16) {
                            byArray = new byte[n3];
                            System.arraycopy(byArray2, i * 16, byArray, 0, n3);
                            byArray3 = byArray;
                        } else {
                            System.arraycopy(byArray2, i * 16, byArray3, 0, 16);
                        }
                        RegistryExporter.formatLine(i, byArray3, bufferedWriter);
                    }
                } else {
                    switch (registryValue.getValueType()) {
                        case REG_SZ: 
                        case REG_EXPAND_SZ: {
                            bufferedWriter.write(((RegStringValue)registryValue).getValue());
                            bufferedWriter.newLine();
                            break;
                        }
                        case REG_BINARY: 
                        case REG_NONE: 
                        case REG_LINK: 
                        case REG_DWORD_BIG_ENDIAN: 
                        case REG_RESOURCE_LIST: 
                        case REG_FULL_RESOURCE_DESCRIPTOR: 
                        case REG_RESOURCE_REQUIREMENTS_LIST: 
                        case REG_QWORD: 
                        case REG_QWORD_LITTLE_ENDIAN: {
                            bufferedWriter.newLine();
                            byArray3 = new byte[16];
                            byArray2 = registryValue.getByteData();
                            n2 = (byArray2.length + 15) / 16;
                            for (int i = 0; i < n2; ++i) {
                                int n4 = byArray2.length - i * 16;
                                if (n4 < 16) {
                                    byArray = new byte[n4];
                                    System.arraycopy(byArray2, i * 16, byArray, 0, n4);
                                    byArray3 = byArray;
                                } else {
                                    System.arraycopy(byArray2, i * 16, byArray3, 0, 16);
                                }
                                RegistryExporter.formatLine(i, byArray3, bufferedWriter);
                            }
                            break;
                        }
                        case REG_DWORD: 
                        case REG_DWORD_LITTLE_ENDIAN: {
                            try {
                                int n5 = ((RegDWORDValue)registryValue).getIntValue();
                                String string3 = Integer.toHexString(n5);
                                if (n5 != 0) {
                                    string3 = "0x" + string3;
                                }
                                bufferedWriter.write(string3);
                            }
                            catch (RegistryException registryException) {
                                bufferedWriter.write("0");
                            }
                            bufferedWriter.newLine();
                            break;
                        }
                        case REG_MULTI_SZ: {
                            String[] stringArray = ((RegMultiStringValue)registryValue).getValue();
                            bufferedWriter.write(stringArray[0]);
                            bufferedWriter.newLine();
                            for (int i = 1; i < stringArray.length; ++i) {
                                bufferedWriter.write("                   ");
                                bufferedWriter.write(stringArray[i]);
                                bufferedWriter.newLine();
                            }
                            break;
                        }
                    }
                }
                bufferedWriter.newLine();
            }
        }
        bufferedWriter.newLine();
        if (registryKey.hasSubKeys() && (list = registryKey.getSubKeys()) != null) {
            for (n = 0; n < list.size(); ++n) {
                RegistryExporter.export(file, (RegistryKey)list.get(n), bufferedWriter);
            }
        }
    }

    private static void formatLine(int n, byte[] byArray, BufferedWriter bufferedWriter) throws IOException {
        int n2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer(Integer.toHexString(n * 16));
        while (stringBuffer.length() < 8) {
            stringBuffer.insert(0, "0");
        }
        stringBuffer.append("   ");
        bufferedWriter.write(stringBuffer.toString());
        stringBuffer.setLength(0);
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n3 = 0; n3 < byArray.length; ++n3) {
            n2 = byArray[n3] & 0xFF;
            stringBuffer2.append(Integer.toHexString(n2));
            if (stringBuffer2.length() == 1) {
                stringBuffer2.insert(0, "0");
            }
            if (n3 == 8) {
                stringBuffer2.insert(0, "- ");
            }
            if (n2 >= 32 && n2 < 127) {
                stringBuffer.append((char)n2);
            } else if (n2 >= 160 && n2 < 256) {
                stringBuffer.append((char)n2);
            } else {
                stringBuffer.append(".");
            }
            bufferedWriter.write(stringBuffer2.append(" ").toString());
            stringBuffer2.setLength(0);
        }
        n3 = (8 - byArray.length) * 3;
        for (n2 = 1; n2 <= n3; ++n2) {
            bufferedWriter.write(" ");
        }
        if (n3 == 0 && byArray.length == 8) {
            bufferedWriter.write("- ");
        } else if (byArray.length < 8) {
            bufferedWriter.write("  ");
        }
        n3 = byArray.length >= 8 ? (16 - byArray.length) * 3 : (16 - byArray.length - n3 / 3) * 3;
        for (n2 = 1; n2 <= n3; ++n2) {
            bufferedWriter.write(" ");
        }
        stringBuffer.insert(0, " ");
        bufferedWriter.write(stringBuffer.toString());
        bufferedWriter.newLine();
    }

    private static void export(File file, Format format, RegistryKey registryKey, BufferedWriter bufferedWriter) throws IOException {
        List<RegistryKey> list;
        if (!registryKey.exists()) {
            return;
        }
        bufferedWriter.write("[" + registryKey.getPath() + "]");
        bufferedWriter.newLine();
        List<RegistryValue> list2 = null;
        if (registryKey.hasValues()) {
            list2 = registryKey.getValues();
            for (int i = 0; i < list2.size(); ++i) {
                RegistryValue registryValue = list2.get(i);
                if (registryValue.getName().equals("")) {
                    bufferedWriter.write("@=");
                } else {
                    String string = registryValue.getName();
                    if (string.contains("\\") || string.contains("\"")) {
                        StringBuffer stringBuffer = new StringBuffer(string);
                        for (int j = 0; j < stringBuffer.length(); ++j) {
                            if (stringBuffer.charAt(j) != '\\' && stringBuffer.charAt(j) != '\"') continue;
                            stringBuffer.insert(j, '\\');
                            ++j;
                        }
                        string = stringBuffer.toString();
                    }
                    bufferedWriter.write("\"" + string + "\"=");
                }
                RegistryExporter.writeValue(registryValue, format, bufferedWriter);
            }
        }
        bufferedWriter.newLine();
        if (registryKey.hasSubKeys() && (list = registryKey.getSubKeys()) != null) {
            for (int i = 0; i < list.size(); ++i) {
                RegistryExporter.export(file, format, list.get(i), bufferedWriter);
            }
        }
    }

    private static void writeValue(RegistryValue registryValue, Format format, BufferedWriter bufferedWriter) throws IOException {
        ValueType valueType = registryValue.getValueType();
        int n = 0;
        boolean bl = false;
        if (valueType == null) {
            bufferedWriter.write("hex(" + Integer.toHexString(registryValue.getValueTypeInt()) + "):");
            byte[] byArray = ((RegBinaryValue)registryValue).getValue();
            for (int i = 0; i < byArray.length; ++i) {
                if (!bl && n == 20) {
                    bufferedWriter.write("\\");
                    bufferedWriter.newLine();
                    bufferedWriter.write("  ");
                    n = 0;
                    bl = true;
                } else if (bl && n == 25) {
                    bufferedWriter.write("\\");
                    bufferedWriter.newLine();
                    bufferedWriter.write("  ");
                    n = 0;
                }
                String string = Integer.toHexString(byArray[i] & 0xFF);
                if (string.length() != 2) {
                    string = "0" + string;
                }
                bufferedWriter.write(string);
                ++n;
                if (i == byArray.length - 1) continue;
                bufferedWriter.write(",");
            }
            bufferedWriter.newLine();
        } else {
            switch (valueType) {
                case REG_SZ: {
                    String string = ((RegStringValue)registryValue).getValue();
                    if (string.contains("\\") || string.contains("\"")) {
                        StringBuffer stringBuffer = new StringBuffer(string);
                        for (int i = 0; i < stringBuffer.length(); ++i) {
                            if (stringBuffer.charAt(i) != '\\' && stringBuffer.charAt(i) != '\"') continue;
                            stringBuffer.insert(i, '\\');
                            ++i;
                        }
                        string = stringBuffer.toString();
                    }
                    bufferedWriter.write("\"" + string + "\"");
                    bufferedWriter.newLine();
                    break;
                }
                case REG_EXPAND_SZ: {
                    byte[] byArray = ((RegStringValue)registryValue).getByteData();
                    bufferedWriter.write("hex(2):");
                    for (int i = 0; i < byArray.length; ++i) {
                        if (!bl && n == 19) {
                            bufferedWriter.write("\\");
                            bufferedWriter.newLine();
                            bufferedWriter.write("  ");
                            n = 0;
                            bl = true;
                        } else if (bl && n == 25) {
                            bufferedWriter.write("\\");
                            bufferedWriter.newLine();
                            bufferedWriter.write("  ");
                            n = 0;
                        }
                        String string = Integer.toHexString(byArray[i] & 0xFF);
                        if (string.length() != 2) {
                            string = "0" + string;
                        }
                        bufferedWriter.write(string);
                        if (format.equals((Object)Format.REGEDIT4) && i != byArray.length - 2) {
                            bufferedWriter.write(",");
                        } else if (format.equals((Object)Format.REGEDIT5) && i != byArray.length - 1) {
                            bufferedWriter.write(",");
                        }
                        ++n;
                        if (!format.equals((Object)Format.REGEDIT4)) continue;
                        ++i;
                    }
                    bufferedWriter.newLine();
                    break;
                }
                case REG_BINARY: 
                case REG_NONE: 
                case REG_LINK: 
                case REG_RESOURCE_LIST: 
                case REG_FULL_RESOURCE_DESCRIPTOR: 
                case REG_RESOURCE_REQUIREMENTS_LIST: {
                    if (valueType.equals((Object)ValueType.REG_BINARY)) {
                        bufferedWriter.write("hex:");
                    } else {
                        bufferedWriter.write("hex(" + Integer.toHexString(valueType.getValue()) + "):");
                    }
                    byte[] byArray = ((RegBinaryValue)registryValue).getValue();
                    for (int i = 0; i < byArray.length; ++i) {
                        if (!bl && n == 20) {
                            bufferedWriter.write("\\");
                            bufferedWriter.newLine();
                            bufferedWriter.write("  ");
                            n = 0;
                            bl = true;
                        } else if (bl && n == 25) {
                            bufferedWriter.write("\\");
                            bufferedWriter.newLine();
                            bufferedWriter.write("  ");
                            n = 0;
                        }
                        String string = Integer.toHexString(byArray[i] & 0xFF);
                        if (string.length() != 2) {
                            string = "0" + string;
                        }
                        bufferedWriter.write(string);
                        ++n;
                        if (i == byArray.length - 1) continue;
                        bufferedWriter.write(",");
                    }
                    bufferedWriter.newLine();
                    break;
                }
                case REG_DWORD: 
                case REG_DWORD_LITTLE_ENDIAN: {
                    try {
                        int n2 = ((RegDWORDValue)registryValue).getIntValue();
                        String string = Integer.toHexString(n2);
                        bufferedWriter.write("dword:");
                        for (int i = string.length(); i < 8; ++i) {
                            bufferedWriter.write("0");
                        }
                        bufferedWriter.write(string);
                    }
                    catch (RegistryException registryException) {
                        bufferedWriter.write("hex(4):");
                        byte[] byArray = ((RegDWORDValue)registryValue).getByteData();
                        for (int i = 0; i < byArray.length; ++i) {
                            if (!bl && n == 19) {
                                bufferedWriter.write("\\");
                                bufferedWriter.newLine();
                                bufferedWriter.write("  ");
                                n = 0;
                                bl = true;
                            } else if (bl && n == 25) {
                                bufferedWriter.write("\\");
                                bufferedWriter.newLine();
                                bufferedWriter.write("  ");
                                n = 0;
                            }
                            String string = Integer.toHexString(byArray[i] & 0xFF);
                            if (string.length() != 2) {
                                string = "0" + string;
                            }
                            bufferedWriter.write(string);
                            ++n;
                            if (i == byArray.length - 1) continue;
                            bufferedWriter.write(",");
                        }
                    }
                    bufferedWriter.newLine();
                    break;
                }
                case REG_DWORD_BIG_ENDIAN: {
                    bufferedWriter.write("hex(5):");
                    byte[] byArray = ((RegDWORDValue)registryValue).getByteData();
                    for (int i = 0; i < byArray.length; ++i) {
                        if (!bl && n == 19) {
                            bufferedWriter.write("\\");
                            bufferedWriter.newLine();
                            bufferedWriter.write("  ");
                            n = 0;
                            bl = true;
                        } else if (bl && n == 25) {
                            bufferedWriter.write("\\");
                            bufferedWriter.newLine();
                            bufferedWriter.write("  ");
                            n = 0;
                        }
                        String string = Integer.toHexString(byArray[i] & 0xFF);
                        if (string.length() != 2) {
                            string = "0" + string;
                        }
                        bufferedWriter.write(string);
                        ++n;
                        if (i == byArray.length - 1) continue;
                        bufferedWriter.write(",");
                    }
                    bufferedWriter.newLine();
                    break;
                }
                case REG_MULTI_SZ: {
                    byte[] byArray = ((RegMultiStringValue)registryValue).getByteData();
                    bufferedWriter.write("hex(7):");
                    for (int i = 0; i < byArray.length; ++i) {
                        if (!bl && n == 19) {
                            bufferedWriter.write("\\");
                            bufferedWriter.newLine();
                            bufferedWriter.write("  ");
                            n = 0;
                            bl = true;
                        } else if (bl && n == 25) {
                            bufferedWriter.write("\\");
                            bufferedWriter.newLine();
                            bufferedWriter.write("  ");
                            n = 0;
                        }
                        String string = Integer.toHexString(byArray[i] & 0xFF);
                        if (string.length() != 2) {
                            string = "0" + string;
                        }
                        bufferedWriter.write(string);
                        if (format.equals((Object)Format.REGEDIT4) && i != byArray.length - 2) {
                            bufferedWriter.write(",");
                        } else if (format.equals((Object)Format.REGEDIT5) && i != byArray.length - 1) {
                            bufferedWriter.write(",");
                        }
                        ++n;
                        if (format != Format.REGEDIT4) continue;
                        ++i;
                    }
                    bufferedWriter.newLine();
                    break;
                }
                case REG_QWORD: 
                case REG_QWORD_LITTLE_ENDIAN: {
                    bufferedWriter.write("hex(b):");
                    byte[] byArray = ((RegQWORDValue)registryValue).getByteData();
                    for (int i = 0; i < byArray.length; ++i) {
                        if (!bl && n == 19) {
                            bufferedWriter.write("\\");
                            bufferedWriter.newLine();
                            bufferedWriter.write("  ");
                            n = 0;
                            bl = true;
                        } else if (bl && n == 25) {
                            bufferedWriter.write("\\");
                            bufferedWriter.newLine();
                            bufferedWriter.write("  ");
                            n = 0;
                        }
                        String string = Integer.toHexString(byArray[i] & 0xFF);
                        if (string.length() != 2) {
                            string = "0" + string;
                        }
                        bufferedWriter.write(string);
                        ++n;
                        if (i == byArray.length - 1) continue;
                        bufferedWriter.write(",");
                    }
                    bufferedWriter.newLine();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        REGEDIT5,
        REGEDIT4,
        TEXT;

    }
}

