/*
 * Decompiled with CFR 0.152.
 */
package com.registry;

import com.registry.Disposer;
import com.registry.DisposerRecord;
import com.registry.RegBinaryValue;
import com.registry.RegDWORDValue;
import com.registry.RegMultiStringValue;
import com.registry.RegQWORDValue;
import com.registry.RegStringValue;
import com.registry.RegistryException;
import com.registry.RegistryQuota;
import com.registry.RegistryValue;
import com.registry.SystemTime;
import com.registry.ValueType;
import com.registry.WinRegistryAPI;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryKey
implements Cloneable,
Comparable<RegistryKey>,
Serializable {
    static final long serialVersionUID = -4553192575773049431L;
    static final long HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    static final long HKEY_CURRENT_USER = -2147483647L;
    static final long HKEY_LOCAL_MACHINE = -2147483646L;
    static final long HKEY_USERS = -2147483645L;
    static final long HKEY_PERFORMANCE_DATA = -2147483644L;
    static final long HKEY_CURRENT_CONFIG = -2147483643L;
    static final long HKEY_DYN_DATA = -2147483642L;
    static final int REG_NONE = 0;
    static final int REG_SZ = 1;
    static final int REG_EXPAND_SZ = 2;
    static final int REG_BINARY = 3;
    static final int REG_DWORD = 4;
    static final int REG_DWORD_LITTLE_ENDIAN = 4;
    static final int REG_DWORD_BIG_ENDIAN = 5;
    static final int REG_LINK = 6;
    static final int REG_MULTI_SZ = 7;
    static final int REG_RESOURCE_LIST = 8;
    static final int REG_FULL_RESOURCE_DESCRIPTOR = 9;
    static final int REG_RESOURCE_REQUIREMENTS_LIST = 10;
    static final int REG_QWORD = 11;
    static final int REG_QWORD_LITTLE_ENDIAN = 11;
    static final int REG_FORCE_RESTORE = 8;
    static final int REG_WHOLE_HIVE_VOLATILE = 1;
    public static final int ERROR_CODE = 0;
    static final int NATIVE_HANDLE = 1;
    public static final int NUM_SUB_KEYS = 1;
    static final int REG_VALUE_TYPE = 1;
    static final int DISPOSITION = 2;
    public static final int MAX_SUB_KEY_LENGTH = 2;
    static final int REG_VALUE_DATA = 2;
    public static final int MAX_CLASS_LENGTH = 3;
    public static final int NUM_VALUES = 4;
    public static final int MAX_VALUE_NAME_LENGTH = 5;
    public static final int MAX_VALUE_LENGTH = 6;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int ERROR_INVALID_HANDLE = 6;
    public static final int ERROR_OUTOFMEMORY = 14;
    public static final int ERROR_INVALID_PARAMETER = 87;
    public static final int ERROR_PROC_NOT_FOUND = 127;
    public static final int ERROR_ALREADY_EXISTS = 183;
    public static final int ERROR_FILENAME_EXCED_RANGE = 206;
    public static final int ERROR_BADDB = 1009;
    public static final int ERROR_BADKEY = 1010;
    public static final int ERROR_CANTOPEN = 1011;
    public static final int ERROR_CANTREAD = 1012;
    public static final int ERROR_CANTWRITE = 1013;
    public static final int ERROR_REGISTRY_CORRUPT = 1015;
    public static final int ERROR_REGISTRY_IO_FAILED = 1016;
    public static final int ERROR_NOT_REGISTRY_FILE = 1017;
    public static final int ERROR_KEY_DELETED = 1018;
    public static final int ERROR_NO_LOG_SPACE = 1019;
    public static final int ERROR_KEY_HAS_CHILDREN = 1020;
    public static final int ERROR_CHILD_MUST_BE_VOLATILE = 1021;
    public static final int ERROR_NO_SYSTEM_RESOURCES = 1450;
    public static final int MAX_KEY_LENGTH = 255;
    public static final int MAX_CHARACTER_LENGTH = 16383;
    static final int DELETE = 65536;
    static final int WRITE_DAC = 262144;
    static final int KEY_ALL_ACCESS = 983103;
    static final int KEY_CREATE_LINK = 32;
    static final int KEY_CREATE_SUB_KEY = 4;
    static final int KEY_ENUMERATE_SUB_KEYS = 8;
    static final int KEY_EXECUTE = 131097;
    static final int KEY_NOTIFY = 16;
    static final int KEY_QUERY_VALUE = 1;
    static final int KEY_READ = 131097;
    static final int KEY_SET_VALUE = 2;
    static final int KEY_WOW64_32KEY = 512;
    static final int KEY_WOW64_64KEY = 256;
    static final int KEY_WRITE = 131078;
    static final int REG_OPTION_NON_VOLATILE = 0;
    static final int REG_OPTION_VOLATILE = 1;
    static final int REG_OPTION_CREATE_LINK = 2;
    static final int REG_OPTION_BACKUP_RESTORE = 4;
    static final int REG_OPTION_OPEN_LINK = 8;
    static final int REG_CREATED_NEW_KEY = 1;
    static final int REG_OPENED_EXISTING_KEY = 2;
    static final int REG_STANDARD_FORMAT = 1;
    static final int REG_LATEST_FORMAT = 2;
    static final int REG_NO_COMPRESSION = 4;
    public static final int REG_NOTIFY_CHANGE_NAME = 1;
    public static final int REG_NOTIFY_CHANGE_ATTRIBUTES = 2;
    public static final int REG_NOTIFY_CHANGE_LAST_SET = 4;
    public static final int REG_NOTIFY_CHANGE_SECURITY = 8;
    static final int SE_BACKUP_NAME = 0x403000;
    static final int SE_RESTORE_NAME = 4206614;
    static final String SE_BACKUP_NAME_STRING = "SeBackupPrivilege";
    static final String SE_RESTORE_NAME_STRING = "SeRestorePrivilege";
    public static final int DEFAULT_FILTER = 5;
    public static final int ALL_FILTERS = 15;
    static final int NULL_NATIVE_HANDLE = 0;
    public static final String DEFAULT_VALUE_NAME = "";
    public static final int HKEY_CLASSES_ROOT_INDEX = 0;
    public static final int HKEY_CURRENT_USER_INDEX = 1;
    public static final int HKEY_LOCAL_MACHINE_INDEX = 2;
    public static final int HKEY_USERS_INDEX = 3;
    public static final int HKEY_PERFORMANCE_DATA_INDEX = 4;
    public static final int HKEY_CURRENT_CONFIG_INDEX = 5;
    public static final int HKEY_DYN_DATA_INDEX = 6;
    public static final String OLD_COPY_TREE = "JRegistry.copyTree.old";
    public static final String OLD_DELETE_TREE = "JRegistry.deleteTree.old";
    static final int LIBRARY_VERSION = 0x1080000;
    private static RegistryKey[] roots;
    private static AtomicBoolean autoExpand;
    private static String computerName;
    private long hKey;
    private RegistryKey parent;
    private String name;
    private String path;
    private String absolutePath;
    private LinkedList<Long> handles;
    private boolean created;
    private int level;
    private int lastError;
    private int view64;
    private String machine;
    private transient KeyDisposer disposer = new KeyDisposer();

    private static native int initIDs();

    private static String getJarFolderName() {
        int n;
        String string = RegistryKey.class.getSimpleName() + ".class";
        URL uRL = RegistryKey.class.getResource(string);
        String string2 = uRL.toString();
        if (string2.startsWith("jar:file:/")) {
            n = "jar:file:/".length();
            int n2 = string2.indexOf("!/");
            string2 = string2.substring(n, n2);
        } else if (string2.startsWith("file:/")) {
            n = "file:/".length();
            string2 = string2.substring(n);
        }
        File file = new File(string2.replaceAll("%20", " "));
        file = file.getParentFile();
        if (file != null) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return file.getAbsolutePath();
            }
        }
        return DEFAULT_VALUE_NAME;
    }

    static void initialize() {
    }

    private RegistryKey(long l) {
        this.hKey = l;
        this.parent = null;
        this.path = DEFAULT_VALUE_NAME;
        this.handles = new LinkedList();
        this.created = false;
        this.level = 0;
        String string = System.getProperty("os.arch", "x86");
        this.view64BitRegistry(!string.equalsIgnoreCase("x86"));
        this.name = l == Integer.MIN_VALUE ? "HKEY_CLASSES_ROOT" : (l == -2147483643L ? "HKEY_CURRENT_CONFIG" : (l == -2147483647L ? "HKEY_CURRENT_USER" : (l == -2147483642L ? "HKEY_DYN_DATA" : (l == -2147483646L ? "HKEY_LOCAL_MACHINE" : (l == -2147483644L ? "HKEY_PERFORMANCE_DATA" : (l == -2147483645L ? "HKEY_USERS" : DEFAULT_VALUE_NAME))))));
        Disposer.addRecord(this, this.disposer);
    }

    private RegistryKey(long l, RegistryKey registryKey, String string, String string2) {
        this.hKey = l;
        this.parent = registryKey;
        this.path = string;
        this.name = string2;
        this.handles = new LinkedList();
        this.created = false;
        this.level = registryKey.level + 1;
        this.view64 = registryKey.view64;
        this.machine = registryKey.machine;
        Disposer.addRecord(this, this.disposer);
    }

    public RegistryKey(String string) {
        if (string == null || string == DEFAULT_VALUE_NAME || string.equals(DEFAULT_VALUE_NAME)) {
            throw new IllegalArgumentException("subKey cannot be null or have a length of zero (0).");
        }
        string = RegistryKey.toWindowsName(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\");
        int n = stringTokenizer.countTokens();
        int n2 = string.lastIndexOf(92);
        this.hKey = -2147483647L;
        this.path = "HKEY_CURRENT_USER" + (n2 != -1 ? "\\" + string.substring(0, n2) : DEFAULT_VALUE_NAME);
        this.name = string.substring(n2 + 1);
        this.handles = new LinkedList();
        this.created = false;
        this.level = n;
        String string2 = System.getProperty("os.arch", "x86");
        this.view64BitRegistry(!string2.equalsIgnoreCase("x86"));
        Disposer.addRecord(this, this.disposer);
    }

    public RegistryKey(String string, boolean bl) {
        this(string, bl, null, true);
    }

    public RegistryKey(String string, boolean bl, boolean bl2) {
        this(string, bl, null, bl2);
    }

    public RegistryKey(String string, boolean bl, String string2) {
        this(string, bl, string2, true);
    }

    public RegistryKey(String string, boolean bl, String string2, boolean bl2) {
        if (string == null || string == DEFAULT_VALUE_NAME || string.equals(DEFAULT_VALUE_NAME)) {
            throw new IllegalArgumentException("subKey cannot be null or have a length of zero (0).");
        }
        string = RegistryKey.toWindowsName(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\");
        int n = stringTokenizer.countTokens();
        int n2 = string.lastIndexOf(92);
        if (bl) {
            int n3 = bl2 ? 0 : 1;
            long[] lArray = WinRegistryAPI.RegCreateKeyEx(-2147483647L, string, n3, 4, string2);
            if (lArray[0] != 0L) {
                throw new RegistryException("Registry key could not be created.");
            }
            this.created = lArray[2] == 1L;
            lArray = null;
        }
        this.hKey = -2147483647L;
        this.path = "HKEY_CURRENT_USER" + (n2 != -1 ? "\\" + string.substring(0, n2) : DEFAULT_VALUE_NAME);
        this.name = string.substring(n2 + 1);
        this.handles = new LinkedList();
        this.level = n;
        String string3 = System.getProperty("os.arch", "x86");
        this.view64BitRegistry(!string3.equalsIgnoreCase("x86"));
        Disposer.addRecord(this, this.disposer);
    }

    public RegistryKey(RegistryKey registryKey, String string) {
        if (registryKey == null) {
            throw new IllegalArgumentException("root cannot be null.");
        }
        if (string == null || string == DEFAULT_VALUE_NAME || string.equals(DEFAULT_VALUE_NAME)) {
            throw new IllegalArgumentException("subKey cannot be null or have a length of zero (0).");
        }
        string = RegistryKey.toWindowsName(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\");
        int n = registryKey.level + stringTokenizer.countTokens();
        int n2 = string.lastIndexOf(92);
        this.hKey = registryKey.hKey;
        this.path = registryKey.getPath() + (n2 != -1 ? "\\" + string.substring(0, n2) : DEFAULT_VALUE_NAME);
        this.name = string.substring(n2 + 1);
        this.handles = new LinkedList();
        this.created = false;
        this.level = registryKey.level + n;
        String string2 = System.getProperty("os.arch", "x86");
        this.view64BitRegistry(!string2.equalsIgnoreCase("x86"));
        Disposer.addRecord(this, this.disposer);
    }

    public RegistryKey(RegistryKey registryKey, String string, boolean bl) {
        this(registryKey, string, bl, null, true);
    }

    public RegistryKey(RegistryKey registryKey, String string, boolean bl, boolean bl2) {
        this(registryKey, string, bl, null, bl2);
    }

    public RegistryKey(RegistryKey registryKey, String string, boolean bl, String string2) {
        this(registryKey, string, bl, string2, true);
    }

    public RegistryKey(RegistryKey registryKey, String string, boolean bl, String string2, boolean bl2) {
        if (registryKey == null) {
            throw new IllegalArgumentException("root cannot be null.");
        }
        if (string == null || string == DEFAULT_VALUE_NAME || string.equals(DEFAULT_VALUE_NAME)) {
            throw new IllegalArgumentException("subKey cannot be null or have a length of zero (0).");
        }
        string = RegistryKey.toWindowsName(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\");
        int n = registryKey.level + stringTokenizer.countTokens();
        int n2 = string.lastIndexOf(92);
        if (bl) {
            int n3 = bl2 ? 0 : 1;
            long[] lArray = WinRegistryAPI.RegCreateKeyEx(registryKey.hKey, string, n3, 4, string2);
            if (lArray[0] != 0L) {
                throw new RegistryException("Registry key could not be created.");
            }
            this.created = lArray[2] == 1L;
            lArray = null;
        }
        this.hKey = registryKey.hKey;
        this.path = registryKey.getPath() + (n2 != -1 ? "\\" + string.substring(0, n2) : DEFAULT_VALUE_NAME);
        this.name = string.substring(n2 + 1);
        this.handles = new LinkedList();
        this.level = n;
        String string3 = System.getProperty("os.arch", "x86");
        this.view64BitRegistry(!string3.equalsIgnoreCase("x86"));
        Disposer.addRecord(this, this.disposer);
    }

    public static synchronized void autoExpandEnvironmentVariables(boolean bl) {
        autoExpand.set(bl);
    }

    public static RegistryKey connect(String string, RegistryKey registryKey) {
        if (registryKey == null) {
            throw new IllegalArgumentException("root cannot be null.");
        }
        if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME) || string.equalsIgnoreCase(computerName)) {
            RegistryKey registryKey2 = new RegistryKey(registryKey.hKey);
            registryKey2.machine = null;
            return registryKey2;
        }
        if (registryKey.equals(roots[2]) || registryKey.equals(roots[3]) || registryKey.equals(roots[4])) {
            RegistryKey registryKey3 = new RegistryKey(registryKey.hKey);
            registryKey3.machine = string.toUpperCase();
            return registryKey3;
        }
        throw new RegistryException("Can only connect to HKEY_LOCAL_MACHINE, HKEY_PERFORMANCE_DATA, or HKEY_USERS.");
    }

    private static native String getComputerName();

    public static int deleteKeys(RegistryKey ... registryKeyArray) {
        if (registryKeyArray == null) {
            return 87;
        }
        int n = 0;
        for (int i = 0; i < registryKeyArray.length; ++i) {
            n = registryKeyArray[i].deleteKey();
            if (n == 0) continue;
            return n;
        }
        return n;
    }

    public static int deleteLinks(RegistryKey ... registryKeyArray) {
        if (registryKeyArray == null) {
            return 87;
        }
        int n = 0;
        for (int i = 0; i < registryKeyArray.length; ++i) {
            n = registryKeyArray[i].deleteLink();
            if (n == 0) continue;
            return n;
        }
        return n;
    }

    public static String expandEnvironmentVariables(String string) {
        return WinRegistryAPI.ExpandEnvironmentStrings(string);
    }

    public static native String formatErrorMessage(int var0);

    public static RegistryQuota getRegistryQuota() {
        return WinRegistryAPI.GetSystemRegistryQuota();
    }

    public static RegistryKey getRootKeyForIndex(int n) {
        return roots[n];
    }

    public static synchronized boolean isAutoExpandEnvironmentVariables() {
        return autoExpand.get();
    }

    public static synchronized RegistryKey[] listRoots() {
        RegistryKey[] registryKeyArray = Arrays.copyOf(roots, roots.length);
        return registryKeyArray;
    }

    public static RegistryKey parseKey(String string) {
        return RegistryKey.parseKey(string, false, false);
    }

    public static RegistryKey parseKey(String string, boolean bl) {
        return RegistryKey.parseKey(string, bl, true);
    }

    public static RegistryKey parseKey(String string, boolean bl, boolean bl2) {
        Object object;
        String string2;
        Object object2;
        int n = (string = RegistryKey.toWindowsName(string)).indexOf(92);
        if (n == -1) {
            if (string.equals("HKEY_CLASSES_ROOT") || string.equals("HKCR")) {
                return roots[0];
            }
            if (string.equals("HKEY_CURRENT_USER") || string.equals("HKCU")) {
                return roots[1];
            }
            if (string.equals("HKEY_LOCAL_MACHINE") || string.equals("HKLM")) {
                return roots[2];
            }
            if (string.equals("HKEY_USERS") || string.equals("HKU") || string.equals("HKUS")) {
                return roots[3];
            }
            if (string.equals("HKEY_PERFORMANCE_DATA") || string.equals("HKPD")) {
                return roots[4];
            }
            if (string.equals("HKEY_CURRENT_CONFIG") || string.equals("HKCC")) {
                return roots[5];
            }
            if (string.equals("HKEY_DYN_DATA") || string.equals("HKDD")) {
                return roots[6];
            }
            return null;
        }
        String string3 = string.substring(0, n);
        String string4 = n == string.length() - 1 ? DEFAULT_VALUE_NAME : string.substring(n + 1);
        RegistryKey registryKey = null;
        if (string3.equals("HKEY_CLASSES_ROOT") || string3.equals("HKCR")) {
            registryKey = roots[0];
        } else if (string3.equals("HKEY_CURRENT_USER") || string3.equals("HKCU")) {
            registryKey = roots[1];
        } else if (string3.equals("HKEY_LOCAL_MACHINE") || string3.equals("HKLM")) {
            registryKey = roots[2];
        } else if (string3.equals("HKEY_USERS") || string3.equals("HKU") || string3.equals("HKUS")) {
            registryKey = roots[3];
        } else if (string.equals("HKEY_PERFORMANCE_DATA") || string3.equals("HKPD")) {
            registryKey = roots[4];
        } else if (string.equals("HKEY_CURRENT_CONFIG") || string3.equals("HKCC")) {
            registryKey = roots[5];
        } else if (string.equals("HKEY_DYN_DATA") || string3.equals("HKDD")) {
            registryKey = roots[6];
        } else if (string3.equals("Registry")) {
            int n2;
            object2 = "Machine";
            string2 = "User";
            object = "Software\\Classes";
            String string5 = RegistryKey.getCurrentUserSid();
            String string6 = "System\\CurrentControlSet\\Hardware Profiles\\Current";
            int n3 = string4.length();
            if (string4.regionMatches(true, 0, (String)object2, 0, ((String)object2).length())) {
                if (string4.regionMatches(true, ((String)object2).length() + 1, (String)object, 0, ((String)object).length())) {
                    n2 = ((String)object2).length() + ((String)object).length() + 2;
                    string4 = n2 >= n3 ? DEFAULT_VALUE_NAME : string4.substring(n2);
                    registryKey = roots[0];
                } else if (string4.regionMatches(true, ((String)object2).length() + 1, string6, 0, string6.length())) {
                    n2 = ((String)object2).length() + string6.length() + 2;
                    string4 = n2 >= n3 ? DEFAULT_VALUE_NAME : string4.substring(n2);
                    registryKey = roots[5];
                } else {
                    n2 = ((String)object2).length() + 1;
                    string4 = n2 >= n3 ? DEFAULT_VALUE_NAME : string4.substring(n2);
                    registryKey = roots[2];
                }
            } else if (string4.regionMatches(true, 0, string2, 0, string2.length())) {
                if (string4.regionMatches(true, string2.length() + 1, string5, 0, string5.length())) {
                    n2 = string2.length() + string5.length() + 2;
                    string4 = n2 >= n3 ? DEFAULT_VALUE_NAME : string4.substring(n2);
                    registryKey = roots[1];
                } else {
                    n2 = string2.length() + 1;
                    string4 = n2 >= n3 ? DEFAULT_VALUE_NAME : string4.substring(n2);
                    registryKey = roots[3];
                }
            } else {
                registryKey = null;
            }
        } else {
            registryKey = null;
        }
        if (!bl) {
            if (registryKey != null) {
                if (string4.contains("\\")) {
                    object2 = new StringTokenizer(string4, "\\");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        string2 = ((StringTokenizer)object2).nextToken();
                        if (string2.length() != 0 && registryKey.keyExists(string2)) {
                            registryKey = new RegistryKey(registryKey.hKey, registryKey, registryKey.getPath(), string2);
                            continue;
                        }
                        if (string2.length() != 0 && registryKey.keyIsLink(string2)) {
                            registryKey = new RegistryKey(registryKey.hKey, registryKey, registryKey.getPath(), string2);
                            return registryKey;
                        }
                        if (string2.length() != 0 && (registryKey.keyExists(string2) || registryKey.keyIsLink(string2))) continue;
                        return null;
                    }
                    return registryKey;
                }
                if (string4.length() != 0 && registryKey.keyExists(string4)) {
                    return new RegistryKey(registryKey.hKey, registryKey, registryKey.getPath(), string4);
                }
                if (string4.length() != 0 && registryKey.keyIsLink(string4)) {
                    return new RegistryKey(registryKey.hKey, registryKey, registryKey.getPath(), string4);
                }
                if (string4.length() == 0) {
                    return registryKey;
                }
                return null;
            }
        } else if (registryKey != null) {
            object2 = new StringTokenizer(string4, "\\");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                string2 = ((StringTokenizer)object2).nextToken();
                object = null;
                object = registryKey.keyIsLink(string2) ? registryKey.createSubKeyLink(string2, null, bl2) : registryKey.createSubKey(string2, bl2);
                if (object != null) {
                    registryKey = object;
                    continue;
                }
                registryKey = null;
                break;
            }
            return registryKey;
        }
        return null;
    }

    private String absolutePath() {
        if (this.absolutePath == null) {
            int n = this.getPath().indexOf("\\");
            if (n == -1) {
                this.absolutePath = DEFAULT_VALUE_NAME;
                return this.absolutePath;
            }
            String string = this.getPath().substring(n + 1);
            this.absolutePath = string == null || DEFAULT_VALUE_NAME.equals(string) ? this.name : string;
        }
        return this.absolutePath;
    }

    public boolean canDelete() {
        boolean bl = false;
        long[] lArray = this.openKey0(65536, this.handles);
        long l = lArray[1];
        if (l != 0L && !this.isRootHandle(l)) {
            bl = !this.hasSubKeys();
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return bl;
    }

    public boolean canDeleteLink() {
        boolean bl = false;
        long[] lArray = this.openLinkKey(65536, this.handles);
        long l = lArray[1];
        if (l != 0L && !this.isRootHandle(l)) {
            bl = true;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return bl;
    }

    public boolean canDeleteTree() {
        boolean bl = System.getProperty(OLD_DELETE_TREE, "false").equalsIgnoreCase("true");
        int n = bl ? 65536 : 65547;
        boolean bl2 = false;
        long[] lArray = this.openKey0(n, this.handles);
        long l = lArray[1];
        if (l != 0L && !this.isRootHandle(l)) {
            bl2 = true;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return bl2;
    }

    public boolean canLoadKey() {
        long l = this.openKey(131097);
        if (l != 0L) {
            this.closeKey(l);
            return l == -2147483646L || l == -2147483645L;
        }
        return false;
    }

    public boolean canRename() {
        boolean bl = false;
        long[] lArray = this.openKey0(131078, this.handles);
        long l = lArray[1];
        if (l != 0L && !this.isRootHandle(l)) {
            bl = true;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return bl;
    }

    public boolean canUnLoadKey() {
        long l = this.openKey(131097);
        if (l != 0L) {
            this.closeKey(l);
            return !(this.hKey != -2147483646L && this.hKey != -2147483645L || this.getParent() == null || !this.getParent().equals(roots[2]) && !this.getParent().equals(roots[3]));
        }
        return false;
    }

    public boolean canWrite() {
        boolean bl = false;
        long[] lArray = this.openKey0(2, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            bl = true;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return bl;
    }

    public Object clone() {
        try {
            RegistryKey registryKey = (RegistryKey)super.clone();
            registryKey.hKey = this.hKey;
            registryKey.parent = this.parent;
            registryKey.name = this.name;
            registryKey.path = this.path;
            registryKey.absolutePath = this.absolutePath;
            registryKey.handles = new LinkedList();
            registryKey.created = this.created;
            registryKey.level = this.level;
            registryKey.lastError = this.lastError;
            registryKey.view64 = this.view64;
            return registryKey;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    int closeKey(long l) {
        return WinRegistryAPI.RegCloseKey(l);
    }

    int closeKey0(long l) {
        return this.closeKey0(this.handles, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int closeKey0(List<Long> list, long l) {
        int n = 0;
        if (list != null) {
            List<Long> list2 = list;
            synchronized (list2) {
                int n2 = (int)(l + (long)(this.getLevel() / 32 + 1) + 1L);
                if (n2 > list.size()) {
                    int n3 = n2 - list.size();
                    n2 -= n3;
                    l -= (long)n3;
                }
                ListIterator<Long> listIterator = list.listIterator(n2);
                while (listIterator.hasPrevious()) {
                    Long l2 = listIterator.previous();
                    n |= this.closeKey(l2);
                    listIterator.remove();
                    if (listIterator.previousIndex() != (int)l) continue;
                    break;
                }
            }
        }
        return n;
    }

    @Override
    public int compareTo(RegistryKey registryKey) {
        return registryKey == null ? 1 : (this.hKey != registryKey.hKey ? (int)(this.hKey - registryKey.hKey) : this.getPath().compareToIgnoreCase(registryKey.getPath()));
    }

    @Deprecated
    public void copy(RegistryKey registryKey) {
        List<RegistryKey> list = this.getSubKeys();
        int n = list == null ? 0 : list.size();
        for (int i = 0; i < n; ++i) {
            RegistryKey registryKey2 = list.get(i);
            RegistryKey registryKey3 = registryKey.createSubKey(registryKey2.getName());
            registryKey2.copy(registryKey3);
        }
        List<RegistryValue> list2 = this.getValues();
        int n2 = list2 == null ? 0 : list2.size();
        for (int i = 0; i < n2; ++i) {
            RegistryValue registryValue = list2.get(i);
            String string = registryValue.getName();
            ValueType valueType = registryValue.getValueType();
            byte[] byArray = registryValue.getByteData();
            if (valueType == null) {
                registryValue = new RegBinaryValue(registryKey, string, registryValue.getValueTypeInt(), null);
                registryValue.setByteData(byArray);
            } else {
                switch (valueType) {
                    case REG_SZ: 
                    case REG_EXPAND_SZ: {
                        registryValue = new RegStringValue(registryKey, string, valueType, null);
                        registryValue.setByteData(byArray);
                        break;
                    }
                    case REG_BINARY: 
                    case REG_NONE: 
                    case REG_LINK: {
                        registryValue = new RegBinaryValue(registryKey, string, valueType, null);
                        registryValue.setByteData(byArray);
                        break;
                    }
                    case REG_DWORD: 
                    case REG_DWORD_LITTLE_ENDIAN: 
                    case REG_DWORD_BIG_ENDIAN: {
                        registryValue = new RegDWORDValue(registryKey, string, valueType, null);
                        registryValue.setByteData(byArray);
                        break;
                    }
                    case REG_MULTI_SZ: {
                        registryValue = new RegMultiStringValue(registryKey, string, valueType, null);
                        registryValue.setByteData(byArray);
                        break;
                    }
                    case REG_QWORD: 
                    case REG_QWORD_LITTLE_ENDIAN: {
                        registryValue = new RegQWORDValue(registryKey, string, valueType, null);
                        registryValue.setByteData(byArray);
                    }
                }
            }
            byArray = null;
        }
    }

    public int copyTree(RegistryKey registryKey) {
        return this.copyTree(registryKey, false);
    }

    public int copyTree(RegistryKey registryKey, boolean bl) {
        boolean bl2 = System.getProperty(OLD_COPY_TREE, "false").equalsIgnoreCase("true");
        if (bl2) {
            this.lastError = this.copyTree0(this, registryKey, 0, bl2, bl);
            return this.lastError;
        }
        if (!registryKey.exists()) {
            registryKey.create();
            if (registryKey.getLastError() == 1021) {
                registryKey.create(false);
            }
        }
        long[] lArray = this.openKey0(131097, this.handles);
        long[] lArray2 = registryKey.openKey0(262149, registryKey.handles);
        long l = lArray[1];
        long l2 = lArray2[1];
        if (l != 0L && l2 != 0L) {
            int n = 0;
            n = bl ? this.copyTree0(this, registryKey, 0, bl2, bl) : WinRegistryAPI.RegCopyTree(l, null, l2);
            this.closeKey0(this.handles, lArray[0]);
            registryKey.closeKey0(registryKey.handles, lArray2[0]);
            this.lastError = n;
            lArray = null;
            lArray2 = null;
            if (n == 127) {
                this.lastError = this.copyTree0(this, registryKey, 0, bl2, bl);
                return this.lastError;
            }
            return n;
        }
        this.closeKey0(this.handles, lArray[0]);
        registryKey.closeKey0(registryKey.handles, lArray2[0]);
        lArray2 = null;
        lArray = null;
        return this.lastError;
    }

    public int copySubTree(String string, RegistryKey registryKey) {
        return this.copySubTree(string, registryKey, false);
    }

    public int copySubTree(String string, RegistryKey registryKey, boolean bl) {
        if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
            this.lastError = 87;
            return this.lastError;
        }
        if (!registryKey.exists()) {
            registryKey.create();
            if (registryKey.getLastError() == 1021) {
                registryKey.create(false);
            }
        }
        long[] lArray = this.openKey0(131097, this.handles);
        long[] lArray2 = registryKey.openKey0(262149, registryKey.handles);
        long l = lArray[1];
        long l2 = lArray2[1];
        if (l != 0L && l2 != 0L) {
            RegistryKey registryKey2;
            int n = 0;
            if (bl) {
                registryKey2 = this.getSubKey(string);
                if (registryKey2 != null) {
                    n = registryKey2.copyTree0(registryKey2, registryKey, 0, false, bl);
                }
                n = this.lastError;
            } else {
                n = WinRegistryAPI.RegCopyTree(l, RegistryKey.toWindowsName(string), l2);
            }
            this.closeKey0(this.handles, lArray[0]);
            registryKey.closeKey0(registryKey.handles, lArray2[0]);
            this.lastError = n;
            lArray = null;
            lArray2 = null;
            if (n == 127) {
                registryKey2 = this.getSubKey(string);
                if (registryKey2 != null) {
                    this.lastError = registryKey2.copyTree0(registryKey2, registryKey, 0, false, bl);
                    return this.lastError;
                }
                n = this.lastError;
            }
            return n;
        }
        this.closeKey0(this.handles, lArray[0]);
        registryKey.closeKey0(registryKey.handles, lArray2[0]);
        lArray2 = null;
        lArray = null;
        return this.lastError;
    }

    private int copyTree0(RegistryKey registryKey, RegistryKey registryKey2, int n, boolean bl, boolean bl2) {
        long l;
        List<RegistryValue> list;
        if (n != 0) {
            return n;
        }
        boolean bl3 = false;
        if (!bl && bl2) {
            bl3 = registryKey.isLinkKey();
            list = registryKey.getLinkLocation();
            if (list != null) {
                long[] lArray = registryKey2.openLinkKey(2, registryKey2.handles);
                l = lArray[1];
                n = l != 0L ? WinRegistryAPI.RegSetLinkValue(l, "SymbolicLinkValue", ((RegistryKey)((Object)list)).toNativePath()) : registryKey2.getLastError();
                registryKey2.closeKey0(registryKey2.handles, lArray[0]);
                lArray = null;
            }
        }
        if (!bl3) {
            Object object;
            list = registryKey.getValues();
            int n2 = list == null ? 0 : list.size();
            for (int i = 0; i < n2; ++i) {
                RegistryValue registryValue = (RegistryValue)list.get(i);
                String string = registryValue.getName();
                object = registryValue.getByteData();
                registryValue = new RegBinaryValue(registryKey2, string, registryValue.getValueTypeInt(), null);
                n = registryValue.setByteData((byte[])object);
                object = null;
                string = null;
                if (n == 0) continue;
                return n;
            }
            List<RegistryKey> list2 = registryKey.getSubKeys();
            int n3 = list2 == null ? 0 : list2.size();
            for (int i = 0; i < n3; ++i) {
                RegistryKey registryKey3;
                object = list2.get(i);
                if (!bl) {
                    if (!bl2) {
                        if (((RegistryKey)object).isLinkKey()) {
                            return 87;
                        }
                    } else if (((RegistryKey)object).isLinkKey()) {
                        registryKey3 = ((RegistryKey)object).getLinkLocation();
                        RegistryKey registryKey4 = registryKey2.createSubKeyLink(((RegistryKey)object).getName(), registryKey3);
                        if (registryKey4 == null && registryKey2.getLastError() == 183) {
                            registryKey4 = registryKey2.createSubKeyLink(((RegistryKey)object).getName(), registryKey3, false);
                        } else if (registryKey4 == null) {
                            return registryKey2.getLastError();
                        }
                        long[] lArray = super.openLinkKey(131097, ((RegistryKey)object).handles);
                        long[] lArray2 = registryKey4.openLinkKey(262144, registryKey4.handles);
                        long l2 = lArray[1];
                        long l3 = lArray2[1];
                        if (l2 != 0L && l3 != 0L) {
                            n = this.RegGetSetKeySecurity(l2, l3);
                        }
                        ((RegistryKey)object).closeKey0(((RegistryKey)object).handles, lArray[0]);
                        registryKey4.closeKey0(registryKey4.handles, lArray2[0]);
                        lArray2 = null;
                        lArray = null;
                        if (n == 0) continue;
                        return n;
                    }
                }
                if ((registryKey3 = registryKey2.createSubKey(((RegistryKey)object).getName())) == null && registryKey2.getLastError() == 1021) {
                    registryKey3 = registryKey2.createSubKey(((RegistryKey)object).getName(), false);
                } else if (registryKey3 == null) {
                    return registryKey2.getLastError();
                }
                n = this.copyTree0((RegistryKey)object, registryKey3, n, bl, bl2);
                if (n == 0) continue;
                return n;
            }
        }
        if (!bl) {
            list = (List<RegistryValue>)(!bl3 ? registryKey.openKey0(131097, registryKey.handles) : registryKey.openLinkKey(131097, registryKey.handles));
            long[] lArray = registryKey2.openKey0(262144, registryKey2.handles);
            l = (long)list[1];
            long l4 = lArray[1];
            if (l != 0L && l4 != 0L) {
                n = this.RegGetSetKeySecurity(l, l4);
            }
            registryKey.closeKey0(registryKey.handles, (long)list[0]);
            registryKey2.closeKey0(registryKey2.handles, lArray[0]);
            lArray = null;
            list = null;
            if (n != 0) {
                return n;
            }
        }
        return n;
    }

    private native int RegGetSetKeySecurity(long var1, long var3);

    public int copyValue(RegistryKey registryKey, RegistryValue registryValue) {
        if (registryValue == null) {
            this.lastError = 87;
            return 87;
        }
        String string = registryValue.getName();
        byte[] byArray = registryValue.getByteData();
        registryValue = new RegBinaryValue(registryKey, string, registryValue.getValueTypeInt(), null);
        this.lastError = registryValue.setByteData(byArray);
        byArray = null;
        string = null;
        return this.lastError;
    }

    public int copyValues(RegistryKey registryKey, String ... stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                RegistryValue registryValue = this.getValue(stringArray[i]);
                if (registryValue == null) {
                    return this.lastError;
                }
                this.lastError = this.copyValue(registryKey, registryValue);
                if (this.lastError == 0) continue;
                return this.lastError;
            }
        }
        this.lastError = 0;
        return 0;
    }

    public int copyValues(RegistryKey registryKey, RegistryValue ... registryValueArray) {
        if (registryValueArray != null) {
            for (int i = 0; i < registryValueArray.length; ++i) {
                this.lastError = this.copyValue(registryKey, registryValueArray[i]);
                if (this.lastError == 0) continue;
                return this.lastError;
            }
        }
        this.lastError = 0;
        return 0;
    }

    public int copySubKeyValue(String string, RegistryKey registryKey, RegistryValue registryValue) {
        RegistryKey registryKey2 = this.getSubKey(string);
        if (registryKey2 == null) {
            this.lastError = 87;
            return 87;
        }
        this.lastError = registryKey2.copyValue(registryKey, registryValue);
        return this.lastError;
    }

    public int copySubKeyValues(String string, RegistryKey registryKey, String ... stringArray) {
        RegistryKey registryKey2 = this.getSubKey(string);
        if (registryKey2 == null) {
            this.lastError = 87;
            return 87;
        }
        this.lastError = registryKey2.copyValues(registryKey, stringArray);
        return this.lastError;
    }

    public int copySubKeyValues(String string, RegistryKey registryKey, RegistryValue ... registryValueArray) {
        RegistryKey registryKey2 = this.getSubKey(string);
        if (registryKey2 == null) {
            this.lastError = 87;
            return 87;
        }
        this.lastError = registryKey2.copyValues(registryKey, registryValueArray);
        return this.lastError;
    }

    public int create() {
        return this.create(null, true);
    }

    public int create(boolean bl) {
        return this.create(null, bl);
    }

    public int create(String string) {
        return this.create(string, true);
    }

    public int create(String string, boolean bl) {
        int n;
        long[] lArray;
        String string2 = this.absolutePath();
        if (string2.charAt(0) == '\\') {
            string2 = string2.substring(1);
        }
        if (string2.charAt(string2.length() - 1) == '\\') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((lArray = WinRegistryAPI.RegCreateKeyEx(this.hKey, string2, n = bl ? 0 : 1, 4 | this.view64, string)) != null && lArray[0] == 0L) {
            if (lArray[2] == 1L) {
                this.created = true;
            }
            this.closeKey(lArray[1]);
        }
        this.lastError = lArray == null ? 14 : (int)lArray[0];
        lArray = null;
        return this.lastError;
    }

    public boolean created() {
        return this.created;
    }

    public int createLink(RegistryKey registryKey) {
        return this.createLink(registryKey, null, true);
    }

    public int createLink(RegistryKey registryKey, boolean bl) {
        return this.createLink(registryKey, null, bl);
    }

    public int createLink(RegistryKey registryKey, String string) {
        return this.createLink(registryKey, string, true);
    }

    public int createLink(RegistryKey registryKey, String string, boolean bl) {
        int n;
        long[] lArray;
        String string2 = this.absolutePath();
        if (string2.charAt(0) == '\\') {
            string2 = string2.substring(1);
        }
        if (string2.charAt(string2.length() - 1) == '\\') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((lArray = WinRegistryAPI.RegCreateKeyEx(this.hKey, string2, n = (bl ? 0 : 1) | 2, 0x24 | this.view64, string)) != null && (lArray[0] == 0L || lArray[0] == 183L)) {
            if (lArray[2] == 1L) {
                this.created = true;
            }
            this.closeKey(lArray[1]);
            this.setLinkTo(registryKey);
        }
        this.lastError = lArray == null ? 14 : (int)lArray[0];
        lArray = null;
        return this.lastError;
    }

    public RegistryKey createSubKey(String string) {
        return this.createSubKey(string, null, true);
    }

    public RegistryKey createSubKey(String string, boolean bl) {
        return this.createSubKey(string, null, bl);
    }

    public RegistryKey createSubKey(String string, String string2) {
        return this.createSubKey(string, string2, true);
    }

    public RegistryKey createSubKey(String string, String string2, boolean bl) {
        if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
            this.lastError = 87;
            return null;
        }
        String string3 = this.absolutePath() + "\\" + RegistryKey.toWindowsName(string);
        if (string3.charAt(0) == '\\') {
            string3 = string3.substring(1);
        }
        if (string3.charAt(string3.length() - 1) == '\\') {
            string3 = string3.substring(0, string3.length() - 1);
        }
        int n = bl ? 0 : 1;
        long[] lArray = WinRegistryAPI.RegCreateKeyEx(this.hKey, string3, n, 4 | this.view64, string2);
        RegistryKey registryKey = null;
        if (lArray != null && lArray[0] == 0L) {
            registryKey = new RegistryKey(this.hKey, this, this.getPath(), string);
            if (lArray[2] == 1L) {
                registryKey.created = true;
            }
            this.closeKey(lArray[1]);
        }
        this.lastError = lArray == null ? 14 : (int)lArray[0];
        lArray = null;
        return registryKey;
    }

    public RegistryKey createSubKeyLink(String string, RegistryKey registryKey) {
        return this.createSubKeyLink(string, registryKey, null, true);
    }

    public RegistryKey createSubKeyLink(String string, RegistryKey registryKey, boolean bl) {
        return this.createSubKeyLink(string, registryKey, null, bl);
    }

    public RegistryKey createSubKeyLink(String string, RegistryKey registryKey, String string2) {
        return this.createSubKeyLink(string, registryKey, string2, true);
    }

    public RegistryKey createSubKeyLink(String string, RegistryKey registryKey, String string2, boolean bl) {
        if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
            this.lastError = 87;
            return null;
        }
        String string3 = this.absolutePath() + "\\" + RegistryKey.toWindowsName(string);
        if (string3.charAt(0) == '\\') {
            string3 = string3.substring(1);
        }
        if (string3.charAt(string3.length() - 1) == '\\') {
            string3 = string3.substring(0, string3.length() - 1);
        }
        int n = (bl ? 0 : 1) | 2;
        long[] lArray = WinRegistryAPI.RegCreateKeyEx(this.hKey, string3, n, 0x24 | this.view64, string2);
        RegistryKey registryKey2 = null;
        if (lArray != null && (lArray[0] == 0L || lArray[0] == 183L)) {
            registryKey2 = new RegistryKey(this.hKey, this, this.getPath(), string);
            if (lArray[2] == 1L) {
                registryKey2.created = true;
            }
            this.closeKey(lArray[1]);
            registryKey2.setLinkTo(registryKey);
        }
        this.lastError = lArray == null ? 14 : (int)lArray[0];
        lArray = null;
        return registryKey2;
    }

    public int deleteKey() {
        RegistryKey registryKey = this.getParent();
        if (registryKey == null) {
            return 5;
        }
        long[] lArray = registryKey.openKey0(65536, registryKey.handles);
        long l = lArray[1];
        if (l != 0L) {
            int n = WinRegistryAPI.RegDeleteKey(l, this.name);
            registryKey.closeKey0(registryKey.handles, lArray[0]);
            this.lastError = n;
            lArray = null;
            return n;
        }
        registryKey.closeKey0(registryKey.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int deleteLink() {
        if (!this.isLinkKey()) {
            return this.lastError;
        }
        long[] lArray = this.openLinkKey(65538, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            int n = WinRegistryAPI.RegDeleteLink(l);
            this.closeKey0(this.handles, lArray[0]);
            this.lastError = n;
            lArray = null;
            return n;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int deleteSubKey(String string) {
        if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
            this.lastError = 87;
            return this.lastError;
        }
        long[] lArray = this.openKey0(65536, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            int n = WinRegistryAPI.RegDeleteKey(l, RegistryKey.toWindowsName(string));
            this.closeKey0(this.handles, lArray[0]);
            this.lastError = n;
            lArray = null;
            return n;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int deleteSubKeys(String ... stringArray) {
        if (stringArray == null) {
            this.lastError = 87;
            return 87;
        }
        long[] lArray = this.openKey0(65536, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
                    this.lastError = 87;
                    this.closeKey0(this.handles, lArray[i]);
                    lArray = null;
                    return this.lastError;
                }
                this.lastError = WinRegistryAPI.RegDeleteKey(l, RegistryKey.toWindowsName(string));
                if (this.lastError == 0) continue;
                this.closeKey0(this.handles, lArray[i]);
                lArray = null;
                return this.lastError;
            }
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int deleteView64Key(String string) {
        if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
            this.lastError = 87;
            return this.lastError;
        }
        long[] lArray = this.openKey0(65536, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            int n = WinRegistryAPI.RegDeleteKeyEx(l, RegistryKey.toWindowsName(string), this.view64);
            this.closeKey0(this.handles, lArray[0]);
            this.lastError = n;
            lArray = null;
            return n;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int deleteView64Keys(String ... stringArray) {
        if (stringArray == null) {
            this.lastError = 87;
            return 87;
        }
        long[] lArray = this.openKey0(65536, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
                    this.lastError = 87;
                    this.closeKey0(this.handles, lArray[i]);
                    lArray = null;
                    return this.lastError;
                }
                this.lastError = WinRegistryAPI.RegDeleteKeyEx(l, RegistryKey.toWindowsName(string), this.view64);
                if (this.lastError == 0) continue;
                this.closeKey0(this.handles, lArray[i]);
                lArray = null;
                return this.lastError;
            }
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int deleteTree() {
        return this.deleteTree(false);
    }

    public int deleteTree(boolean bl) {
        boolean bl2 = System.getProperty(OLD_DELETE_TREE, "false").equalsIgnoreCase("true");
        if (bl2) {
            return this.deleteTree0(bl2, bl);
        }
        long[] lArray = this.openKey0(65547, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            int n = 0;
            if (bl) {
                n = this.deleteTree0(bl2, bl);
                this.closeKey0(this.handles, lArray[0]);
            } else {
                n = WinRegistryAPI.RegDeleteTree(l, null);
                this.closeKey0(this.handles, lArray[0]);
            }
            this.lastError = n;
            lArray = null;
            if (n == 127) {
                return this.deleteTree0(bl2, bl);
            }
            return n;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int deleteSubTree(String string) {
        return this.deleteSubTree(string, false);
    }

    public int deleteSubTree(String string, boolean bl) {
        if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
            this.lastError = 87;
            return this.lastError;
        }
        long[] lArray = this.openKey0(65547, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            RegistryKey registryKey;
            int n = 0;
            if (bl) {
                registryKey = this.getSubKey(string);
                if (registryKey != null) {
                    n = registryKey.deleteTree0(false, bl);
                    if (n == 0) {
                        n = WinRegistryAPI.RegDeleteKey(l, RegistryKey.toWindowsName(string));
                    }
                } else {
                    n = this.lastError;
                }
            } else {
                n = WinRegistryAPI.RegDeleteTree(l, RegistryKey.toWindowsName(string));
            }
            if (n == 127) {
                registryKey = this.getSubKey(string);
                if (registryKey != null) {
                    n = registryKey.deleteTree0(false, bl);
                    if (n == 0) {
                        n = WinRegistryAPI.RegDeleteKey(l, RegistryKey.toWindowsName(string));
                    }
                } else {
                    n = this.lastError;
                }
            }
            this.closeKey0(this.handles, lArray[0]);
            this.lastError = n;
            lArray = null;
            return n;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    private int deleteTree0(boolean bl, boolean bl2) {
        if (bl) {
            this.lastError = this.deleteTree1(this, 0, bl, bl2);
            return this.lastError;
        }
        int n = 0;
        if (this.hasSubKeys()) {
            List<RegistryKey> list = this.getSubKeys();
            for (int i = 0; i < list.size(); ++i) {
                n = this.deleteTree1(list.get(i), n, bl, bl2);
                if (n == 0) continue;
                this.lastError = n;
                return this.lastError;
            }
        }
        this.lastError = n;
        return this.lastError;
    }

    private int deleteTree1(RegistryKey registryKey, int n, boolean bl, boolean bl2) {
        if (n != 0) {
            return n;
        }
        if (bl2 && registryKey.isLinkKey()) {
            n = registryKey.deleteLink();
            return n;
        }
        if (registryKey.hasSubKeys()) {
            List<RegistryKey> list = registryKey.getSubKeys();
            for (int i = 0; i < list.size(); ++i) {
                n = this.deleteTree1(list.get(i), n, bl, bl2);
                if (n == 0) continue;
                return n;
            }
        }
        if (bl) {
            return registryKey.deleteKey();
        }
        n = registryKey.deleteKey();
        if (registryKey.isLinkKey()) {
            n = registryKey.deleteKey();
        }
        return n;
    }

    public int deleteValue(String string) {
        long[] lArray;
        long l;
        if (string == null) {
            string = DEFAULT_VALUE_NAME;
        }
        if ((l = (lArray = this.openKey0(2, this.handles))[1]) != 0L) {
            int n = WinRegistryAPI.RegDeleteValue(l, string);
            this.closeKey0(this.handles, lArray[0]);
            this.lastError = n;
            lArray = null;
            return n;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int deleteValue(RegistryValue registryValue) {
        return this.deleteValue(registryValue.getName());
    }

    public int deleteValues(String ... stringArray) {
        if (stringArray == null) {
            this.lastError = 87;
            return 87;
        }
        long[] lArray = this.openKey0(2, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) {
                    stringArray[i] = DEFAULT_VALUE_NAME;
                }
                this.lastError = WinRegistryAPI.RegDeleteValue(l, stringArray[i]);
                if (this.lastError == 0) continue;
                this.closeKey0(this.handles, lArray[0]);
                lArray = null;
                return this.lastError;
            }
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int deleteValues(RegistryValue ... registryValueArray) {
        if (registryValueArray == null) {
            this.lastError = 87;
            return 87;
        }
        long[] lArray = this.openKey0(2, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            for (int i = 0; i < registryValueArray.length; ++i) {
                String string = registryValueArray[i].getName();
                if (string == null) {
                    string = DEFAULT_VALUE_NAME;
                }
                this.lastError = WinRegistryAPI.RegDeleteValue(l, string);
                if (this.lastError == 0) continue;
                this.closeKey0(this.handles, lArray[0]);
                lArray = null;
                return this.lastError;
            }
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int deleteSubKeyValue(String string, String string2) {
        long[] lArray;
        long l;
        if (string2 == null) {
            string2 = DEFAULT_VALUE_NAME;
        }
        if ((l = (lArray = this.openKey0(2, this.handles))[1]) != 0L) {
            int n = WinRegistryAPI.RegDeleteKeyValue(l, string, string2);
            this.closeKey0(this.handles, lArray[0]);
            this.lastError = n;
            lArray = null;
            if (n == 127) {
                if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
                    return this.deleteValue(string2);
                }
                RegistryKey registryKey = this.getSubKey(string);
                if (registryKey != null) {
                    n = registryKey.deleteValue(string2);
                } else {
                    this.lastError = 2;
                    n = 2;
                }
            }
            return n;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int deleteSubKeyValue(String string, RegistryValue registryValue) {
        return this.deleteSubKeyValue(string, registryValue.getName());
    }

    public int deleteSubKeyValues(String string, String ... stringArray) {
        if (stringArray == null) {
            this.lastError = 87;
            return 87;
        }
        long[] lArray = this.openKey0(2, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) {
                    stringArray[i] = DEFAULT_VALUE_NAME;
                }
                this.lastError = WinRegistryAPI.RegDeleteKeyValue(l, string, stringArray[i]);
                if (this.lastError == 127) {
                    if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
                        this.lastError = WinRegistryAPI.RegDeleteValue(l, stringArray[i]);
                    } else {
                        RegistryKey registryKey = this.getSubKey(string);
                        if (registryKey != null) {
                            this.lastError = registryKey.deleteValue(stringArray[i]);
                        } else {
                            this.lastError = 2;
                            this.lastError = 2;
                        }
                    }
                }
                if (this.lastError == 0) continue;
                this.closeKey0(this.handles, lArray[0]);
                lArray = null;
                return this.lastError;
            }
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int deleteSubKeyValues(String string, RegistryValue ... registryValueArray) {
        if (registryValueArray == null) {
            this.lastError = 87;
            return 87;
        }
        long[] lArray = this.openKey0(2, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            for (int i = 0; i < registryValueArray.length; ++i) {
                String string2 = registryValueArray[i].getName();
                if (string2 == null) {
                    string2 = DEFAULT_VALUE_NAME;
                }
                this.lastError = WinRegistryAPI.RegDeleteKeyValue(l, string, string2);
                if (this.lastError == 127) {
                    if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
                        this.lastError = WinRegistryAPI.RegDeleteValue(l, string2);
                    } else {
                        RegistryKey registryKey = this.getSubKey(string);
                        if (registryKey != null) {
                            this.lastError = registryKey.deleteValue(string2);
                        } else {
                            this.lastError = 2;
                            this.lastError = 2;
                        }
                    }
                }
                if (this.lastError == 0) continue;
                this.closeKey0(this.handles, lArray[0]);
                lArray = null;
                return this.lastError;
            }
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int disableReflection() {
        this.lastError = WinRegistryAPI.RegDisableReflectionKey(this.hKey);
        return this.lastError;
    }

    public int disableReflectionTree() {
        this.lastError = this.disableReflectionTree(this, 0);
        return this.lastError;
    }

    private int disableReflectionTree(RegistryKey registryKey, int n) {
        if (n != 0) {
            return n;
        }
        if (registryKey.hasSubKeys()) {
            List<RegistryKey> list = registryKey.getSubKeys();
            for (int i = 0; i < list.size(); ++i) {
                n = this.disableReflectionTree(list.get(i), n);
                if (n == 0) continue;
                return n;
            }
            n = registryKey.disableReflection();
            return n;
        }
        return registryKey.disableReflection();
    }

    public int enableReflection() {
        this.lastError = WinRegistryAPI.RegEnableReflectionKey(this.hKey);
        return this.lastError;
    }

    public int enableReflectionTree() {
        this.lastError = this.enableReflectionTree(this, 0);
        return this.lastError;
    }

    private int enableReflectionTree(RegistryKey registryKey, int n) {
        if (n != 0) {
            return n;
        }
        if (registryKey.hasSubKeys()) {
            List<RegistryKey> list = registryKey.getSubKeys();
            for (int i = 0; i < list.size(); ++i) {
                n = this.enableReflectionTree(list.get(i), n);
                if (n == 0) continue;
                return n;
            }
            n = registryKey.enableReflection();
            return n;
        }
        return registryKey.enableReflection();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RegistryKey)) {
            return false;
        }
        RegistryKey registryKey = (RegistryKey)object;
        return this.compareTo(registryKey) == 0;
    }

    public boolean exists() {
        boolean bl = false;
        long[] lArray = this.openKey0(131097, this.handles);
        long l = lArray[1];
        if (l != 0L || this.lastError == 5) {
            bl = true;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return bl;
    }

    public int flushKey() {
        if (!this.exists()) {
            return this.getParent().flushKey();
        }
        long[] lArray = this.openKey0(131097, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            int n = WinRegistryAPI.RegFlushKey(l);
            this.closeKey0(this.handles, lArray[0]);
            this.lastError = n;
            lArray = null;
            return n;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public String getClassName() {
        int[] nArray = this.getKeyInfo();
        if (nArray == null) {
            return null;
        }
        long[] lArray = this.openKey0(1, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            String string = this.getClassName(l, nArray[3] + 1);
            this.closeKey0(this.handles, lArray[0]);
            nArray = null;
            lArray = null;
            return string;
        }
        this.closeKey0(this.handles, lArray[0]);
        nArray = null;
        lArray = null;
        return null;
    }

    private native String getClassName(long var1, int var3);

    public static native String getCurrentUserSid();

    public int getIndex() {
        if (this.getParent() != null) {
            String[] stringArray = this.getParent().getSubKeyNames();
            int n = Arrays.binarySearch(stringArray, this.name, String.CASE_INSENSITIVE_ORDER);
            stringArray = null;
            if (n < 0) {
                n = Integer.MIN_VALUE;
            }
            return n;
        }
        return Integer.MIN_VALUE;
    }

    public int[] getKeyInfo() {
        long[] lArray = this.openKey0(1, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            int[] nArray = WinRegistryAPI.RegQueryInfoKey(l);
            this.closeKey0(this.handles, lArray[0]);
            lArray = null;
            int n = this.lastError = nArray != null ? nArray[0] : 14;
            if (nArray != null && this.lastError == 0) {
                return nArray;
            }
            nArray = null;
            return null;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return null;
    }

    public int getLastError() {
        return this.lastError;
    }

    public int getLevel() {
        return this.level;
    }

    public RegistryKey getLinkLocation() {
        if (!this.isLinkKey()) {
            return null;
        }
        long[] lArray = this.openLinkKey(1, this.handles);
        long l = lArray[1];
        String string = null;
        if (l != 0L) {
            string = WinRegistryAPI.RegGetLinkLocation(l);
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return string == null ? null : RegistryKey.parseKey(string);
    }

    public String getName() {
        return this.name;
    }

    public int getNumberOfSubKeys() {
        int[] nArray = this.getKeyInfo();
        int n = nArray == null ? 0 : nArray[1];
        nArray = null;
        return n;
    }

    public int getNumberOfValues() {
        int[] nArray = this.getKeyInfo();
        int n = nArray == null ? 0 : nArray[4];
        nArray = null;
        return n;
    }

    public RegistryKey getParent() {
        if (this.path == null || this.path == DEFAULT_VALUE_NAME) {
            return null;
        }
        if (this.parent == null) {
            String string = this.absolutePath();
            int n = string.lastIndexOf(92);
            RegistryKey registryKey = null;
            registryKey = this.hKey == Integer.MIN_VALUE ? roots[0] : (this.hKey == -2147483647L ? roots[1] : (this.hKey == -2147483646L ? roots[2] : (this.hKey == -2147483645L ? roots[3] : (this.hKey == -2147483644L ? roots[4] : (this.hKey == -2147483643L ? roots[5] : (this.hKey == -2147483642L ? roots[6] : null))))));
            if (registryKey == null) {
                return null;
            }
            this.parent = n >= 0 ? new RegistryKey(registryKey, string.substring(0, n)) : registryKey;
        }
        return this.parent;
    }

    public String getPath() {
        if (this.path == null || this.path == DEFAULT_VALUE_NAME) {
            return this.name;
        }
        return this.path + "\\" + this.name;
    }

    public int getRootIndex() {
        if (this.hKey == Integer.MIN_VALUE) {
            return 0;
        }
        if (this.hKey == -2147483643L) {
            return 5;
        }
        if (this.hKey == -2147483647L) {
            return 1;
        }
        if (this.hKey == -2147483642L) {
            return 6;
        }
        if (this.hKey == -2147483646L) {
            return 2;
        }
        if (this.hKey == -2147483644L) {
            return 4;
        }
        if (this.hKey == -2147483645L) {
            return 3;
        }
        return -1;
    }

    public RegistryKey getRootKey() {
        return roots[this.getRootIndex()];
    }

    public RegistryKey getSubKey(String string) {
        if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
            this.lastError = 87;
            return null;
        }
        if (this.keyExists(string)) {
            return new RegistryKey(this.hKey, this, this.getPath(), string);
        }
        return null;
    }

    public String[] getSubKeyNames() {
        int[] nArray = this.getKeyInfo();
        if (nArray == null) {
            return null;
        }
        long[] lArray = this.openKey0(8, this.handles);
        long l = lArray[1];
        if (l != 0L && nArray != null) {
            String[] stringArray = new String[nArray[1]];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = WinRegistryAPI.RegEnumKeyEx(l, i, nArray[2] + 1);
                if (string == null) continue;
                stringArray[i] = string;
            }
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
            this.closeKey0(this.handles, lArray[0]);
            nArray = null;
            lArray = null;
            return stringArray;
        }
        this.closeKey0(this.handles, lArray[0]);
        nArray = null;
        lArray = null;
        return null;
    }

    public List<RegistryKey> getSubKeys() {
        int[] nArray = this.getKeyInfo();
        if (nArray == null) {
            return null;
        }
        long[] lArray = this.openKey0(8, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            int n = nArray[1];
            ArrayList<RegistryKey> arrayList = new ArrayList<RegistryKey>(n);
            for (int i = 0; i < n; ++i) {
                String string = WinRegistryAPI.RegEnumKeyEx(l, i, nArray[2] + 1);
                if (string == null) continue;
                arrayList.add(new RegistryKey(this.hKey, this, this.getPath(), string));
            }
            this.closeKey0(this.handles, lArray[0]);
            nArray = null;
            lArray = null;
            return arrayList;
        }
        this.closeKey0(this.handles, lArray[0]);
        nArray = null;
        lArray = null;
        return null;
    }

    public List<RegistryKey> getSubKeys(String ... stringArray) {
        if (stringArray == null) {
            this.lastError = 87;
            return null;
        }
        ArrayList<RegistryKey> arrayList = new ArrayList<RegistryKey>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            RegistryKey registryKey = this.getSubKey(stringArray[i]);
            if (registryKey == null) {
                arrayList.clear();
                arrayList = null;
                return null;
            }
            arrayList.add(registryKey);
        }
        if (arrayList.size() == 0) {
            arrayList = null;
        }
        this.lastError = 0;
        return arrayList;
    }

    public SystemTime getSystemTime() {
        long[] lArray = this.openKey0(131097, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            SystemTime systemTime = (SystemTime)this.getSystemTime(l);
            this.closeKey0(this.handles, lArray[0]);
            lArray = null;
            if (systemTime == null) {
                this.lastError = 14;
            }
            return systemTime;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return null;
    }

    private native Object getSystemTime(long var1);

    public RegistryValue getValue(String string) {
        RegistryValue registryValue = null;
        long[] lArray = this.openKey0(1, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            Object[] objectArray = WinRegistryAPI.RegQueryValueEx(l, string);
            if (objectArray != null) {
                this.lastError = (Integer)objectArray[0];
                if (this.lastError == 0) {
                    int n = (Integer)objectArray[1];
                    ValueType valueType = RegistryKey.getValueType(n);
                    Object object = objectArray[2];
                    if (valueType == null) {
                        registryValue = new RegBinaryValue(this, string, n, (byte[])object);
                    } else {
                        switch (valueType) {
                            case REG_SZ: {
                                registryValue = new RegStringValue(this, string, valueType, (String)object);
                                break;
                            }
                            case REG_EXPAND_SZ: {
                                registryValue = new RegStringValue(this, string, valueType, RegistryKey.isAutoExpandEnvironmentVariables() ? RegistryKey.expandEnvironmentVariables((String)object) : (String)object);
                                break;
                            }
                            case REG_BINARY: 
                            case REG_NONE: 
                            case REG_LINK: 
                            case REG_RESOURCE_LIST: 
                            case REG_FULL_RESOURCE_DESCRIPTOR: 
                            case REG_RESOURCE_REQUIREMENTS_LIST: {
                                registryValue = new RegBinaryValue(this, string, valueType, (byte[])object);
                                break;
                            }
                            case REG_DWORD: 
                            case REG_DWORD_LITTLE_ENDIAN: 
                            case REG_DWORD_BIG_ENDIAN: {
                                registryValue = new RegDWORDValue(this, string, valueType, (Integer)object);
                                break;
                            }
                            case REG_MULTI_SZ: {
                                registryValue = new RegMultiStringValue(this, string, valueType, (String[])object);
                                break;
                            }
                            case REG_QWORD: 
                            case REG_QWORD_LITTLE_ENDIAN: {
                                registryValue = new RegQWORDValue(this, string, valueType, (Long)object);
                            }
                        }
                    }
                }
                this.closeKey0(this.handles, lArray[0]);
                objectArray = null;
            } else {
                this.lastError = 14;
            }
        } else {
            this.closeKey0(this.handles, lArray[0]);
        }
        lArray = null;
        return registryValue;
    }

    public String[] getValueNames() {
        int[] nArray = this.getKeyInfo();
        if (nArray == null) {
            return null;
        }
        long[] lArray = this.openKey0(1, this.handles);
        long l = lArray[1];
        if (l != 0L && nArray != null) {
            String[] stringArray = new String[nArray[4]];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = WinRegistryAPI.RegEnumValue(l, i, nArray[5] + 1);
                if (string == null) continue;
                stringArray[i] = string;
            }
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
            this.closeKey0(this.handles, lArray[0]);
            nArray = null;
            lArray = null;
            return stringArray;
        }
        this.closeKey0(this.handles, lArray[0]);
        nArray = null;
        lArray = null;
        return null;
    }

    public List<RegistryValue> getValues() {
        int[] nArray = this.getKeyInfo();
        if (nArray == null) {
            return null;
        }
        long[] lArray = this.openKey0(1, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            int n = nArray[4];
            ArrayList<RegistryValue> arrayList = new ArrayList<RegistryValue>(n);
            for (int i = 0; i < n; ++i) {
                String string = WinRegistryAPI.RegEnumValue(l, i, nArray[5] + 1);
                if (string == null) continue;
                Object[] objectArray = WinRegistryAPI.RegQueryValueEx(l, string);
                if (objectArray == null) {
                    this.lastError = 14;
                    continue;
                }
                this.lastError = (Integer)objectArray[0];
                if (this.lastError == 0) {
                    Integer n2 = (Integer)objectArray[1];
                    if (n2 == null) continue;
                    ValueType valueType = RegistryKey.getValueType(n2);
                    Object object = objectArray[2];
                    if (valueType == null) {
                        arrayList.add(new RegBinaryValue(this, string, n2, (byte[])object));
                    } else {
                        switch (valueType) {
                            case REG_SZ: {
                                arrayList.add(new RegStringValue(this, string, valueType, (String)object));
                                break;
                            }
                            case REG_EXPAND_SZ: {
                                arrayList.add(new RegStringValue(this, string, valueType, RegistryKey.isAutoExpandEnvironmentVariables() ? RegistryKey.expandEnvironmentVariables((String)object) : (String)object));
                                break;
                            }
                            case REG_BINARY: 
                            case REG_NONE: 
                            case REG_LINK: 
                            case REG_RESOURCE_LIST: 
                            case REG_FULL_RESOURCE_DESCRIPTOR: 
                            case REG_RESOURCE_REQUIREMENTS_LIST: {
                                arrayList.add(new RegBinaryValue(this, string, valueType, (byte[])object));
                                break;
                            }
                            case REG_DWORD: 
                            case REG_DWORD_LITTLE_ENDIAN: 
                            case REG_DWORD_BIG_ENDIAN: {
                                arrayList.add(new RegDWORDValue(this, string, valueType, (Integer)object));
                                break;
                            }
                            case REG_MULTI_SZ: {
                                arrayList.add(new RegMultiStringValue(this, string, valueType, (String[])object));
                                break;
                            }
                            case REG_QWORD: 
                            case REG_QWORD_LITTLE_ENDIAN: {
                                arrayList.add(new RegQWORDValue(this, string, valueType, (Long)object));
                            }
                        }
                    }
                }
                objectArray = null;
            }
            this.closeKey0(this.handles, lArray[0]);
            nArray = null;
            lArray = null;
            return arrayList;
        }
        this.closeKey0(this.handles, lArray[0]);
        nArray = null;
        lArray = null;
        return null;
    }

    public List<RegistryValue> getValues(String ... stringArray) {
        if (stringArray == null) {
            this.lastError = 87;
            return null;
        }
        ArrayList<RegistryValue> arrayList = null;
        long[] lArray = this.openKey0(1, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            Object[] objectArray = WinRegistryAPI.RegQueryMultipleValues(l, stringArray);
            if (objectArray != null) {
                arrayList = new ArrayList<RegistryValue>(stringArray.length);
                this.lastError = (Integer)objectArray[0];
                if (this.lastError == 0) {
                    int n = 1;
                    block8: for (int i = 0; i < stringArray.length; ++i) {
                        Integer n2;
                        String string = stringArray[i];
                        if ((n2 = (Integer)objectArray[n++]) == null) continue;
                        ValueType valueType = RegistryKey.getValueType(n2);
                        Object object = objectArray[n++];
                        if (valueType == null) {
                            arrayList.add(new RegBinaryValue(this, string, n2, (byte[])object));
                            continue;
                        }
                        switch (valueType) {
                            case REG_SZ: {
                                arrayList.add(new RegStringValue(this, string, valueType, (String)object));
                                continue block8;
                            }
                            case REG_EXPAND_SZ: {
                                arrayList.add(new RegStringValue(this, string, valueType, RegistryKey.isAutoExpandEnvironmentVariables() ? RegistryKey.expandEnvironmentVariables((String)object) : (String)object));
                                continue block8;
                            }
                            case REG_BINARY: 
                            case REG_NONE: 
                            case REG_LINK: 
                            case REG_RESOURCE_LIST: 
                            case REG_FULL_RESOURCE_DESCRIPTOR: 
                            case REG_RESOURCE_REQUIREMENTS_LIST: {
                                arrayList.add(new RegBinaryValue(this, string, valueType, (byte[])object));
                                continue block8;
                            }
                            case REG_DWORD: 
                            case REG_DWORD_LITTLE_ENDIAN: 
                            case REG_DWORD_BIG_ENDIAN: {
                                arrayList.add(new RegDWORDValue(this, string, valueType, (Integer)object));
                                continue block8;
                            }
                            case REG_MULTI_SZ: {
                                arrayList.add(new RegMultiStringValue(this, string, valueType, (String[])object));
                                continue block8;
                            }
                            case REG_QWORD: 
                            case REG_QWORD_LITTLE_ENDIAN: {
                                arrayList.add(new RegQWORDValue(this, string, valueType, (Long)object));
                            }
                        }
                    }
                } else if (this.lastError != 1012 && this.lastError != 2) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        RegistryValue registryValue = this.getValue(stringArray[i]);
                        if (registryValue == null) {
                            arrayList.clear();
                            break;
                        }
                        arrayList.add(registryValue);
                    }
                    arrayList = null;
                } else {
                    arrayList = null;
                }
            } else {
                this.lastError = 14;
            }
            this.closeKey0(this.handles, lArray[0]);
            objectArray = null;
            lArray = null;
            return arrayList;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return null;
    }

    public static ValueType getValueType(int n) {
        switch (n) {
            case 0: {
                return ValueType.REG_NONE;
            }
            case 1: {
                return ValueType.REG_SZ;
            }
            case 2: {
                return ValueType.REG_EXPAND_SZ;
            }
            case 3: {
                return ValueType.REG_BINARY;
            }
            case 4: {
                return ValueType.REG_DWORD;
            }
            case 5: {
                return ValueType.REG_DWORD_BIG_ENDIAN;
            }
            case 6: {
                return ValueType.REG_LINK;
            }
            case 7: {
                return ValueType.REG_MULTI_SZ;
            }
            case 8: {
                return ValueType.REG_RESOURCE_LIST;
            }
            case 9: {
                return ValueType.REG_FULL_RESOURCE_DESCRIPTOR;
            }
            case 10: {
                return ValueType.REG_RESOURCE_REQUIREMENTS_LIST;
            }
            case 11: {
                return ValueType.REG_QWORD;
            }
        }
        return null;
    }

    public boolean hasDefaultValue() {
        return this.valueExists(DEFAULT_VALUE_NAME);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.path.hashCode();
    }

    public boolean hasSubKeys() {
        int[] nArray = this.getKeyInfo();
        boolean bl = nArray != null && nArray[1] != 0;
        nArray = null;
        return bl;
    }

    public boolean hasValues() {
        int[] nArray = this.getKeyInfo();
        boolean bl = nArray != null && nArray[4] != 0;
        nArray = null;
        return bl;
    }

    public boolean isLinkKey() {
        int[] nArray;
        boolean bl = false;
        long[] lArray = this.openLinkKey(3, this.handles);
        long l = lArray[1];
        if (l != 0L && (nArray = WinRegistryAPI.RegIsLinkKey(l)) != null) {
            this.lastError = nArray[0];
            bl = nArray[1] == 1;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return bl;
    }

    public boolean isRemoteRegistryKey() {
        return this.machine != null;
    }

    private boolean isRootHandle(long l) {
        return l == Integer.MIN_VALUE || l == -2147483647L || l == -2147483646L || l == -2147483645L || l == -2147483643L || l == -2147483642L || l == -2147483644L;
    }

    public boolean isViewing64BitRegistry() {
        return this.view64 == 256;
    }

    public boolean keyExists(String string) {
        if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
            this.lastError = 87;
            return false;
        }
        long[] lArray = this.openSubKey0(string);
        long l = lArray[1];
        if (l != 0L || this.lastError == 5) {
            this.closeKey0(this.handles, lArray[0]);
            lArray = null;
            return true;
        }
        lArray = null;
        return false;
    }

    public boolean keyIsLink(String string) {
        int[] nArray;
        if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
            this.lastError = 87;
            return false;
        }
        boolean bl = false;
        long[] lArray = this.openSubLinkKey0(string);
        long l = lArray[1];
        if (l != 0L && (nArray = WinRegistryAPI.RegIsLinkKey(l)) != null) {
            bl = nArray[1] == 1;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return bl;
    }

    public long lastModified() {
        long[] lArray = this.openKey0(1, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            long l2 = this.lastModified(l);
            this.closeKey0(this.handles, lArray[0]);
            lArray = null;
            return l2 -= 11644473600000L;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return 0L;
    }

    private native long lastModified(long var1);

    public int loadKey(String string, File file) {
        if (!this.canLoadKey()) {
            return 5;
        }
        long l = this.openKey(131078);
        if (l != 0L) {
            if (!WinRegistryAPI.SetPrivilege(true, SE_BACKUP_NAME_STRING)) {
                this.closeKey(l);
                return 5;
            }
            if (!WinRegistryAPI.SetPrivilege(true, SE_RESTORE_NAME_STRING)) {
                this.closeKey(l);
                return 5;
            }
            int n = WinRegistryAPI.RegLoadKey(l, RegistryKey.toWindowsName(string), file.getAbsolutePath());
            this.closeKey(l);
            this.lastError = n;
            WinRegistryAPI.SetPrivilege(false, SE_BACKUP_NAME_STRING);
            WinRegistryAPI.SetPrivilege(false, SE_RESTORE_NAME_STRING);
            return n;
        }
        return this.lastError;
    }

    public RegistryValue newValue(String string, ValueType valueType) {
        if (string == null) {
            string = DEFAULT_VALUE_NAME;
        }
        if (this.valueExists(string)) {
            return null;
        }
        RegistryValue registryValue = null;
        switch (valueType) {
            case REG_SZ: 
            case REG_EXPAND_SZ: {
                registryValue = new RegStringValue(this, string, valueType, null);
                this.lastError = ((RegStringValue)registryValue).setValue(DEFAULT_VALUE_NAME);
                break;
            }
            case REG_BINARY: 
            case REG_NONE: 
            case REG_LINK: 
            case REG_RESOURCE_LIST: 
            case REG_FULL_RESOURCE_DESCRIPTOR: 
            case REG_RESOURCE_REQUIREMENTS_LIST: {
                registryValue = new RegBinaryValue(this, string, valueType, null);
                this.lastError = ((RegBinaryValue)registryValue).setValue(new byte[0]);
                break;
            }
            case REG_DWORD: 
            case REG_DWORD_LITTLE_ENDIAN: 
            case REG_DWORD_BIG_ENDIAN: {
                registryValue = new RegDWORDValue(this, string, valueType, null);
                this.lastError = ((RegDWORDValue)registryValue).setIntValue(0);
                break;
            }
            case REG_MULTI_SZ: {
                registryValue = new RegMultiStringValue(this, string, valueType, null);
                this.lastError = ((RegMultiStringValue)registryValue).setValue(new String[0]);
                break;
            }
            case REG_QWORD: 
            case REG_QWORD_LITTLE_ENDIAN: {
                registryValue = new RegQWORDValue(this, string, valueType, null);
                this.lastError = ((RegQWORDValue)registryValue).setLongValue(0L);
            }
        }
        return this.lastError == 0 ? registryValue : null;
    }

    public RegistryValue newValue(String string, int n) {
        ValueType valueType = RegistryKey.getValueType(n);
        if (valueType != null) {
            return this.newValue(string, valueType);
        }
        if (string == null) {
            string = DEFAULT_VALUE_NAME;
        }
        RegBinaryValue regBinaryValue = new RegBinaryValue(this, string, n, null);
        this.lastError = regBinaryValue.setValue(new byte[0]);
        return this.lastError == 0 ? regBinaryValue : null;
    }

    static int notifyChange(long l, boolean bl, int n, long l2) {
        return WinRegistryAPI.RegNotifyChangeKeyValue(l, bl, n, l2, true);
    }

    private long openKey(int n) {
        long[] lArray;
        int n2 = this.view64;
        if (this.absolutePath().length() == 0) {
            n2 = 0;
        }
        long l = 0L;
        if (this.machine == null) {
            l = this.hKey;
        } else {
            lArray = WinRegistryAPI.RegConnectRegistry(this.machine, this.hKey);
            if (lArray != null && lArray[0] != 0L) {
                l = 0L;
            } else if (lArray != null) {
                l = lArray[1];
            }
            int n3 = this.lastError = lArray == null ? 14 : (int)lArray[0];
            if (this.lastError != 0) {
                return 0L;
            }
        }
        lArray = WinRegistryAPI.RegOpenKeyEx(l, this.absolutePath(), n | n2);
        if (lArray != null && lArray[0] != 0L) {
            lArray[1] = 0L;
        }
        this.lastError = lArray == null ? 14 : (int)lArray[0];
        return lArray == null ? 0L : lArray[1];
    }

    long[] openKey0(int n) {
        return this.openKey0(n, this.handles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] openKey0(int n, List<Long> list) {
        List<Long> list2 = list;
        synchronized (list2) {
            long[] lArray;
            Object object;
            long l = 0L;
            if (this.machine == null) {
                l = this.hKey;
            } else {
                object = WinRegistryAPI.RegConnectRegistry(this.machine, this.hKey);
                if (object != null && object[0] != 0L) {
                    l = 0L;
                } else if (object != null) {
                    l = object[1];
                }
                int n2 = this.lastError = object == null ? 14 : (int)object[0];
                if (this.lastError != 0) {
                    return new long[]{0L, 0L};
                }
            }
            object = new StringTokenizer(this.absolutePath(), "\\");
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            long l2 = list.size() == 0 ? 0 : list.size() - 1;
            long l3 = l;
            n |= this.view64;
            while (object.hasMoreTokens()) {
                if (n3 != 32) {
                    stringBuffer.append(object.nextToken() + "\\");
                    ++n3;
                    continue;
                }
                lArray = WinRegistryAPI.RegOpenKeyEx(l3, stringBuffer.toString(), n);
                int n4 = this.lastError = lArray == null ? 14 : (int)lArray[0];
                if (lArray != null && lArray[0] == 0L) {
                    list.add(lArray[1]);
                    l3 = lArray[1];
                    stringBuffer.setLength(0);
                    n3 = 0;
                    continue;
                }
                if (lArray != null) {
                    this.closeKey(lArray[1]);
                }
                stringBuffer.setLength(0);
                this.closeKey0(this.handles, l2);
                return new long[]{l2, 0L};
            }
            if (stringBuffer.length() != 0) {
                if (this.absolutePath().length() == 0) {
                    n &= ~this.view64;
                }
                int n5 = this.lastError = (lArray = WinRegistryAPI.RegOpenKeyEx(l3, stringBuffer.toString(), n)) == null ? 14 : (int)lArray[0];
                if (lArray != null && lArray[0] == 0L) {
                    list.add(lArray[1]);
                    l3 = lArray[1];
                } else {
                    if (lArray != null) {
                        this.closeKey(lArray[1]);
                    }
                    this.closeKey0(this.handles, l2);
                    l3 = 0L;
                }
            }
            return new long[]{l2, l3};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] openLinkKey(int n, List<Long> list) {
        List<Long> list2 = list;
        synchronized (list2) {
            Object object;
            long l = 0L;
            if (this.machine == null) {
                l = this.hKey;
            } else {
                object = WinRegistryAPI.RegConnectRegistry(this.machine, this.hKey);
                if (object != null && object[0] != 0L) {
                    l = 0L;
                } else if (object != null) {
                    l = object[1];
                }
                int n2 = this.lastError = object == null ? 14 : (int)object[0];
                if (this.lastError != 0) {
                    return new long[]{0L, 0L};
                }
            }
            object = new StringTokenizer(this.absolutePath(), "\\");
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            long l2 = list.size() == 0 ? 0 : list.size() - 1;
            long l3 = l;
            n |= this.view64;
            while (object.hasMoreTokens()) {
                if (n3 != 32) {
                    stringBuffer.append(object.nextToken() + "\\");
                    ++n3;
                    continue;
                }
                long[] lArray = null;
                if (object.hasMoreTokens()) {
                    lArray = WinRegistryAPI.RegOpenKeyEx(l3, stringBuffer.toString(), n);
                } else {
                    int n4 = 9;
                    lArray = WinRegistryAPI.RegCreateKeyEx(l3, stringBuffer.toString(), n4, n, null);
                }
                int n5 = this.lastError = lArray == null ? 14 : (int)lArray[0];
                if (lArray != null && lArray[0] == 0L) {
                    if (lArray[2] == 1L) {
                        WinRegistryAPI.RegDeleteKey(l3, stringBuffer.toString());
                        this.lastError = 2;
                        this.closeKey0(this.handles, l2);
                        return new long[]{l2, 0L};
                    }
                    list.add(lArray[1]);
                    l3 = lArray[1];
                    stringBuffer.setLength(0);
                    n3 = 0;
                    continue;
                }
                if (lArray != null) {
                    this.closeKey(lArray[1]);
                }
                stringBuffer.setLength(0);
                this.closeKey0(this.handles, l2);
                return new long[]{l2, 0L};
            }
            if (stringBuffer.length() != 0) {
                if (this.absolutePath().length() == 0) {
                    n &= ~this.view64;
                }
                int n6 = 9;
                long[] lArray = WinRegistryAPI.RegCreateKeyEx(l3, stringBuffer.toString(), n6, n, null);
                int n7 = this.lastError = lArray == null ? 14 : (int)lArray[0];
                if (lArray != null && lArray[0] == 0L) {
                    if (lArray[2] == 1L) {
                        WinRegistryAPI.RegDeleteKey(l3, stringBuffer.toString());
                        this.lastError = 2;
                        this.closeKey0(this.handles, l2);
                        return new long[]{l2, 0L};
                    }
                    list.add(lArray[1]);
                    l3 = lArray[1];
                } else {
                    if (lArray != null) {
                        this.closeKey(lArray[1]);
                    }
                    this.closeKey0(this.handles, l2);
                    l3 = 0L;
                }
            }
            return new long[]{l2, l3};
        }
    }

    private long openSubKey(String string) {
        long[] lArray;
        if ((string = RegistryKey.toWindowsName(string)) == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
            this.lastError = 87;
            return 0L;
        }
        String string2 = this.absolutePath() + "\\" + string;
        if (string2.charAt(0) == '\\') {
            string2 = string2.substring(1);
        }
        if (string2.charAt(string2.length() - 1) == '\\') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        long l = 0L;
        if (this.machine == null) {
            l = this.hKey;
        } else {
            lArray = WinRegistryAPI.RegConnectRegistry(this.machine, this.hKey);
            if (lArray != null && lArray[0] != 0L) {
                l = 0L;
            } else if (lArray != null) {
                l = lArray[1];
            }
            int n = this.lastError = lArray == null ? 14 : (int)lArray[0];
            if (this.lastError != 0) {
                return 0L;
            }
        }
        lArray = WinRegistryAPI.RegOpenKeyEx(l, string2, 0x20019 | this.view64);
        if (lArray != null && lArray[0] != 0L) {
            lArray[1] = 0L;
        }
        this.lastError = lArray == null ? 14 : (int)lArray[0];
        return lArray != null ? lArray[1] : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] openSubKey0(String string) {
        LinkedList<Long> linkedList = this.handles;
        synchronized (linkedList) {
            long[] lArray;
            Object object;
            string = RegistryKey.toWindowsName(string);
            if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
                this.lastError = 87;
                return new long[]{0L, 0L};
            }
            String string2 = this.absolutePath() + "\\" + string;
            if (string2.charAt(0) == '\\') {
                string2 = string2.substring(1);
            }
            if (string2.charAt(string2.length() - 1) == '\\') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            long l = 0L;
            if (this.machine == null) {
                l = this.hKey;
            } else {
                object = WinRegistryAPI.RegConnectRegistry(this.machine, this.hKey);
                if (object != null && object[0] != 0L) {
                    l = 0L;
                } else if (object != null) {
                    l = object[1];
                }
                int n = this.lastError = object == null ? 14 : (int)object[0];
                if (this.lastError != 0) {
                    return new long[]{0L, 0L};
                }
            }
            object = new StringTokenizer(string2, "\\");
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            long l2 = this.handles.size() == 0 ? 0 : this.handles.size() - 1;
            long l3 = l;
            while (object.hasMoreTokens()) {
                if (n != 32) {
                    stringBuffer.append(object.nextToken() + "\\");
                    ++n;
                    continue;
                }
                lArray = WinRegistryAPI.RegOpenKeyEx(l3, stringBuffer.toString(), 0x20019 | this.view64);
                if (lArray != null && lArray[0] == 0L) {
                    this.handles.add(lArray[1]);
                    l3 = lArray[1];
                    stringBuffer.setLength(0);
                    n = 0;
                    continue;
                }
                if (lArray != null) {
                    this.closeKey(lArray[1]);
                }
                stringBuffer.setLength(0);
                this.closeKey0(this.handles, l2);
                return new long[]{l2, 0L};
            }
            if (stringBuffer.length() != 0) {
                lArray = WinRegistryAPI.RegOpenKeyEx(l3, stringBuffer.toString(), 0x20019 | this.view64);
                if (lArray != null && lArray[0] == 0L) {
                    this.handles.add(lArray[1]);
                    l3 = lArray[1];
                } else {
                    if (lArray != null) {
                        this.closeKey(lArray[1]);
                    }
                    this.closeKey0(this.handles, l2);
                    l3 = 0L;
                }
            }
            return new long[]{l2, l3};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] openSubLinkKey0(String string) {
        LinkedList<Long> linkedList = this.handles;
        synchronized (linkedList) {
            Object object;
            string = RegistryKey.toWindowsName(string);
            if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
                this.lastError = 87;
                return new long[]{0L, 0L};
            }
            String string2 = this.absolutePath() + "\\" + string;
            if (string2.charAt(0) == '\\') {
                string2 = string2.substring(1);
            }
            if (string2.charAt(string2.length() - 1) == '\\') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            long l = 0L;
            if (this.machine == null) {
                l = this.hKey;
            } else {
                object = WinRegistryAPI.RegConnectRegistry(this.machine, this.hKey);
                if (object != null && object[0] != 0L) {
                    l = 0L;
                } else if (object != null) {
                    l = object[1];
                }
                int n = this.lastError = object == null ? 14 : (int)object[0];
                if (this.lastError != 0) {
                    return new long[]{0L, 0L};
                }
            }
            object = new StringTokenizer(string2, "\\");
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            long l2 = this.handles.size() == 0 ? 0 : this.handles.size() - 1;
            long l3 = l;
            int n2 = 3 | this.view64;
            while (object.hasMoreTokens()) {
                if (n != 32) {
                    stringBuffer.append(object.nextToken() + "\\");
                    ++n;
                    continue;
                }
                long[] lArray = null;
                if (object.hasMoreTokens()) {
                    lArray = WinRegistryAPI.RegOpenKeyEx(l3, stringBuffer.toString(), n2);
                } else {
                    int n3 = 9;
                    lArray = WinRegistryAPI.RegCreateKeyEx(l3, stringBuffer.toString(), n3, n2, null);
                }
                int n4 = this.lastError = lArray == null ? 14 : (int)lArray[0];
                if (lArray != null && lArray[0] == 0L) {
                    if (lArray[2] == 1L) {
                        this.lastError = WinRegistryAPI.RegDeleteKey(l3, stringBuffer.toString());
                        this.closeKey0(this.handles, l2);
                        return new long[]{l2, 0L};
                    }
                    this.handles.add(lArray[1]);
                    l3 = lArray[1];
                    stringBuffer.setLength(0);
                    n = 0;
                    continue;
                }
                if (lArray != null) {
                    this.closeKey(lArray[1]);
                }
                stringBuffer.setLength(0);
                this.closeKey0(this.handles, l2);
                return new long[]{l2, 0L};
            }
            if (stringBuffer.length() != 0) {
                int n5 = 9;
                long[] lArray = WinRegistryAPI.RegCreateKeyEx(l3, stringBuffer.toString(), n5, n2, null);
                int n6 = this.lastError = lArray == null ? 14 : (int)lArray[0];
                if (lArray != null && lArray[0] == 0L) {
                    if (lArray[2] == 1L) {
                        this.lastError = WinRegistryAPI.RegDeleteKey(l3, stringBuffer.toString());
                        this.closeKey0(this.handles, l2);
                        return new long[]{l2, 0L};
                    }
                    this.handles.add(lArray[1]);
                    l3 = lArray[1];
                } else {
                    if (lArray != null) {
                        this.closeKey(lArray[1]);
                    }
                    this.closeKey0(this.handles, l2);
                    l3 = 0L;
                }
            }
            return new long[]{l2, l3};
        }
    }

    public boolean queryReflection() {
        return WinRegistryAPI.RegQueryReflectionKey(this.hKey);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.hKey = objectInputStream.readLong();
        this.parent = null;
        this.name = (String)objectInputStream.readObject();
        this.path = (String)objectInputStream.readObject();
        this.absolutePath = (String)objectInputStream.readObject();
        this.handles = new LinkedList();
        this.created = objectInputStream.readBoolean();
        this.level = objectInputStream.readInt();
        this.lastError = objectInputStream.readInt();
        this.view64 = objectInputStream.readInt();
        this.machine = (String)objectInputStream.readObject();
        this.disposer = new KeyDisposer();
        Disposer.addRecord(this, this.disposer);
    }

    public boolean renameKey(String string) {
        long[] lArray = this.openLinkKey(131078, this.handles);
        long l = lArray[1];
        boolean bl = false;
        if (l != 0L) {
            int n;
            this.lastError = WinRegistryAPI.RegRenameKey(l, string);
            boolean bl2 = bl = this.lastError == 0;
            if (bl && (n = this.absolutePath.lastIndexOf(this.name)) != -1) {
                String string2 = this.absolutePath.substring(0, n);
                this.absolutePath = string2 + string;
                this.name = string;
            }
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return bl;
    }

    public boolean renameValue(String string, String string2) {
        RegistryValue registryValue = this.getValue(string);
        if (registryValue == null) {
            return false;
        }
        if (!this.valueExists(string2)) {
            String string3 = registryValue.getName();
            this.lastError = registryValue.setName(string2);
            if (this.lastError == 0) {
                this.deleteValue(string3);
                return true;
            }
        }
        return false;
    }

    public boolean renameValue(RegistryValue registryValue, String string) {
        if (registryValue == null) {
            return false;
        }
        String string2 = registryValue.getName();
        if (this.equals(registryValue.getKey()) && !this.valueExists(string)) {
            this.lastError = registryValue.setName(string);
            if (this.lastError == 0) {
                this.deleteValue(string2);
                return true;
            }
        }
        return false;
    }

    public int replaceKey(File file, File file2) {
        long[] lArray = this.openKey0(131078, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            if (!WinRegistryAPI.SetPrivilege(true, SE_BACKUP_NAME_STRING)) {
                this.closeKey0(this.handles, lArray[0]);
                lArray = null;
                return 5;
            }
            if (!WinRegistryAPI.SetPrivilege(true, SE_RESTORE_NAME_STRING)) {
                this.closeKey0(this.handles, lArray[0]);
                lArray = null;
                return 5;
            }
            int n = WinRegistryAPI.RegReplaceKey(l, DEFAULT_VALUE_NAME, file.getAbsolutePath(), file2.getAbsolutePath());
            this.closeKey0(this.handles, lArray[0]);
            this.lastError = n;
            WinRegistryAPI.SetPrivilege(false, SE_BACKUP_NAME_STRING);
            WinRegistryAPI.SetPrivilege(false, SE_RESTORE_NAME_STRING);
            lArray = null;
            return n;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int replaceSubKey(String string, File file, File file2) {
        if (string == null || string.length() == 0 || string.equals(DEFAULT_VALUE_NAME)) {
            this.lastError = 87;
            return this.lastError;
        }
        long[] lArray = this.openKey0(131078, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            if (!WinRegistryAPI.SetPrivilege(true, SE_BACKUP_NAME_STRING)) {
                this.closeKey0(this.handles, lArray[0]);
                lArray = null;
                return 5;
            }
            if (!WinRegistryAPI.SetPrivilege(true, SE_RESTORE_NAME_STRING)) {
                this.closeKey0(this.handles, lArray[0]);
                lArray = null;
                return 5;
            }
            int n = WinRegistryAPI.RegReplaceKey(l, RegistryKey.toWindowsName(string), file.getAbsolutePath(), file2.getAbsolutePath());
            this.closeKey0(this.handles, lArray[0]);
            this.lastError = n;
            WinRegistryAPI.SetPrivilege(false, SE_BACKUP_NAME_STRING);
            WinRegistryAPI.SetPrivilege(false, SE_RESTORE_NAME_STRING);
            lArray = null;
            return n;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int restoreKey(File file) {
        return this.restoreKey(file, false);
    }

    public int restoreKey(File file, boolean bl) {
        long[] lArray = this.openKey0(131078, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            if (!WinRegistryAPI.SetPrivilege(true, SE_BACKUP_NAME_STRING)) {
                this.closeKey0(this.handles, lArray[0]);
                lArray = null;
                return 5;
            }
            if (!WinRegistryAPI.SetPrivilege(true, SE_RESTORE_NAME_STRING)) {
                this.closeKey0(this.handles, lArray[0]);
                lArray = null;
                return 5;
            }
            int n = WinRegistryAPI.RegRestoreKey(l, file.getAbsolutePath(), bl ? 8 : 0);
            this.closeKey0(this.handles, lArray[0]);
            this.lastError = n;
            WinRegistryAPI.SetPrivilege(false, SE_BACKUP_NAME_STRING);
            WinRegistryAPI.SetPrivilege(false, SE_RESTORE_NAME_STRING);
            lArray = null;
            return n;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int saveKey(File file) throws IOException {
        long[] lArray = this.openKey0(131078, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            int n;
            if (!WinRegistryAPI.SetPrivilege(true, SE_BACKUP_NAME_STRING)) {
                this.closeKey0(this.handles, lArray[0]);
                lArray = null;
                return 5;
            }
            File file2 = null;
            if (file.exists()) {
                file2 = File.createTempFile("jrsk", null);
                file2.delete();
            }
            if ((n = WinRegistryAPI.RegSaveKey(l, file2 != null ? file2.getAbsolutePath() : file.getAbsolutePath())) == 0) {
                if (file2 != null) {
                    boolean bl = file.delete();
                    if (bl) {
                        file2.renameTo(file);
                    }
                    file2 = null;
                }
            } else if (file2 != null) {
                file2.delete();
            }
            WinRegistryAPI.SetPrivilege(false, SE_BACKUP_NAME_STRING);
            this.closeKey0(this.handles, lArray[0]);
            this.lastError = n;
            lArray = null;
            return n;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int saveKey(boolean bl, boolean bl2, File file) throws IOException {
        if (bl2 && !this.canUnLoadKey()) {
            return 87;
        }
        long[] lArray = this.openKey0(131078, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            int n;
            int n2;
            if (!WinRegistryAPI.SetPrivilege(true, SE_BACKUP_NAME_STRING)) {
                this.closeKey0(this.handles, lArray[0]);
                lArray = null;
                return 5;
            }
            File file2 = null;
            if (file.exists()) {
                file2 = File.createTempFile("jrsk", null);
                file2.delete();
            }
            int n3 = n2 = bl ? 2 : 1;
            if (bl2) {
                n2 = 4;
            }
            if ((n = WinRegistryAPI.RegSaveKeyEx(l, file2 != null ? file2.getAbsolutePath() : file.getAbsolutePath(), n2)) == 127) {
                n = WinRegistryAPI.RegSaveKey(l, file2 != null ? file2.getAbsolutePath() : file.getAbsolutePath());
            }
            if (n == 0) {
                if (file2 != null) {
                    boolean bl3 = file.delete();
                    if (bl3) {
                        file2.renameTo(file);
                    }
                    file2 = null;
                }
            } else if (file2 != null) {
                file2.delete();
            }
            WinRegistryAPI.SetPrivilege(false, SE_BACKUP_NAME_STRING);
            this.closeKey0(this.handles, lArray[0]);
            this.lastError = n;
            lArray = null;
            return n;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return this.lastError;
    }

    public int searchIntegerValue(int n, long l) {
        long[] lArray = this.openKey0(1, this.handles);
        long l2 = lArray[1];
        if (l2 != 0L) {
            int[] nArray = WinRegistryAPI.RegQueryInfoKey(l2);
            int n2 = this.lastError = nArray != null ? nArray[0] : 14;
            if (nArray != null && nArray[0] == 0) {
                if (n < 0 || n >= nArray[4]) {
                    this.closeKey0(this.handles, lArray[0]);
                    nArray = null;
                    lArray = null;
                    return -1;
                }
                String[] stringArray = this.getValueNames();
                int n3 = this.searchInteger(l2, n, l, stringArray);
                this.closeKey0(this.handles, lArray[0]);
                stringArray = null;
                nArray = null;
                lArray = null;
                return n3;
            }
            nArray = null;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return -1;
    }

    private native int searchInteger(long var1, int var3, long var4, String[] var6);

    public int searchStringValue(int n, String string) {
        return this.searchStringValue(n, true, true, false, string);
    }

    public int searchStringValue(int n, boolean bl, boolean bl2, boolean bl3, String string) {
        long[] lArray = this.openKey0(1, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            int[] nArray = WinRegistryAPI.RegQueryInfoKey(l);
            int n2 = this.lastError = nArray != null ? nArray[0] : 14;
            if (nArray != null && nArray[0] == 0) {
                if (n < 0 || n >= nArray[4]) {
                    this.closeKey0(this.handles, lArray[0]);
                    nArray = null;
                    lArray = null;
                    return -1;
                }
                String[] stringArray = this.getValueNames();
                int n3 = this.searchString(l, n, bl, bl2, bl3, string, stringArray);
                this.closeKey0(this.handles, lArray[0]);
                stringArray = null;
                nArray = null;
                lArray = null;
                return n3;
            }
            nArray = null;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return -1;
    }

    private native int searchString(long var1, int var3, boolean var4, boolean var5, boolean var6, String var7, String[] var8);

    public int searchBinaryValue(int n, byte[] byArray) {
        long[] lArray = this.openKey0(1, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            int[] nArray = WinRegistryAPI.RegQueryInfoKey(l);
            int n2 = this.lastError = nArray != null ? nArray[0] : 14;
            if (nArray != null && nArray[0] == 0) {
                if (n < 0 || n >= nArray[4]) {
                    this.closeKey0(this.handles, lArray[0]);
                    nArray = null;
                    lArray = null;
                    return -1;
                }
                String[] stringArray = this.getValueNames();
                int n3 = this.searchBinary(l, n, byArray, stringArray);
                this.closeKey0(this.handles, lArray[0]);
                stringArray = null;
                nArray = null;
                lArray = null;
                return n3;
            }
            nArray = null;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return -1;
    }

    private native int searchBinary(long var1, int var3, byte[] var4, String[] var5);

    public boolean setLinkTo(RegistryKey registryKey) {
        if (!this.isLinkKey()) {
            return false;
        }
        if (registryKey == null) {
            return false;
        }
        String string = registryKey.toNativePath();
        if (string == null) {
            return false;
        }
        long[] lArray = this.openLinkKey(2, this.handles);
        long l = lArray[1];
        boolean bl = false;
        if (l != 0L) {
            this.lastError = WinRegistryAPI.RegSetLinkValue(l, "SymbolicLinkValue", string);
            bl = this.lastError == 0;
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return bl;
    }

    void setWatchHandles(List<Long> list) {
        if (this.disposer.watchHandles != null) {
            this.closeKey0(this.disposer.watchHandles, 0L);
        }
        this.disposer.watchHandles = list;
    }

    public Iterator<String> subKeyNamesIterator() {
        int[] nArray = this.getKeyInfo();
        if (nArray == null) {
            return null;
        }
        RegistryKeyIterator<String> registryKeyIterator = new RegistryKeyIterator<String>(nArray[1], nArray[2], true);
        nArray = null;
        return registryKeyIterator;
    }

    public Iterator<RegistryKey> subKeysIterator() {
        int[] nArray = this.getKeyInfo();
        if (nArray == null) {
            return null;
        }
        RegistryKeyIterator<RegistryKey> registryKeyIterator = new RegistryKeyIterator<RegistryKey>(nArray[1], nArray[2], false);
        nArray = null;
        return registryKeyIterator;
    }

    public String toNativePath() {
        StringBuffer stringBuffer = new StringBuffer("\\Registry\\");
        if (this.hKey == Integer.MIN_VALUE) {
            stringBuffer.append("Machine\\Software\\Classes\\");
        } else if (this.hKey == -2147483647L) {
            stringBuffer.append("User\\" + RegistryKey.getCurrentUserSid() + "\\");
        } else if (this.hKey == -2147483646L) {
            stringBuffer.append("Machine\\");
        } else if (this.hKey == -2147483645L) {
            stringBuffer.append("Users\\");
        } else if (this.hKey == -2147483643L) {
            stringBuffer.append("Machine\\System\\CurrentControlSet\\Hardware Profiles\\Current\\");
        } else {
            stringBuffer = null;
            return null;
        }
        stringBuffer.append(this.absolutePath());
        return stringBuffer.toString();
    }

    public String toString() {
        if (this.machine != null) {
            return this.machine + "\\" + this.getPath();
        }
        return this.getPath();
    }

    private static String toWindowsName(String string) {
        if (string == null) {
            return DEFAULT_VALUE_NAME;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() != 0 && stringBuffer.charAt(0) == '\\') {
            stringBuffer.deleteCharAt(0);
        }
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '\\' || stringBuffer.charAt(i - 1) != '\\') continue;
            stringBuffer.deleteCharAt(i--);
        }
        return stringBuffer.toString();
    }

    public int unLoadKey() {
        if (!this.canUnLoadKey()) {
            return 5;
        }
        RegistryKey registryKey = this.hKey == -2147483646L ? roots[2] : roots[3];
        long l = registryKey.openKey(131078);
        if (l != 0L) {
            if (!WinRegistryAPI.SetPrivilege(true, SE_BACKUP_NAME_STRING)) {
                registryKey.closeKey(l);
                return 5;
            }
            if (!WinRegistryAPI.SetPrivilege(true, SE_RESTORE_NAME_STRING)) {
                registryKey.closeKey(l);
                return 5;
            }
            int n = WinRegistryAPI.RegUnLoadKey(l, this.absolutePath());
            registryKey.closeKey(l);
            this.lastError = n;
            WinRegistryAPI.SetPrivilege(false, SE_BACKUP_NAME_STRING);
            WinRegistryAPI.SetPrivilege(false, SE_RESTORE_NAME_STRING);
            return n;
        }
        return this.lastError;
    }

    public boolean valueExists(String string) {
        boolean bl = false;
        long[] lArray = this.openKey0(1, this.handles);
        long l = lArray[1];
        if (l != 0L) {
            Object[] objectArray = WinRegistryAPI.RegQueryValueEx(l, string);
            int n = this.lastError = objectArray != null ? (Integer)objectArray[0] : 14;
            if (objectArray != null && this.lastError == 0) {
                objectArray = null;
                bl = true;
            }
        }
        this.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return bl;
    }

    public Iterator<RegistryValue> valuesIterator() {
        int[] nArray = this.getKeyInfo();
        if (nArray == null) {
            return null;
        }
        RegistryValueIterator<RegistryValue> registryValueIterator = new RegistryValueIterator<RegistryValue>(nArray[4], nArray[5], false);
        nArray = null;
        return registryValueIterator;
    }

    public Iterator<String> valueNamesIterator() {
        int[] nArray = this.getKeyInfo();
        if (nArray == null) {
            return null;
        }
        RegistryValueIterator<String> registryValueIterator = new RegistryValueIterator<String>(nArray[4], nArray[5], true);
        nArray = null;
        return registryValueIterator;
    }

    public void view64BitRegistry(boolean bl) {
        String string = System.getProperty("os.version");
        this.view64 = string.compareTo("5.0") <= 0 ? 0 : (bl ? 256 : 512);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.hKey);
        objectOutputStream.writeObject(this.name);
        objectOutputStream.writeObject(this.path);
        objectOutputStream.writeObject(this.absolutePath);
        objectOutputStream.writeBoolean(this.created);
        objectOutputStream.writeInt(this.level);
        objectOutputStream.writeInt(this.lastError);
        objectOutputStream.writeInt(this.view64);
        objectOutputStream.writeObject(this.machine);
    }

    static {
        String string = null;
        try {
            CharSequence charSequence;
            String string2 = null;
            String string3 = System.getProperty("os.arch", "x86");
            if (string3.equalsIgnoreCase("x86")) {
                string2 = "reg";
                string = RegistryKey.getJarFolderName() + "\\" + string2 + ".dll";
            } else {
                string2 = "reg_x64";
                string = RegistryKey.getJarFolderName() + "\\" + string2 + ".dll";
            }
            if (!string.startsWith("\\\\") && new File(string).exists()) {
                System.load(string);
            } else {
                String string4 = System.getProperty("java.version", "1.5.0");
                if (string4.compareTo("1.7.0") < 0 && (charSequence = System.getProperty("java.library.path")) != null) {
                    boolean bl = false;
                    StringBuilder stringBuilder = new StringBuilder((String)charSequence);
                    int n = -1;
                    while ((n = stringBuilder.indexOf(".;")) != -1) {
                        stringBuilder.delete(n, n + 2);
                        bl = true;
                    }
                    if (bl) {
                        stringBuilder.append(";.");
                    }
                    System.setProperty("java.library.path", stringBuilder.toString());
                }
                System.loadLibrary(string2);
            }
            int n = 0;
            try {
                n = RegistryKey.initIDs();
                if (n != 0x1080000) {
                    charSequence = new StringBuffer("JNI version ");
                    ((StringBuffer)charSequence).append(n).append(" doesn't match API version ").append(0x1080000);
                    throw new RegistryException(((StringBuffer)charSequence).toString());
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                StringBuffer stringBuffer = new StringBuffer("JNI version ");
                stringBuffer.append(n).append(" doesn't match API version ").append(0x1080000);
                throw new RegistryException(stringBuffer.toString());
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(unsatisfiedLinkError.getMessage() + "\n\nCould not load \"" + string + "\" file");
            System.exit(1);
        }
        catch (SecurityException securityException) {
            System.err.println(securityException.getMessage());
            System.exit(1);
        }
        roots = new RegistryKey[]{new RegistryKey(Integer.MIN_VALUE), new RegistryKey(-2147483647L), new RegistryKey(-2147483646L), new RegistryKey(-2147483645L), new RegistryKey(-2147483644L), new RegistryKey(-2147483643L), new RegistryKey(-2147483642L)};
        autoExpand = new AtomicBoolean(false);
        computerName = RegistryKey.getComputerName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RegistryValueIterator<E>
    implements Iterator<E> {
        private int index = 0;
        private int numValues;
        private int maxValueNLen;
        private boolean isString;
        private E lastRet = null;

        private RegistryValueIterator(int n, int n2, boolean bl) {
            this.numValues = n;
            this.maxValueNLen = n2;
            this.isString = bl;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.numValues;
        }

        @Override
        public E next() {
            if (this.index >= this.numValues) {
                throw new NoSuchElementException();
            }
            Object object = null;
            long[] lArray = RegistryKey.this.openKey0(1, RegistryKey.this.handles);
            long l = lArray[1];
            if (l != 0L) {
                String string;
                if ((string = WinRegistryAPI.RegEnumValue(l, this.index++, this.maxValueNLen + 1)) == null) {
                    RegistryKey.this.closeKey0(RegistryKey.this.handles, lArray[0]);
                    lArray = null;
                    this.numValues = 0;
                    this.lastRet = null;
                    throw new ConcurrentModificationException();
                }
                if (this.isString) {
                    object = string;
                } else {
                    Object[] objectArray = WinRegistryAPI.RegQueryValueEx(l, string);
                    if (objectArray != null) {
                        if ((Integer)objectArray[0] == 0) {
                            int n = (Integer)objectArray[1];
                            ValueType valueType = RegistryKey.getValueType(n);
                            Object object2 = objectArray[2];
                            if (valueType == null) {
                                object = new RegBinaryValue(RegistryKey.this, string, n, (byte[])object2);
                            } else {
                                switch (valueType) {
                                    case REG_SZ: {
                                        object = new RegStringValue(RegistryKey.this, string, valueType, (String)object2);
                                        break;
                                    }
                                    case REG_EXPAND_SZ: {
                                        object = new RegStringValue(RegistryKey.this, string, valueType, RegistryKey.isAutoExpandEnvironmentVariables() ? RegistryKey.expandEnvironmentVariables((String)object2) : (String)object2);
                                        break;
                                    }
                                    case REG_BINARY: 
                                    case REG_NONE: 
                                    case REG_LINK: 
                                    case REG_RESOURCE_LIST: 
                                    case REG_FULL_RESOURCE_DESCRIPTOR: 
                                    case REG_RESOURCE_REQUIREMENTS_LIST: {
                                        object = new RegBinaryValue(RegistryKey.this, string, valueType, (byte[])object2);
                                        break;
                                    }
                                    case REG_DWORD: 
                                    case REG_DWORD_LITTLE_ENDIAN: 
                                    case REG_DWORD_BIG_ENDIAN: {
                                        object = new RegDWORDValue(RegistryKey.this, string, valueType, (Integer)object2);
                                        break;
                                    }
                                    case REG_MULTI_SZ: {
                                        object = new RegMultiStringValue(RegistryKey.this, string, valueType, (String[])object2);
                                        break;
                                    }
                                    case REG_QWORD: 
                                    case REG_QWORD_LITTLE_ENDIAN: {
                                        object = new RegQWORDValue(RegistryKey.this, string, valueType, (Long)object2);
                                    }
                                }
                            }
                        }
                        objectArray = null;
                    } else {
                        RegistryKey.this.closeKey0(RegistryKey.this.handles, lArray[0]);
                        lArray = null;
                        this.numValues = 0;
                        this.lastRet = null;
                        throw new ConcurrentModificationException();
                    }
                }
                this.lastRet = object;
            } else {
                this.numValues = 0;
                this.lastRet = null;
            }
            RegistryKey.this.closeKey0(RegistryKey.this.handles, lArray[0]);
            lArray = null;
            if (this.numValues == 0) {
                throw new ConcurrentModificationException();
            }
            return (E)object;
        }

        @Override
        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            long[] lArray = RegistryKey.this.openKey0(2, RegistryKey.this.handles);
            long l = lArray[1];
            if (l != 0L) {
                int n = 0;
                n = this.isString ? WinRegistryAPI.RegDeleteValue(l, (String)this.lastRet) : WinRegistryAPI.RegDeleteValue(l, ((RegistryValue)this.lastRet).getName());
                RegistryKey.this.closeKey0(RegistryKey.this.handles, lArray[0]);
                lArray = null;
                this.lastRet = null;
                --this.index;
                --this.numValues;
                if (n != 0) {
                    this.numValues = 0;
                    throw new ConcurrentModificationException();
                }
                return;
            }
            this.numValues = 0;
            this.lastRet = null;
            RegistryKey.this.closeKey0(RegistryKey.this.handles, lArray[0]);
            lArray = null;
            if (this.numValues == 0) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RegistryKeyIterator<E>
    implements Iterator<E> {
        private int index = 0;
        private int numSubKeys;
        private int maxSubKeyLen;
        private boolean isString;
        private E lastRet = null;

        private RegistryKeyIterator(int n, int n2, boolean bl) {
            this.numSubKeys = n;
            this.maxSubKeyLen = n2;
            this.isString = bl;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.numSubKeys;
        }

        @Override
        public E next() {
            if (this.index >= this.numSubKeys) {
                throw new NoSuchElementException();
            }
            Object object = null;
            long[] lArray = RegistryKey.this.openKey0(8, RegistryKey.this.handles);
            long l = lArray[1];
            if (l != 0L) {
                String string;
                if ((string = WinRegistryAPI.RegEnumKeyEx(l, this.index++, this.maxSubKeyLen + 1)) == null) {
                    RegistryKey.this.closeKey0(RegistryKey.this.handles, lArray[0]);
                    lArray = null;
                    this.numSubKeys = 0;
                    this.lastRet = null;
                    throw new ConcurrentModificationException();
                }
                object = this.isString ? string : new RegistryKey(RegistryKey.this.hKey, RegistryKey.this, RegistryKey.this.getPath(), string);
                this.lastRet = object;
            } else {
                this.numSubKeys = 0;
                this.lastRet = null;
            }
            RegistryKey.this.closeKey0(RegistryKey.this.handles, lArray[0]);
            lArray = null;
            if (this.numSubKeys == 0) {
                throw new ConcurrentModificationException();
            }
            return (E)object;
        }

        @Override
        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            long[] lArray = RegistryKey.this.openKey0(65536, RegistryKey.this.handles);
            long l = lArray[1];
            if (l != 0L) {
                int n = 0;
                n = this.isString ? WinRegistryAPI.RegDeleteKey(l, (String)this.lastRet) : WinRegistryAPI.RegDeleteKey(l, ((RegistryKey)this.lastRet).name);
                RegistryKey.this.closeKey0(RegistryKey.this.handles, lArray[0]);
                lArray = null;
                this.lastRet = null;
                --this.index;
                --this.numSubKeys;
                if (n != 0) {
                    this.numSubKeys = 0;
                    throw new ConcurrentModificationException();
                }
                return;
            }
            this.numSubKeys = 0;
            this.lastRet = null;
            RegistryKey.this.closeKey0(RegistryKey.this.handles, lArray[0]);
            lArray = null;
            if (this.numSubKeys == 0) {
                throw new ConcurrentModificationException();
            }
        }
    }

    class KeyDisposer
    implements DisposerRecord {
        List<Long> watchHandles;

        KeyDisposer() {
        }

        public void dispose() {
            RegistryKey.this.closeKey0(0L);
            RegistryKey.this.closeKey0(this.watchHandles, 0L);
        }
    }
}

