/*
 * Decompiled with CFR 0.152.
 */
package com.registry;

import com.registry.RegistryKey;
import com.registry.ValueType;
import com.registry.WinRegistryAPI;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegistryValue
implements Cloneable,
Comparable<RegistryValue>,
Serializable {
    static final long serialVersionUID = -5424474989836803217L;
    protected String name;
    protected ValueType type;
    protected Object value;
    protected RegistryKey key;
    protected int typei;

    RegistryValue() {
        this.key = null;
        this.name = null;
        this.type = null;
        this.value = null;
        this.typei = 0;
    }

    RegistryValue(RegistryKey registryKey, String string, ValueType valueType, Object object) {
        this.key = registryKey;
        this.name = string;
        this.type = valueType;
        this.value = object;
        this.typei = valueType.getValue();
    }

    public Object clone() {
        try {
            RegistryValue registryValue = (RegistryValue)super.clone();
            registryValue.name = this.name;
            registryValue.type = this.type;
            registryValue.value = this.value;
            registryValue.typei = this.typei;
            registryValue.key = this.key;
            return registryValue;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public int compareTo(RegistryValue registryValue) {
        if (registryValue == null) {
            return 1;
        }
        int n = this.key.compareTo(registryValue.key);
        if (n == 0 && (n = this.name.compareToIgnoreCase(registryValue.name)) == 0) {
            int n2;
            int n3;
            if (this.type == null) {
                if (registryValue.type != null && this.typei != registryValue.typei) {
                    n = -1;
                }
            } else if (registryValue.type == null) {
                if (this.type != null && this.typei != registryValue.typei) {
                    n = 1;
                }
            } else {
                n = this.type.compareTo(registryValue.type);
            }
            if (n == 0 && (n = (n3 = this.getByteLength()) - (n2 = registryValue.getByteLength())) == 0) {
                byte[] byArray = this.getByteData();
                byte[] byArray2 = registryValue.getByteData();
                for (int i = 0; i < byArray.length && (n = byArray[i] - byArray2[i]) == 0; ++i) {
                }
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RegistryValue)) {
            return false;
        }
        RegistryValue registryValue = (RegistryValue)object;
        return this.compareTo(registryValue) == 0;
    }

    public RegistryKey getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.key.hashCode() ^ this.name.hashCode() ^ this.typei ^ this.getByteLength();
    }

    int setName(String string) {
        if (!this.name.equalsIgnoreCase(string)) {
            byte[] byArray = this.getByteData();
            this.name = string;
            return this.setByteData(byArray);
        }
        return 87;
    }

    public ValueType getValueType() {
        return this.type;
    }

    public int getValueTypeInt() {
        return this.typei;
    }

    public void setValueType(ValueType valueType) {
        if (!this.type.equals((Object)valueType)) {
            this.typei = valueType.getValue();
            this.type = valueType;
            byte[] byArray = this.getByteData();
            this.setByteData(byArray);
        }
    }

    public void setValueTypeInt(int n) {
        if (this.typei != n) {
            this.typei = n;
            this.type = RegistryKey.getValueType(this.typei);
            byte[] byArray = this.getByteData();
            this.setByteData(byArray);
        }
    }

    public abstract int refreshData();

    public byte[] getByteData() {
        long[] lArray = this.key.openKey0(1);
        long l = lArray[1];
        if (l != 0L) {
            byte[] byArray = this.getByteData(l, this.name);
            this.key.closeKey0(lArray[0]);
            lArray = null;
            return byArray;
        }
        this.key.closeKey0(lArray[0]);
        lArray = null;
        return null;
    }

    private native byte[] getByteData(long var1, String var3);

    public int setByteData(byte ... byArray) {
        long[] lArray = this.key.openKey0(3);
        long l = lArray[1];
        if (l != 0L) {
            int n = this.setByteData(l, this.name, this.typei, byArray);
            if (n == 0) {
                Object[] objectArray;
                this.value = this.typei == 0 || this.typei == 3 || this.typei == 6 || this.typei == 8 || this.typei == 9 || this.typei == 10 ? (Object)byArray : ((objectArray = WinRegistryAPI.RegQueryValueEx(l, this.name)) != null ? objectArray[2] : null);
            }
            this.key.closeKey0(lArray[0]);
            lArray = null;
            return n;
        }
        this.key.closeKey0(lArray[0]);
        lArray = null;
        return this.key.getLastError();
    }

    private native int setByteData(long var1, String var3, int var4, byte[] var5);

    public int getByteLength() {
        long[] lArray = this.key.openKey0(1);
        long l = lArray[1];
        if (l != 0L) {
            int n = this.getByteLength(l, this.name);
            this.key.closeKey0(lArray[0]);
            lArray = null;
            return n;
        }
        this.key.closeKey0(lArray[0]);
        lArray = null;
        return -1;
    }

    private native int getByteLength(long var1, String var3);

    public String toString() {
        return "Name: " + this.name + " Type: " + (Object)((Object)this.type);
    }
}

