/*
 * Decompiled with CFR 0.152.
 */
package com.registry;

import com.registry.RegistryException;
import com.registry.RegistryKey;
import com.registry.WatchData;
import com.registry.event.RegistryEvent;
import com.registry.event.RegistryListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RegistryWatcher {
    private static List<RegistryListener> listenerList = Collections.synchronizedList(new ArrayList());
    private static List<WatchData> watchData = Collections.synchronizedList(new ArrayList());

    public static void addRegistryListener(RegistryListener registryListener) {
        listenerList.add(registryListener);
    }

    public static void removeRegistryListener(RegistryListener registryListener) {
        listenerList.remove(registryListener);
    }

    public static int watchKey(RegistryKey registryKey) {
        return RegistryWatcher.watchKey(registryKey, false, 5);
    }

    public static int watchKey(RegistryKey registryKey, boolean bl) {
        return RegistryWatcher.watchKey(registryKey, bl, 5);
    }

    public static int watchKey(RegistryKey registryKey, boolean bl, int n) {
        if (listenerList.size() == 0) {
            throw new RegistryException("Illegal State: At least one listener must be registered.");
        }
        if (!registryKey.exists() || n == 0) {
            return -1;
        }
        for (int i = 0; i < watchData.size(); ++i) {
            WatchData watchData = RegistryWatcher.watchData.get(i);
            if (!watchData.getKey().equals(registryKey)) continue;
            watchData.stop();
            watchData.setWatchSubtree(bl);
            watchData.setNotifyFilter(n);
            watchData.start();
            return watchData.getID();
        }
        WatchData watchData = new WatchData(registryKey, bl, n);
        RegistryWatcher.watchData.add(watchData);
        watchData.start();
        return watchData.getID();
    }

    public static void removeKey(RegistryKey registryKey) {
        for (int i = 0; i < watchData.size(); ++i) {
            WatchData watchData = RegistryWatcher.watchData.get(i);
            if (!watchData.getKey().equals(registryKey)) continue;
            watchData.stop();
            RegistryWatcher.watchData.remove(i);
            return;
        }
    }

    public static void removeID(int n) {
        for (int i = 0; i < watchData.size(); ++i) {
            WatchData watchData = RegistryWatcher.watchData.get(i);
            if (watchData.getID() != n) continue;
            watchData.stop();
            RegistryWatcher.watchData.remove(i);
            return;
        }
    }

    static void removeWatch(WatchData watchData) {
        for (int i = 0; i < RegistryWatcher.watchData.size(); ++i) {
            WatchData watchData2 = RegistryWatcher.watchData.get(i);
            if (!watchData2.equals(watchData)) continue;
            watchData2.stop();
            RegistryWatcher.watchData.remove(i);
            return;
        }
    }

    static void fireNotifyChange(RegistryEvent registryEvent) {
        for (int i = 0; i < listenerList.size(); ++i) {
            RegistryListener registryListener = listenerList.get(i);
            registryListener.notifyChange(registryEvent);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                for (int i = 0; i < watchData.size(); ++i) {
                    ((WatchData)watchData.get(i)).stop();
                }
            }
        });
    }
}

