/*
 * Decompiled with CFR 0.152.
 */
package com.registry;

import com.registry.RegistryKey;
import com.registry.RegistryNotifyDispatchThread;
import com.registry.Worker;

final class WatchData {
    static final int WAIT_OBJECT_0 = 0;
    static final int WAIT_ABANDONED = 80;
    static final int WAIT_TIMEOUT = 102;
    static final int WAIT_FAILED = -1;
    static final int INFINITE = -1;
    static int ID_Counter = 0;
    static final Thread rndt = new RegistryNotifyDispatchThread();
    private RegistryKey key;
    private Thread worker;
    private boolean watchSubtree;
    private int dwNotifyFilter;
    private int id;
    private boolean isRunning;

    WatchData(RegistryKey registryKey) {
        this(registryKey, false, 5);
    }

    WatchData(RegistryKey registryKey, boolean bl) {
        this(registryKey, bl, 5);
    }

    WatchData(RegistryKey registryKey, boolean bl, int n) {
        this.key = registryKey;
        this.watchSubtree = bl;
        this.dwNotifyFilter = n;
        this.id = ID_Counter++;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof WatchData)) {
            return false;
        }
        WatchData watchData = (WatchData)object;
        return this.key.equals(watchData.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public int getID() {
        return this.id;
    }

    public RegistryKey getKey() {
        return this.key;
    }

    public synchronized boolean isRunning() {
        return this.isRunning && this.worker.isAlive();
    }

    public synchronized void setWatchSubtree(boolean bl) {
        this.watchSubtree = bl;
    }

    public synchronized void setNotifyFilter(int n) {
        this.dwNotifyFilter = n;
    }

    public synchronized void start() {
        if (!this.isRunning) {
            this.worker = new Worker(this, this.key, this.watchSubtree, this.dwNotifyFilter, this.id);
            this.worker.start();
            this.isRunning = true;
        }
    }

    public synchronized void stop() {
        if (this.isRunning) {
            ((Worker)this.worker).terminate();
            this.worker.interrupt();
            this.worker = null;
            this.isRunning = false;
        }
    }

    static native long CreateEvent();

    static native int WaitForSingleObject(long var0, int var2);

    static native void CloseHandle(long var0);

    static {
        rndt.start();
    }
}

