/*
 * Decompiled with CFR 0.152.
 */
package com.registry;

import com.registry.RegistryKey;
import com.registry.RegistryNotifyDispatchThread;
import com.registry.RegistryWatcher;
import com.registry.WatchData;
import com.registry.event.RegistryEvent;
import java.util.LinkedList;

final class Worker
extends Thread {
    private WatchData wd;
    private RegistryKey key;
    private LinkedList<Long> handles;
    private boolean watchSubtree;
    private int dwNotifyFilter;
    private int id;
    private long hKey = 0L;
    private long event = 0L;
    private boolean isTerminated = false;

    Worker(WatchData watchData, RegistryKey registryKey, boolean bl, int n, int n2) {
        this.wd = watchData;
        this.key = registryKey;
        this.handles = new LinkedList();
        this.watchSubtree = bl;
        this.dwNotifyFilter = n;
        this.id = n2;
        this.setPriority(4);
    }

    private boolean exists() {
        boolean bl = false;
        long[] lArray = this.key.openKey0(131097, this.handles);
        long l = lArray[1];
        if (l != 0L || this.key.getLastError() == 5) {
            bl = true;
        }
        this.key.closeKey0(this.handles, lArray[0]);
        lArray = null;
        return bl;
    }

    public void terminate() {
        this.isTerminated = true;
    }

    public void run() {
        this.key.setWatchHandles(this.handles);
        long[] lArray = this.key.openKey0(16, this.handles);
        this.hKey = lArray[1];
        if (this.hKey == 0L) {
            RegistryWatcher.removeWatch(this.wd);
            lArray = null;
            return;
        }
        this.event = WatchData.CreateEvent();
        if (this.event == 0L) {
            this.terminate();
            this.key.closeKey0(this.handles, lArray[0]);
            RegistryWatcher.removeWatch(this.wd);
            lArray = null;
            return;
        }
        boolean bl = false;
        while (!this.isTerminated) {
            if (!this.exists()) {
                bl = true;
                break;
            }
            if (this.isInterrupted()) break;
            int n = 0;
            try {
                n = RegistryKey.notifyChange(this.hKey, this.watchSubtree, this.dwNotifyFilter, this.event);
                if (n != 0) {
                    bl = true;
                    break;
                }
                if (WatchData.WaitForSingleObject(this.event, -1) != 0) continue;
                if (this.isTerminated) break;
                RegistryEvent registryEvent = new RegistryEvent(this.id, this.key);
                ((RegistryNotifyDispatchThread)WatchData.rndt).pushEvent(registryEvent);
            }
            catch (InterruptedException interruptedException) {
                if (n == 0) continue;
                bl = true;
            }
        }
        this.key.closeKey0(this.handles, lArray[0]);
        WatchData.CloseHandle(this.event);
        this.event = 0L;
        lArray = null;
        if (bl) {
            RegistryWatcher.removeWatch(this.wd);
        }
    }
}

