/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.cici.logger;

import com.jacky.cici.logger.LogValue;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.concurrent.Semaphore;

public abstract class AbstractLogger {
    public static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
    protected FileWriter os = null;
    protected Semaphore osSem = new Semaphore(1);
    protected boolean screen = false;
    protected long writesize = 0L;
    protected File file = null;

    public void log(LogValue lv) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(simpleDateFormat.format(lv.time));
        sbuff.append(" [" + lv.Level + "] ");
        if (lv.msg instanceof Exception) {
            Exception ex = (Exception)lv.msg;
            ByteArrayOutputStream bao = new ByteArrayOutputStream(2048);
            PrintWriter pw = new PrintWriter(bao, true);
            ex.printStackTrace(pw);
            sbuff.append("\n" + bao.toString());
        } else {
            sbuff.append(lv.msg.toString());
        }
        sbuff.append("\n");
        try {
            this.osSem.acquire();
            this.os.append(sbuff.toString());
            this.os.flush();
            this.osSem.release();
            if (this.screen) {
                System.out.print(sbuff.toString());
            }
            this.writesize += (long)sbuff.toString().getBytes().length;
        }
        catch (Exception ex) {
            System.out.println("file:" + this.file.getAbsoluteFile());
            ex.printStackTrace();
        }
    }
}

