/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.cici.logger;

import com.jacky.cici.logger.AbstractLogger;
import com.jacky.cici.logger.LogFileComparator;
import com.jacky.cici.logger.LogFileFilter;
import com.jacky.cici.logger.LogValue;
import java.io.File;
import java.io.FileWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class DateFileLogger
extends AbstractLogger {
    protected String[] files = null;
    protected String path = null;
    protected String filename = null;
    protected int day = 0;
    private Date curDate = null;
    protected SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");

    DateFileLogger(String path, String filename, int day, boolean Screen) {
        this.path = path;
        this.filename = filename;
        this.day = day <= 0 ? 10 : day;
        this.screen = Screen;
        this.files = new String[day];
        try {
            this.createPrintWriter(new Date(System.currentTimeMillis()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void log(LogValue lv) {
        try {
            if (this.curDate == null || this.os == null) {
                this.createPrintWriter(lv.time);
            } else {
                String t2;
                String t1 = this.sdf1.format(lv.time);
                if (t1.compareTo(t2 = this.sdf1.format(this.curDate)) != 0) {
                    this.createPrintWriter(lv.time);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.log(lv);
    }

    private void createPrintWriter(Date d) throws Exception {
        block13: {
            int cnt = 0;
            File tfile = new File(this.path);
            File[] tfiles = tfile.listFiles(new LogFileFilter(this.filename));
            Arrays.sort(tfiles, new LogFileComparator());
            cnt = tfiles.length;
            int i = 0;
            while (i < cnt) {
                this.files[i] = tfiles[i].getName();
                ++i;
            }
            if (cnt == 0) {
                this.curDate = new Date(System.currentTimeMillis());
                String fix = this.sdf1.format(this.curDate);
                String filename1 = String.valueOf(this.filename) + fix + ".log";
                this.file = new File(String.valueOf(this.path) + File.separator + filename1);
                this.files[cnt] = filename1;
            } else if (cnt < this.day) {
                String date = tfiles[cnt - 1].getName();
                date = date.substring(0, date.length() - ".log".length());
                date = date.substring(date.length() - "yyyy-mm-dd".length());
                try {
                    if (this.curDate == null) {
                        this.curDate = this.sdf1.parse(date);
                        this.file = tfiles[cnt - 1];
                        break block13;
                    }
                    if (this.curDate.compareTo(d) == 0) {
                        this.file = tfiles[cnt - 1];
                        break block13;
                    }
                    String fix = this.sdf1.format(d);
                    String filename1 = String.valueOf(this.filename) + fix + ".log";
                    this.file = new File(String.valueOf(this.path) + File.separator + filename1);
                    this.files[cnt] = filename1;
                    this.curDate = d;
                }
                catch (ParseException ex1) {
                    System.out.println("can convert string to date!");
                    ex1.printStackTrace();
                }
            } else {
                String filename1;
                i = 0;
                while (i < this.day) {
                    if (i == 0) {
                        File f = new File(String.valueOf(this.path) + File.separator + this.files[i]);
                        f.delete();
                    } else {
                        this.files[i - 1] = this.files[i];
                    }
                    ++i;
                }
                String fix = this.sdf1.format(d);
                this.files[this.day - 1] = filename1 = String.valueOf(this.filename) + fix + ".log";
                this.file = new File(String.valueOf(this.path) + File.separator + this.files[this.day - 1]);
                this.curDate = d;
            }
        }
        this.osSem.acquire();
        if (this.os != null) {
            this.os.close();
        }
        this.os = new FileWriter(this.file, true);
        this.osSem.release();
    }
}

