/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.cici.logger;

import com.jacky.cici.interfaces.ILogger;
import com.jacky.cici.logger.AbstractLogger;
import com.jacky.cici.logger.DateFileLogger;
import com.jacky.cici.logger.LogValue;
import com.jacky.cici.logger.RollingFileLogger;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;

public class MyLogger
implements ILogger {
    private static final LinkedBlockingDeque<LogValue> msgL = new LinkedBlockingDeque();
    private static final ConcurrentSkipListMap<String, AbstractLogger> logM = new ConcurrentSkipListMap();
    private static Runnable logThread = new Thread(){

        @Override
        public void run() {
            System.out.println(String.valueOf(AbstractLogger.simpleDateFormat.format(new Date())) + " log thread is working  .........");
            while (true) {
                try {
                    while (true) {
                        LogValue lv = (LogValue)msgL.take();
                        AbstractLogger al = (AbstractLogger)logM.get(lv.name);
                        if (al != null) {
                            al.log(lv);
                        }
                        Thread.yield();
                    }
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
    };
    private static Executor execFixed = Executors.newFixedThreadPool(5);
    private String logname = null;

    static {
        execFixed.execute(logThread);
        execFixed.execute(logThread);
        execFixed.execute(logThread);
        execFixed.execute(logThread);
        execFixed.execute(logThread);
    }

    public static synchronized ILogger getDateLogger(String path, String filename, int day, boolean Screen) {
        path = MyLogger.checkParamter(path);
        String token = String.valueOf(path) + ":date:" + filename;
        MyLogger ml = null;
        ml = new MyLogger();
        ml.setLogName(token);
        if (!logM.containsKey(token)) {
            logM.put(token, new DateFileLogger(path, filename, day, Screen));
        }
        return ml;
    }

    public static synchronized ILogger getFileLogger(String path, String filename, int size, int count, boolean isScreen) {
        path = MyLogger.checkParamter(path);
        MyLogger ml = new MyLogger();
        String token = String.valueOf(path) + ":file:" + filename;
        ml.setLogName(token);
        if (!logM.containsKey(token)) {
            logM.put(token, new RollingFileLogger(path, filename, size, count, isScreen));
        }
        return ml;
    }

    private static synchronized String checkParamter(String path) {
        File f;
        if (path == null && (path = System.getProperty("user.dir")) == null) {
            path = ".";
        }
        if (!(f = new File(path)).exists()) {
            if (!f.mkdirs()) {
                path = System.getProperty("user.dir");
                if (path == null) {
                    path = ".";
                }
            } else {
                path = f.getAbsolutePath();
            }
        } else {
            path = f.getAbsolutePath();
        }
        return path;
    }

    protected void setLogName(String name) {
        this.logname = name;
    }

    @Override
    public void logInfo(Object msg) {
        this.log("INFO", msg);
    }

    @Override
    public void logWarn(Object msg) {
        this.log("ARN", msg);
    }

    @Override
    public void logErro(Object msg) {
        this.log("ERRO", msg);
    }

    @Override
    public void logSevere(Object msg) {
        this.log("SEVE", msg);
    }

    protected void log(String level, Object msg) {
        LogValue lv = new LogValue();
        lv.time = new Date(System.currentTimeMillis());
        lv.Level = level;
        lv.name = this.logname;
        lv.msg = msg;
        msgL.add(lv);
    }

    public static void main(String[] arg) {
        int i = 0;
        ILogger il = MyLogger.getFileLogger("f:/dubug", "test", 1, 1, true);
        byte[] content = new byte[10240];
        Arrays.fill(content, (byte)111);
        while (true) {
            il.logErro("test2==" + i + new String("adsfhjahdfakjshfkjahfajhsdkhfkjah" + new String(content) + "kdsfhkjahfkjahdkjsfhjkadhfkjadhfkjahfkjh"));
            if (i % 1000 != 0) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

